#ifndef tomdisp_H
#define tomdisp_H "$Id: tomdisp.h 1.18 2007/03/11 13:14:42 ilgiga Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/tom/rcs/tomdisp.h $
//	file version:	$Revision: 1.18 $
//
//	purpose:	Define the Tracer dispatcher class/singleton
//				Responsibilities:
//				1. Get messages/errors from AOMDispatcher and dispatch them
//				to TOM items (or TOMSystem if destination == NULL
//				2. Collect messages from TOM items and send them to the 
//				AOMDispatcher.
//
//	author(s):	  Yachin Pnueli
//	date started:	28.5.96
//	date changed:	$Date: 2007/03/11 13:14:42 $
//	last change by:	$Author: ilgiga $
//
//	(c) Copyright Telelogic 1995, 2007
//

#ifdef USING_DLL
#include <Dll/RP_ANIM_DLL/rp_anim_dll_definition.h>
#else
#define RP_ANIM_DLL
#endif

class TOMProxyItem;
class OMSData;

class AnimMessage;
class AnimMessageTranslator;
//
//	TOMDispatcher	-	The Tracer dispatcher (commuincates with the executable
//

// Must not include toxf.h - as it is also "included" in aomdisp.h

class RP_ANIM_DLL TOMDispatcher {
private:
	static TOMDispatcher* theDispatcher;

	// the time the last messager arrived
	timeUnit m_msgTime;

	// To prevent spurious constructions
	TOMDispatcher();

	// a translator used to convert OMSData to AnimMessage
	// instances, and vice versa.
	AnimMessageTranslator *animMessageTranslator;


public:
	~TOMDispatcher(); 
	void handleMessage(OMSData* s, void* pSocket = NULL);

	// Implementation of singleton
	static TOMDispatcher * instance() { return theDispatcher; }
	static TOMDispatcher * createInstance() {
		if (theDispatcher==NULL) new TOMDispatcher();
		return theDispatcher;
	}

	void sendMessage(OMSData* s); 

	void encodeAndSendMessage(AnimMessage *msg);

	void quitTOM();

	// getter and setter of m_msgTime
	timeUnit getMsgTime() const { return m_msgTime; }
	void setMsgTime(const timeUnit t) { m_msgTime = t; }

	void sendForeignMessage(OMString& payload, void* destOrSource = NULL);

};

//
// $Log: tomdisp.h $
// Revision 1.18  2007/03/11 13:14:42  ilgiga
// Change copyright comment
// Revision 1.17  2007/03/04 15:07:31  ilgiga
// Telelogic instead of i-Logix
// Revision 1.16  2006/10/31 08:58:51  ccohen
// support running multiple animation processes.
// Revision 1.15  2006/09/27 11:47:35  eldad
// Foreign messages to application
// Revision 1.14  2002/07/29 09:36:25  Eldad
// Anim Operations Calls.
// Revision 1.13.1.1  2000/01/31 09:51:48  Eldad
// Duplicate revision
// Revision 1.12.1.2  2000/01/27 09:39:29  amos
// add a member m_msgTime that store the time of the last arriving message.
// add getter and setter to m_msgTime
// Revision 1.12.1.1  1999/11/08 15:09:35  amos
// Duplicate revision
// Revision 1.11  1999/02/16 05:56:54  yachin
// Speed up of constructors
// Revision 1.10  1996/11/24 12:40:37  yachin
// Revision 1.9  1996/10/09 07:37:05  yachin
// Revision 1.8  1996/10/02 13:55:48  yachin
// Fix the double event bug
// Revision 1.7  1996/09/16 13:44:27  yachin
// Revision 1.6  1996/09/16 09:28:29  yachin
// Revision 1.5  1996/08/29 07:09:56  ofer
// Revision 1.4  1996/08/06 12:52:05  yachin
// Version for Prototype 4
// Revision 1.3  1996/07/22 11:30:29  yachin
// Revision 1.2  1996/06/19 10:21:26  yachin
// Revision 1.1  1996/06/17 05:40:42  yachin
//

#endif
