#ifndef tombrk_H
#define tombrk_H "$Id: tombrk.h 1.16 2007/03/11 13:14:41 ilgiga Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/tom/rcs/tombrk.h $
//	file version:	$Revision: 1.16 $
//
//	purpose:	The Breakpoint reasons
//
//	author(s):	  Yachin Pnueli
//	date started:	16.10.96
//	date changed:	$Date: 2007/03/11 13:14:41 $
//	last change by:	$Author: ilgiga $
//
//	(c) Copyright Telelogic 1995, 2007
//
#include "tomproxy.h"
#include <omcom/ombrk.h>

#define BrkOnInstanceCreated "INSTANCECREATED" // + nothing
#define BrkOnInstanceDeleted "INSTANCEDELETED" // + nothing

#define BrkOnTerminationReached "TERMINATION" // + nothing
#define BrkOnEnteredState "STATEENTERED" // + state handle
#define BrkOnExitedState "STATEEXITED" // + state handle
#define BrkOnState "STATE" // + state handle

#define BrkOnRelationConnected "RELATIONCONNECTED" // + relation handle
#define BrkOnRelationDisconnected "RELATIONDISCONNECTED" // + relation handle
#define BrkOnRelationCleared "RELATIONCLEARED" // + relation handle
#define BrkOnRelation "RELATION" // + relation handle

// Currently only en'block - stop when any attribute was modified
// In future - name and possibly value
#define BrkOnAttributeValues "ATTRIBUTE" // + attribute values

#define BrkOnGotControl "GOTCONTROL" // + nothing
#define BrkOnLostControl "LOSTCONTROL" // + nothing
// #define BrkOnModifyControl "Modify Control" // + current set

// Currently only en'block - stop when any method named so
// In future - signature and possibly values
#define BrkOnMethodCalled "OPERATION" // + method name
#define BrkOnMethodReturned "OPERATIONRETURNED" // + method name
#define BrkOnEventSent "EVENTSENT" // + event name
#define BrkOnEventReceived "EVENTRECEIVED" // + event name
//#define BrkOnTimeoutSet "Timeout Set" // + state name
//#define BrkOnTimeoutCancelled "Timeout Cancelled" // + state name

class RP_ANIM_DLL TOMBreakPoint: public OMBreakPoint {
public:
	TOMBreakPoint(OMNotify theType,
				 void * theItem,
				 const char * theData=""):
			OMBreakPoint(theType, theItem, theData) { }
	OMNotify getType() const { return myType; }
	char * getData() { return myData.GetBuffer(0); }
	void serialize(OMSData&);
	OMBoolean matchBreakPoint(OMNotify theType,
				 void * theItem,
				 const char *theData) {
		return (myType == theType || theType == allValues) &&
			   (myItem == theItem || theItem == NULL) &&
			   (myData == theData || 
					!strcmp(theData,"") /* &&(theType == allValues || theItem ==NULL)*/);
	}
};


class RP_ANIM_DLL TOMBreakPointManager: public TOMProxyItem {
	static TOMBreakPointManager* _instance;
	OMList<TOMBreakPoint *> activeList;
	OMList<TOMBreakPoint *> frozenList;

	void _freezeBreakPoint(TOMBreakPoint *bp);
	void _reviveBreakPoint(TOMBreakPoint *bp);
	void _removeBreakPoint(TOMBreakPoint *bp);
	void sendMessage(OMNotify theType, 
					 void * theItem, 
					 const char *theData,
					 OMNotify what);
	void _showYourself(TOMUniversalObserver* , int&);
public:
	TOMBreakPointManager(void* theReal)
		:TOMProxyItem(	theReal,
						"Breakpoint Manager",
						omProxyBreakPointManager) { }
	virtual ~TOMBreakPointManager() { _instance = NULL; }
	
	OMBoolean addBreakPoint(OMNotify theType, void * theItem, const char *theData="");
	OMBoolean freezeBreakPoint(OMNotify theType, void * theItem, const char *theData="");
	OMBoolean reviveBreakPoint(OMNotify theType, void * theItem, const char *theData="");
	OMBoolean removeBreakPoint(OMNotify theType, void * theItem, const char *theData="");

	void handleMessage(OMNotify r, TOMSData* s, OMSPosition p);
	virtual void handleMessage(AnimMessage* msg) { TOMProxyItem::handleMessage(msg); }

	static TOMBreakPointManager* instance() { return _instance; }
	static void createInstance(void* theReal) { 
		if (_instance==NULL) _instance = new TOMBreakPointManager(theReal); }

	OMList<TOMBreakPoint *> *getActiveList() { return &activeList; }
	OMList<TOMBreakPoint *> *getFrozenList() { return &frozenList; }

};
//
// $Log: tombrk.h $
// Revision 1.16  2007/03/11 13:14:41  ilgiga
// Change copyright comment
// Revision 1.15  2007/03/04 15:07:30  ilgiga
// Telelogic instead of i-Logix
// Revision 1.14  2002/08/06 08:25:00  Eldad
// Fixed warnings in Solaros Adaptor.
// Revision 1.13  1999/11/08 15:09:33  zvika
// Add DLLs.
// Revision 1.12  1999/02/16 05:56:52  yachin
// Speed up of constructors
// Revision 1.11  1998/08/02 15:07:40  beery
// Revision 1.10  1997/04/07 23:07:08  ofer
// Move file names and includes to lowercase
// so UNIX will work with lowercase versions
// Revision 1.9  1997/03/10 09:57:10  yachin
// make "" wildcard string in all cases
// Revision 1.8  1997/02/12 11:15:38  yachin
// Rewrite of TOMProxyItem(...)
// Revision 1.7  1997/01/21 11:08:44  yachin
// changed _int32 to int
// Revision 1.6  1996/11/24 12:40:35  yachin
// Revision 1.5  1996/11/05 13:45:34  yachin
// Change getType to non virtual add myType attribute
// Revision 1.4  1996/10/29 08:28:46  yachin
// Revision 1.3  1996/10/28 09:49:57  yachin
// Revision 1.2  1996/10/23 10:10:00  yachin
// Revision 1.1  1996/10/21 11:39:51  yachin
// Initial revision
//


#endif
