#ifndef tomattr_H
#define tomattr_H "$Id: tomattr.h 1.17 2007/03/11 13:14:41 ilgiga Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/tom/rcs/tomattr.h $
//	file version:	$Revision: 1.17 $
//
//	purpose: define the TOM Attribute handler class	
//
//	author(s):	Yachin Pnueli
//	date started:	22.5.96
//	date changed:	$Date: 2007/03/11 13:14:41 $
//	last change by:	$Author: ilgiga $
//
//	(c) Copyright Telelogic 1995, 2007
//

//	An object responsible for correctly handleing attrinute values
#include "toxf.h"

class RP_ANIM_DLL TOMAttributeItem {
protected:
	char * attrName;
	void * attrValue;
public:
	virtual ~TOMAttributeItem()	{ delete attrName; }
	TOMAttributeItem(char * name, void * value) {
		attrName = name;
		attrValue = value;
	}
	char * getName() const { return attrName; }
	virtual void getValue(OMString &, 
			const TOMProxyItem * /* context */ = OMSystemContext) const { }
};

class TOMAttributes: public OMList<TOMAttributeItem *> {
	TOMProxyItem * myInstance;
	TOMSData attrs;
	OMList<TOMAttributeItem *> changeList;
public:
	virtual ~TOMAttributes();
	TOMAttributes(TOMProxyItem *theInstance) { 
		myInstance = theInstance;
		attrs = "";
	}
	void reset() { attrs = ""; removeAll(); }
	OMList<TOMAttributeItem *>* getChangeList() { return &changeList; }
	void newAttributeValues(TOMSData*,OMSPosition);
	void updateAttributeValues(TOMSData*,OMSPosition);
};

//
// $Log: tomattr.h $
// Revision 1.17  2007/03/11 13:14:41  ilgiga
// Change copyright comment
// Revision 1.16  2007/03/04 15:07:29  ilgiga
// Telelogic instead of i-Logix
// Revision 1.15  2000/12/25 10:08:33  amos
// move to warning level 4
// Revision 1.14  1999/11/08 15:09:33  zvika
// Add DLLs.
// Revision 1.13  1999/02/16 05:56:51  yachin
// Speed up of constructors
// Revision 1.12  1996/11/24 12:40:35  yachin
// Revision 1.11  1996/10/09 07:37:04  yachin
// Revision 1.10  1996/10/02 13:55:47  yachin
// Fix the double event bug
// Revision 1.9  1996/09/16 09:31:34  yachin
// Revision 1.8  1996/09/16 09:28:28  yachin
// Revision 1.7  1996/08/29 11:37:14  ofer
// Revision 1.6  1996/08/14 12:40:23  yachin
// Seperate TOM Masks from AOM Masks. Fix bugs with attr. and states
// Revision 1.5  1996/08/06 12:52:04  yachin
// Version for Prototype 4
// Revision 1.4  1996/07/04 12:38:48  yachin
// Bug fixes and handleing static methods
// Revision 1.3  1996/07/03 12:45:48  yachin
// Fixing bugs for "const" and "static
// enhancements for attributes and indentation
// Revision 1.2  1996/06/19 10:21:24  yachin
// Revision 1.1  1996/06/17 05:40:39  yachin
// Initial revision
//

#endif
