#ifndef TOMPartObserver_H
#define TOMPartObserver_H "$Id: TOMPartObserver.h 1.4 2007/03/11 13:14:40 ilgiga Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/tom/rcs/TOMPartObserver.h $
//	file version:	$Revision: 1.4 $
//
//	purpose: An interface to notify external 
//  observers that an interaction occured with
//  a part of a TOMInstance they are observing
//  Note: the TOMInstance* are the actual instances 
//  it is up to the observer to verify that these
//  are really parts of the TOMInstance they observer
//
//	author(s):	Eldad Palachi
//	date started:	
//	date changed:	$Date: 2007/03/11 13:14:40 $
//	last change by:	$Author: ilgiga $
//
//	(c) Copyright Telelogic 2003, 2007
//

class TOMInstance;

class RP_ANIM_DLL TOMPartObserver
{

public:

	// a notification that a TOMInstance is identified as a part
	virtual void notifyPartConnected(TOMInstance* /*theOwner*/,
		TOMInstance* /*thePart*/) { }
	
	virtual void notifyPartEventReceived(TOMInstance * /* sender */,
		TOMInstance * /* receiver */,
		OMString /* event */,
		void* /* eventId */,
		TOMInstance* /* theOwner */) { }

	virtual void notifyPartEventSent(TOMInstance * /* sender */,
		TOMInstance * /* receiver */,
		OMString /* event */,
		void* /* eventId */,
		TOMInstance* /* theOwner */) { }
	
	virtual void notifyPartMethodCalled(TOMInstance* /* caller */,
		TOMInstance* /* called */,
		OMString /* method */,
		OMMethodType /* mType */,
		TOMInstance* /* theOwner */) { }
	
	virtual void notifyPartMethodReturned(TOMInstance* /* caller */,
		TOMInstance* /* called */,
		OMString /* method */,
		OMMethodType /* mType */,
		TOMInstance* /* theOwner */) { }
};

//
// $Log: TOMPartObserver.h $
// Revision 1.4  2007/03/11 13:14:40  ilgiga
// Change copyright comment
// Revision 1.3  2007/03/04 15:07:28  ilgiga
// Telelogic instead of i-Logix
// Revision 1.2  2003/12/25 12:05:50  eldad
// Black Box Animation 
// Revision 1.1  2003/12/24 14:30:17  eldad
// Initial revision
//

#endif
