//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: AbstractLayer
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/os.h $
//!	File version	: $Revision: 1.73 $
//
//!	Date changed	: $Date: 2007/04/06 07:08:20 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef os_H 

#define os_H 

#include "rawtypes.h"
#include "OXFManager.h"
#include "IOxfEventGenerationParams.h"

//----------------------------------------------------------------------------
// os.h                                                                  
//----------------------------------------------------------------------------

template <class  Concept> class OMList;
class OMOS;
class OMOSConnectionPort;
class OMOSEventFlag;
class OMOSFactory;
class OMOSMessageQueue;
class OMOSMutex;
class OMOSSemaphore;
class OMOSSocket;
class OMOSThread;
class OMOSTimer;
class OMSData;

//## package Design::oxf::Adapters::AbstractLayer 


// A generic adapter package.
// This adapter doesn't contain any implementation, instead it describes the API so one can copy the adapter and add 
// specific implementation.


// Used by the connection port implementation
//## attribute MAX_LEN_STR 
const int MAX_LEN_STR = 6;

//## package Design::oxf::Adapters::AbstractLayer 


// Mutex (binary semaphore) abstraction.
// The mutex must allow recursive lock policy.
// This means that once a thread obtained the mutex it can call lock() any number of times and pass.
// The mutex is released only when the number of unlock() calls is equal to the number of lock() calls done by the 
// owner thread.
//## class OMOSMutex 
class RP_FRAMEWORK_DLL OMOSMutex  {

//#[ ignore 
// override new & delete operators
OM_DECLARE_FRAMEWORK_MEMORY_ALLOCATION_OPERATORS

//#]

////    Constructors and destructors    ////
public :

    // Virtual destructor to enable polymorphic deletion
    //## operation ~OMOSMutex() 
    virtual ~OMOSMutex() {
        //#[ operation ~OMOSMutex() 
        //#]
    }
    


////    Operations    ////
public :
    
    // backward compatibility support for non OSE applications
    //## operation free() 
    
    //#[ ignore 
    #ifndef OM_OS_USE_FREE
    //#]
    inline virtual void free() {
        //#[ operation free() 
        unlock();
        //#]
    }
    
    //#[ ignore 
    
    #endif //OM_OS_USE_FREE
    //#]
    
    
    // get the OS implementation
    //## operation getOsHandle() const 
    virtual void * getOsHandle() const=0;
    
    // obtain the mutex
    //## operation lock() 
    virtual void lock()=0;
    
    // release the mutex
    //## operation unlock() 
    virtual void unlock()=0;


};
//## package Design::oxf::Adapters::AbstractLayer 


// Event flag abstraction.
// Used for execution synchronization between threads.
// Initially the event flag should have no tokens - if the first call is to wait(), the caller should block.
//## class OMOSEventFlag 
class RP_FRAMEWORK_DLL OMOSEventFlag  {

//#[ ignore 
// override new & delete operators
OM_DECLARE_FRAMEWORK_MEMORY_ALLOCATION_OPERATORS

//#]

////    Constructors and destructors    ////
public :
    
    // Virtual destructor to enable polymorphic deletion
    //## operation ~OMOSEventFlag() 
    virtual ~OMOSEventFlag() {
        //#[ operation ~OMOSEventFlag() 
        //#]
    }
    


////    Operations    ////
public :
    
    // get the real OS element
    //## operation getOsHandle() const 
    virtual void * getOsHandle() const=0;
    
    // Reset the event flag.
    // All waiting threads should be signaled.
    // The next call to wait() should block
    //## operation reset() 
    virtual void reset()=0;
    
    // Signal the first waiting thread.
    // If there are no threads waiting, increase the token count (following call to wait() pass without blocking).
    //## operation signal() 
    virtual void signal()=0;
    
    // Wait for a token or a timeout.
    // Argument int t : 
    // Wait timeout. t == -1 is wait forever
    //## operation wait(int) 
    virtual void wait(int t = -1)=0;


};
//## package Design::oxf::Adapters::AbstractLayer 


// Semaphore abstraction.
// This class is not used by the framework.
// It is provided for the completeness of the OS abstraction.
//## class OMOSSemaphore 
class RP_FRAMEWORK_DLL OMOSSemaphore  {

//#[ ignore 
// override new & delete operators
OM_DECLARE_FRAMEWORK_MEMORY_ALLOCATION_OPERATORS

//#]

////    Constructors and destructors    ////
public :
    
    // Virtual destructor to enable polymorphic deletion
    //## operation ~OMOSSemaphore() 
    virtual ~OMOSSemaphore() {
        //#[ operation ~OMOSSemaphore() 
        //#]
    }
    


////    Operations    ////
public :
    
    // get the real OS element
    //## operation getOsHandle() const 
    virtual void * getOsHandle() const=0;
    
    // signal the waiting threads
    //## operation signal() 
    virtual void signal()=0;
    
    // wait on the semaphore
    // Argument long timeout : 
    // wait timeout time in time units, -1 means forever
    //## operation wait(long) 
    virtual bool wait(long timeout = -1)=0;


};
//## package Design::oxf::Adapters::AbstractLayer 


// Message queue abstraction.
// The queue is expected to pass pointers to the messages rather than the data itself.
//## class OMOSMessageQueue 
class RP_FRAMEWORK_DLL OMOSMessageQueue  {

//#[ ignore 
// override new & delete operators
OM_DECLARE_FRAMEWORK_MEMORY_ALLOCATION_OPERATORS

//#]

////    Constructors and destructors    ////
public :
    
    // Virtual destructor to enable polymorphic deletion
    //## operation ~OMOSMessageQueue() 
    virtual ~OMOSMessageQueue() {
        //#[ operation ~OMOSMessageQueue() 
        //#]
    }
    


////    Operations    ////
public :
    
    // Get a message from the queue.
    // This is not a blocking call, it should return 0 if the queue is empty
    //## operation get() 
    virtual void * get()=0;
    
    // copy the messages in the queue into l
    // Argument OMList<void*> & l : 
    // the list of messages in the queue
    //## operation getMessageList(OMList<void*> & ) 
    virtual void getMessageList(OMList<void*> & l)=0;
    
    // get the real OS element
    //## operation getOsHandle() const 
    virtual void * getOsHandle() const=0;
    
    // check if the queue is empty
    //## operation isEmpty() 
    virtual int isEmpty()=0;
    
    // check if the queue is full
    //## operation isFull() 
    virtual bool isFull()=0;
    
    // block until there are messages in the queue
    //## operation pend() 
    virtual void pend()=0;
    
    // Add a message to the queue
    // Argument void * /* msg */ : 
    // The message
    // Argument bool /* fromISR */ : 
    // When true, the message is send in the context of an ISR
    //## operation put(void *,bool) 
    inline virtual bool put(void * /* msg */, bool /* fromISR */ = false) {
        //#[ operation put(void *,bool) 
        return false;
        //#]
    }
    
    
    // put a message to the queue
    // Argument void * m : 
    // The message
    // Argument const IOxfEventGenerationParams& params : 
    // Message sending parameters
    //## operation putMessage(void *,IOxfEventGenerationParams) 
    inline virtual bool putMessage(void * m, const IOxfEventGenerationParams& params) {
        //#[ operation putMessage(void *,IOxfEventGenerationParams) 
        // Implementation added to support pre-5.1 adapters
        return put(m, params.getFromISR());
        //#]
    }
    
    
    // set the thread that owns the queue (required in some adapters)
    // Argument void * /* process */ : 
    // A handle to the process that own the message queue
    //## operation setOwnerProcess(void *) 
    inline virtual void setOwnerProcess(void * /* process */) {
        //#[ operation setOwnerProcess(void *) 
        //#]
    }
    


};
//## package Design::oxf::Adapters::AbstractLayer 


// Thread abstraction.
// Either creates a new thread or represents an existing thread.
// When creating a new thread it should be blocked until the call to start().
//## class OMOSThread 
class RP_FRAMEWORK_DLL OMOSThread  {
public :
    //#[ ignore 
    // The end thread callback type
    typedef void (*EndCallBack)(void*);
    //#]
    
    // alias of EndCallBack
    //## type OMOSThreadEndCallBack 
    typedef EndCallBack OMOSThreadEndCallBack;
    
    

//#[ ignore 
// override new & delete operators
OM_DECLARE_FRAMEWORK_MEMORY_ALLOCATION_OPERATORS

//#]

////    Constructors and destructors    ////
public :
    
    // Virtual destructor to enable polymorphic deletion
    //## operation ~OMOSThread() 
    virtual ~OMOSThread() {
        //#[ operation ~OMOSThread() 
        //#]
    }
    


////    Operations    ////
public :
    
    // Cleanup IP resources allocated for the thread (required by some adapters).
    //## operation CleanupCommunicationLayer() 
    inline virtual void CleanupCommunicationLayer() {
        //#[ operation CleanupCommunicationLayer() 
        //#]
    }
    
    
    // Initialize IP resources allocated for the thread (required by some adapters).
    //## operation InitCommunicationLayer() 
    inline virtual void InitCommunicationLayer() {
        //#[ operation InitCommunicationLayer() 
        //#]
    }
    
    
    // the following service returns true iff it is invoked from the same os thread
    // as the on the object represents
    //## operation exeOnMyThread() 
    virtual bool exeOnMyThread();
    
    // get the real OS element
    //## operation getOsHandle() const 
    virtual void * getOsHandle() const=0;
    
    // pass the real OS element to the osHandle
    // Argument void *& osHandle : 
    // The RTOS thread handle
    //## operation getOsHandle(void *) const 
    virtual void * getOsHandle(void *& osHandle) const=0;
    
    // get the thread termination call
    // Argument EndCallBack* clb_p : 
    // the callback pointer
    // Argument void ** arg1_p : 
    // argument to pass to the callback
    // Argument bool onExecuteThread : 
    // true: self termination
    // false: termination by another thread
    //## operation getThreadEndClbk(EndCallBack,void *,bool) 
    virtual void getThreadEndClbk(EndCallBack* clb_p, void ** arg1_p, bool onExecuteThread)=0;
    
    // Reset the thread OS handle
    // Should be used with care and only for wrapper threads
    // Argument void * /*newHandle*/ : 
    // The new OS handle
    //## operation resetWrapperThreadOsHandle(void *) 
    inline virtual void resetWrapperThreadOsHandle(void * /*newHandle*/) {
        //#[ operation resetWrapperThreadOsHandle(void *) 
        //#]
    }
    
    
    // resume suspended thread
    //## operation resume() 
    virtual void resume()=0;
    
    // Mark the thread as under destruction
    // Argument bool val : 
    // When true the RTOS thread should be destroyed as part of the OMOSThread destructor.
    //## operation setEndOSThreadInDtor(bool) 
    virtual void setEndOSThreadInDtor(bool val)=0;
    
    // set the thread priority
    // Argument int pr : 
    // The new priority
    //## operation setPriority(int) 
    virtual void setPriority(int pr)=0;
    
    // Start the thread execution
    //## operation start() 
    virtual void start()=0;
    
    // Suspend the thread
    //## operation suspend() 
    virtual void suspend()=0;


////    Attributes    ////
public :
    
    // The default message queue size
    static const long DefaultMessageQueueSize;		//## attribute DefaultMessageQueueSize 
    
    // The default thread stack-size
    static const long DefaultStackSize;		//## attribute DefaultStackSize 
    
    // The default thread priority
    static const long DefaultThreadPriority;		//## attribute DefaultThreadPriority 
    

};
//## package Design::oxf::Adapters::AbstractLayer 


// A tick-timer abstraction.
// Represents a real-time timer that ticks for a specific duration, or an idle timer that ticks only when the system 
// is idle.
// The idle timer is used for the time simulation feature.
//## class OMOSTimer 
class RP_FRAMEWORK_DLL OMOSTimer  {

//#[ ignore 
// override new & delete operators
OM_DECLARE_FRAMEWORK_MEMORY_ALLOCATION_OPERATORS

//#]

////    Constructors and destructors    ////
public :
    
    // Virtual destructor to enable polymorphic deletion
    //## operation ~OMOSTimer() 
    virtual ~OMOSTimer() {
        //#[ operation ~OMOSTimer() 
        //#]
    }
    


////    Operations    ////
public :
    
    // get the real OS element
    //## operation getOsHandle() const 
    virtual void * getOsHandle() const=0;


};
//## package Design::oxf::Adapters::AbstractLayer 


// Client socket abstraction
// Used for animation
//## class OMOSSocket 

//#[ ignore 
#ifdef _OMINSTRUMENT
//#]
class RP_FRAMEWORK_DLL OMOSSocket  {

//#[ ignore 
// override new & delete operators
OM_DECLARE_FRAMEWORK_MEMORY_ALLOCATION_OPERATORS

//#]

////    Constructors and destructors    ////
public :
    
    // Virtual destructor to enable polymorphic deletion
    //## operation ~OMOSSocket() 
    virtual ~OMOSSocket() {
        //#[ operation ~OMOSSocket() 
        //#]
    }
    


////    Operations    ////
public :
    
    // close the socket
    //## operation Close() 
    inline virtual void Close() {
        //#[ operation Close() 
        //#]
    }
    
    
    // Create the socket.
    // Return the socket discriminator or 0 on error
    // Argument const char* SocketAddress : 
    // The IP address that the socket should connect to
    // Argument unsigned int nSocketPort : 
    // The port that the socket should connect to
    //## operation Create(char*,unsigned int) 
    virtual int Create(const char* SocketAddress = 0, unsigned int nSocketPort = 0)=0;
    
    // Receive a message from the socket (blocking)
    // Argument char* lpBuf : 
    // The message buffer
    // Argument int nBufLen : 
    // The message length
    //## operation Receive(char*,int) 
    virtual int Receive(char* lpBuf, int nBufLen)=0;
    
    // Send a message via the socket (blocking)
    // Argument const char* lpBuf : 
    // The message buffer
    // Argument int nBufLen : 
    // The message length
    //## operation Send(char*,int) 
    virtual int Send(const char* lpBuf, int nBufLen)=0;


};
#endif //_OMINSTRUMENT
//## package Design::oxf::Adapters::AbstractLayer 


// This class provides the animation messaging acknowledge protocol with Rhapsody and a wrapper on the socket class.
//## class OMOSConnectionPort 
class RP_FRAMEWORK_DLL OMOSConnectionPort  {

//#[ ignore 
// override new & delete operators
OM_DECLARE_FRAMEWORK_MEMORY_ALLOCATION_OPERATORS

//#]

////    Constructors and destructors    ////
public :
    
    // Virtual destructor to enable polymorphic deletion
    //## operation ~OMOSConnectionPort() 
    virtual ~OMOSConnectionPort() {
        //#[ operation ~OMOSConnectionPort() 
        //#]
    }
    


////    Operations    ////
public :
    
    // Connect to the specified address and port
    // Argument const char* SocketAddress : 
    // the socket IP address
    // Argument unsigned int nSocketPort : 
    // The port the socket should connect to
    //## operation Connect(char*,unsigned int) 
    virtual int Connect(const char* SocketAddress = 0, unsigned int nSocketPort = 0)=0;
    
    // Send the data
    // Argument OMSData* m : 
    // The data to send
    //## operation Send(OMSData) 
    virtual int Send(OMSData* m)=0;
    
    // Set the message handler for incoming messages.
    // Argument void (*dispfunc)(OMSData*) : 
    // The dispatching function
    //## operation SetDispatcher(void (*)(OMSData*)) 
    virtual void SetDispatcher(void (*dispfunc)(OMSData*))=0;


};
//## package Design::oxf::Adapters::AbstractLayer 


// OS elements creation factory
//## class OMOSFactory 
class RP_FRAMEWORK_DLL OMOSFactory  {


////    Constructors and destructors    ////
public :
    
    // Virtual destructor to enable polymorphic deletion
    //## operation ~OMOSFactory() 
    virtual ~OMOSFactory() {
        //#[ operation ~OMOSFactory() 
        //#]
    }
    


////    Operations    ////
public :
    
    // Create the adapter implementation of the connection port
    //## operation createOMOSConnectionPort() 
    virtual OMOSConnectionPort* createOMOSConnectionPort()=0;
    
    // Create the adapter implementation of the event flag
    //## operation createOMOSEventFlag() 
    virtual OMOSEventFlag* createOMOSEventFlag()=0;
    
    // Create the adapter implementation of the idle timer (an idle timer send ticks only when the system is idle)
    // Argument void (*callback)(void*) : 
    // The timer calls this function when a tick occurs
    // Argument void * param : 
    // Argument for the callback function
    //## operation createOMOSIdleTimer(void (*)(void*),void *) 
    virtual OMOSTimer* createOMOSIdleTimer(void (*callback)(void*), void * param)=0;
    
    // Create the adapter implementation of the message queue
    // Argument bool shouldGrow : 
    // When true, the message queue should resize itself when full
    // Argument const long messageQueueSize : 
    // The initial size of the message queue (number of messages)
    //## operation createOMOSMessageQueue(bool,long) 
    virtual OMOSMessageQueue* createOMOSMessageQueue(bool shouldGrow = true, const long messageQueueSize = 
    OMOSThread::DefaultMessageQueueSize)=0;
    
    // Create the adapter implementation of the mutex
    //## operation createOMOSMutex() 
    virtual OMOSMutex* createOMOSMutex()=0;
    
    // Create the adapter implementation of the semaphore
    // Argument unsigned long semFlags : 
    // Implementation-specific initialization flags
    // Argument unsigned long initialCount : 
    // The initial number of available tokens
    // Argument unsigned long maxCount : 
    // The maximum number of available tokens
    // Argument const char * const name : 
    // The semaphore name
    //## operation createOMOSSemaphore(unsigned long,unsigned long,unsigned long,const char * const ) 
    virtual OMOSSemaphore* createOMOSSemaphore(unsigned long semFlags = 0, unsigned long initialCount = 1, 
    unsigned long maxCount = 1, const char * const name = 0)=0;
    
    // Create the adapter implementation of the thread
    // Argument void (*entryFunction)(void*) : 
    // The thread entry function
    // Argument void * param : 
    // Argument to the entry function
    // Argument const char * const threadName : 
    // The thread name
    // Argument const long stackSize : 
    // The thread stack size
    //## operation createOMOSThread(void (*)(void*),void *,const char * const ,long) 
    virtual OMOSThread* createOMOSThread(void (*entryFunction)(void*), void * param, const char * const threadName = 0
    , const long stackSize = OMOSThread::DefaultStackSize)=0;
    
    // Create the adapter implementation of the real-time timer
    // Argument OxfTimeUnit time : 
    // The time between timer ticks
    // Argument void (*callback)(void*) : 
    // The timer calls this function when a tick occurs
    // Argument void * param : 
    // Argument for the callback function
    //## operation createOMOSTickTimer(OxfTimeUnit,void (*)(void*),void *) 
    virtual OMOSTimer* createOMOSTickTimer(OxfTimeUnit time, void (*callback)(void*), void * param)=0;
    
    // Create the adapter implementation of the wrapper thread (an OMOSThread representation of a thread that already 
    // exist in the system).
    // Argument void * osHandle : 
    // The RTOS thread handle that the OMOSThread should be associated with.
    //## operation createOMOSWrapperThread(void *) 
    virtual OMOSThread* createOMOSWrapperThread(void * osHandle)=0;
    
    // Make the current thread delay (blocking) for the specified time.
    // Argument OxfTimeUnit ms : 
    // the delay time in the adapter time resolution
    //## operation delayCurrentThread(OxfTimeUnit) 
    virtual void delayCurrentThread(OxfTimeUnit ms)=0;
    
    // return the current thread OS handle (id)
    //## operation getCurrentThreadHandle() 
    virtual void * getCurrentThreadHandle()=0;
    
    // Create the OSFactory (replaces V3.0 global function theOSFactory())
    //## operation instance() 
    static OMOSFactory* instance();
    
    // wait for a thread to terminate
    // Argument void * osHandle : 
    // the thread to wait for
    // Argument OxfTimeUnit ms : 
    // timeout time
    //## operation waitOnThread(void *,OxfTimeUnit) 
    virtual bool waitOnThread(void * osHandle, OxfTimeUnit ms)=0;


};

//#[ ignore 

#define OXFTDelay(timInMs) OMOSFactory::instance()->delayCurrentThread((timInMs))
//#]

//## package Design::oxf::Adapters::AbstractLayer 


// Utility class for general RTOS services
// The implementation of these services is done at the adapter level by writing the operation bodies.
//## class OMOS 
class RP_FRAMEWORK_DLL OMOS  {


////    Operations    ////
public :
    
    // os-specific actions to take at the end of OXFInit 
    // after the environment is set (i.e. main thread, timer etc) 
    // and before return from the function
    // Argument int errorCode : 
    // The exit code
    //## operation endApplication(int) 
    static void endApplication(int errorCode);
    
    // Called just before terminating the application.
    // Allow adapter to specific tasks that should be done before termination.
    //## operation endProlog() 
    static void endProlog();
    
    // Called at the end of OXF::init() to allow adapter specific initializations.
    //## operation initEpilog() 
    static void initEpilog();


};


#endif  
//
//! Log: $Log: os.h $
//! Log: Revision 1.73  2007/04/06 07:08:20  ilgiga
//! Log: bug fix 98191
//


