//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMStack
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/omstack.h $
//!	File version	: $Revision: 1.18 $
//
//!	Date changed	: $Date: 2007/04/06 07:08:14 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef omstack_H 

#define omstack_H 

#include "omlist.h"

//----------------------------------------------------------------------------
// omstack.h                                                                  
//----------------------------------------------------------------------------

template <class  Concept> class OMIterator;

//## package Design::oxf::Services::Containers::TypeSafe 


// A stack (FILO)
// Based on a linked-list
//## class OMStack 
template <class Concept> class OMStack : public OMList<Concept> {


////    Constructors and destructors    ////
public :
    
    // Copy constructor
    // Argument const OMStack<Concept> & s : 
    // The stack to copy
    //## operation OMStack(const OMStack<Concept> & ) 
    OMStack(const OMStack<Concept> & s) : OMList<Concept>()
    	 {
        //#[ operation OMStack(const OMStack<Concept> & ) 
        copy(s);
        //#]
    }
    
    
    // Initialize an empty stack
    //## operation OMStack() 
    OMStack() {
        //#[ operation OMStack() 
        //#]
    }
    


////    Operations    ////
public :
    
    // Assignment operator
    // Argument const OMStack<Concept> & s : 
    // the stack to copy
    //## operation operator=(const OMStack<Concept> & ) 
    inline OMStack<Concept> &  operator=(const OMStack<Concept> & s) {
        //#[ operation operator=(const OMStack<Concept> & ) 
        copy(s);
        return *this;
        //#]
    }
    
    
    // Pop the top of the stack
    //## operation pop() 
    inline Concept pop() {
        //#[ operation pop() 
        Concept item = top();
        if (!this->isEmpty())
        {
        	this->_removeFirst();
        }
        return item;
        //#]
    }
    
    
    // Push an element to the stack
    // Argument Concept p : 
    // The element to add
    //## operation push(Concept) 
    inline void push(Concept p) {
        //#[ operation push(Concept) 
        this->addFirst(p);
        //#]
    }
    
    
    // Get the top of the stack without changing its state
    //## operation top() 
    inline Concept top() {
        //#[ operation top() 
        return this->getFirstConcept();
        //#]
    }
    

private :
    
    // Copy a stack
    // Argument const OMStack<Concept>& s : 
    // The stack to copy
    //## operation copy(const OMStack<Concept>&) 
    inline void copy(const OMStack<Concept>& s) {
        //#[ operation copy(const OMStack<Concept>&) 
        OMList<Concept>::copy(s);
        //#]
    }
    


};
//## class OMStack 




#endif  
//
//! Log: $Log: omstack.h $
//! Log: Revision 1.18  2007/04/06 07:08:14  ilgiga
//! Log: bug fix 98191
//


