//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMProtected
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/omprotected.h $
//!	File version	: $Revision: 1.39 $
//
//!	Date changed	: $Date: 2007/04/06 07:08:11 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef omprotected_H 

#define omprotected_H 

#include "rawtypes.h"
#include "OXFGuardMacros.h"
#include "OMResourceGuard.h"

//----------------------------------------------------------------------------
// omprotected.h                                                                  
//----------------------------------------------------------------------------

class OMOSMutex;

//## package Design::oxf::Services::Guards 


// A monitor class that uses OMOSMutex as the internal mutex object
//## class OMProtected 
class RP_FRAMEWORK_DLL OMProtected  {


////    Constructors and destructors    ////
public :
    
    // Initialize the object with control over the initialization of the RTOS mutex
    // Argument bool createMutex : 
    // When true - initialize the RTOS mutex
    //## operation OMProtected(bool) 
    OMProtected(bool createMutex) : theMutex(NULL) {
        //#[ operation OMProtected(bool) 
        if (createMutex == true) {
        	initializeMutex();
        }
        //#]
    }
    
    
    // Initialize the object and the RTOS mutex
    //## operation OMProtected() 
    OMProtected();
    
    //## operation OMProtected(const OMProtected& ) 
    OMProtected(const OMProtected& omProtected);
    
    // Cleanup
    //## operation ~OMProtected() 
    virtual ~OMProtected() {
        //#[ operation ~OMProtected() 
        cleanupMutex();
        //#]
    }
    


////    Operations    ////
public :
    
    // Destroy the RTOS mutex
    //## operation cleanupMutex() 
    void cleanupMutex();
    
    // backward compatibility support for non OSE applications
    //## operation free() const 
    
    //#[ ignore 
    #ifndef OM_OS_USE_FREE
    //#]
    void free() const;
    //#[ ignore 
    
    #endif
    //#]
    
    
    // get the guard object - to allow embedding of OMProtected in OMThread
    //## operation getGuard() const 
    const OMProtected& getGuard() const;
    
    // Initialize the RTOS mutex
    //## operation initializeMutex() 
    void initializeMutex();
    
    // Lock the protected object mutex.
    //## operation lock() const 
    void lock() const;
    
    //## operation operator=(const OMProtected& ) 
    OMProtected& operator=(const OMProtected& omProtected);
    
    // Unlock the mutex
    //## operation unlock() const 
    void unlock() const;


////    Relations and components    ////
private :
    
    // The RTOS mutex
    OMOSMutex* theMutex;		//## link theMutex 
    


};
//## package Design::oxf::Services::Guards 


// Enter-exit guard on OMProtected classes
//## class OMGuard 
typedef OMResourceGuard<OMProtected> OMGuard;


#endif  
//
//! Log: $Log: omprotected.h $
//! Log: Revision 1.39  2007/04/06 07:08:11  ilgiga
//! Log: bug fix 98191
//


