//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMList
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/omlist.h $
//!	File version	: $Revision: 1.39 $
//
//!	Date changed	: $Date: 2007/04/06 07:08:08 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef omlist_H 

#define omlist_H 

#include "OMAbstractContainer.h"
#include "OMIterator.h"
#include "OXFManager.h"

//----------------------------------------------------------------------------
// omlist.h                                                                  
//----------------------------------------------------------------------------

//## package Design::oxf::Services::Containers::TypeSafe 


// Linked list container class
//## class OMList 
template <class Concept> class OMList : public OMAbstractContainer<Concept> {
public :
    
        
        // List node
        //## class OMList::Item 
        class Item  {
        
        //#[ ignore 
        // override new & delete operators
        OM_DECLARE_FRAMEWORK_MEMORY_ALLOCATION_OPERATORS
        
        //#]
        
        ////    Friends    ////
        public :
            
            friend  class OMList<Concept>;
        
        
        ////    Constructors and destructors    ////
        public :
            
            // Initialize an item with a given data
            // Argument const Concept& theConcept : 
            // The item data
            //## operation Item(const Concept&) 
            Item(const Concept& theConcept) : concept(theConcept), next(NULL)
            	 {
                //#[ operation Item(const Concept&) 
                //#]
            }
            
            
            // Copy constructor
            // Argument const Item& other : 
            // The item to copy
            //## operation Item(const Item&) 
            Item(const Item& other) : concept(other.concept), next(other.next)
            	 {
                //#[ operation Item(const Item&) 
                //#]
            }
            
            
            // Cleanup
            //## operation ~Item() 
            ~Item() {
                //#[ operation ~Item() 
                next = NULL;
                //#]
            }
            
        
        
        ////    Operations    ////
        public :
            
            // Connect to the specified item
            // Argument Item* item : 
            // The item to connect to
            //## operation connectTo(Item*) 
            inline void connectTo(Item* item) {
                //#[ operation connectTo(Item*) 
                next = item;
                //#]
            }
            
            
            // Get the next item in the linked list
            //## operation getNext() const 
            inline Item*  getNext() const {
                //#[ operation getNext() const 
                return next;
                //#]
            }
            
            
            // Assignment operator
            // Argument const Item& other : 
            // The item to copy
            //## operation operator=(const Item&) 
            inline Item&  operator=(const Item& other) {
                //#[ operation operator=(const Item&) 
                next = other.next;
                concept = other.concept;	// assuming operator = for Concept
                return *this;
                //#]
            }
            
        
        
        ////    Additional operations    ////
        public :
            
            //## auto_generated 
            inline Concept getConcept() const {
                return concept;
            }
            
            
            //## auto_generated 
            inline void setConcept(Concept p_concept) {
                concept = p_concept;
            }
            
            
            //## auto_generated 
            inline void setNext(Item* p_next) {
                next = p_next;
            }
            
        
        
        ////    Attributes    ////
        private :
            
            // the data of the node
            Concept concept;		//## attribute concept 
            
            // the next item in the list
            Item* next;		//## attribute next 
            
        
        };
        
    
//## class OMList 


////    Constructors and destructors    ////
public :
    
    // Constructor - create an empty list
    //## operation OMList() 
    OMList() : count_(0) ,first(NULL) ,last(NULL) {
        //#[ operation OMList() 
        //#]
    }
    
    
    // copy constructor
    // Argument const OMList<Concept> & l : 
    // The list to copy
    //## operation OMList(const OMList<Concept> & ) 
    OMList(const OMList<Concept> & l) : count_(0) ,first(NULL) ,last(NULL) {
        //#[ operation OMList(const OMList<Concept> & ) 
        copy(l);
        //#]
    }
    
    
    // Destructor - empty the list 
    //## operation ~OMList() 
    virtual ~OMList() {
        //#[ operation ~OMList() 
        removeAll();
        //#]
    }
    


////    Operations    ////
public :
    
    // Add an object to the list (at its end)
    // Argument Concept c : 
    // The element to add
    //## operation add(Concept ) 
    inline void add(Concept c) {
        //#[ operation add(Concept ) 
        
        // Create a new list item
        Item* item = new Item(c);
        // Insert it into the list at the end
        if (first == NULL) {
        	first = item;
        }
        else {
        	last->connectTo(item);
        }
        last = item;
        ++count_;
        //#]
    }
    
    
    // if getCount>=i - Add c after i'th element else Add c at end
    // Argument int i : 
    // The index
    // Argument Concept c : 
    // The element to add
    //## operation addAt(int,Concept ) 
    inline void addAt(int i, Concept c) {
        //#[ operation addAt(int,Concept ) 
        if (i == 0 || first == NULL) { // Insert c in first position
        	addFirst(c);
        	return;
        }
        // Find the position of insertion
        Item* item = first;
        for(int j = 1; (j < i) && (item != last); j++)
        	item = item->next;
        
        if (item == last) { // Insert c in last position
        	add(c);
        }
        else {
        	Item* newGuy = new Item(c);
        	Item* nextGuy = item->next;
        	item->connectTo(newGuy);
        	newGuy->connectTo(nextGuy);
        	++count_;
        }
        //#]
    }
    
    
    // Add an object to the list (at its beginning)
    // Argument Concept c : 
    // The element to add
    //## operation addFirst(Concept ) 
    inline void addFirst(Concept c) {
        //#[ operation addFirst(Concept ) 
        // Create a new list item
        Item* item = new Item(c);
        // Insert it into the list at the begining
        item->connectTo(first);
        first = item;
        if (last == NULL) {
        	last = first;
        }
        ++count_;
        //#]
    }
    
    
    // Find an object in the list
    // Argument Concept c : 
    // The element to find
    //## operation find(Concept ) const 
    inline bool find(Concept c) const {
        //#[ operation find(Concept ) const 
        for (Item* i = first; i != NULL; i = i->next) {
        	if (i->concept == c) {
        		return true;
        	}
        }
        return false;
        //#]
    }
    
    
    // Get the element in the given index
    // Argument int i : 
    // The index
    //## operation getAt(int) const 
    inline Concept &  getAt(int i) const {
        //#[ operation getAt(int) const 
        void* item;
        getFirst(item);
        for(int j = 0; j < i; j++) {
        	if (item) {
        		getNext(item);
        	}
        	else {
        		break;
        	}
        }
        return getCurrent(item);
        //#]
    }
    
    
    // Get the element in the head of the list
    //## operation getFirstConcept() const 
    inline Concept &  getFirstConcept() const {
        //#[ operation getFirstConcept() const 
        return getCurrent(first);
        //#]
    }
    
    
    // Get the element in the tail of the list
    //## operation getLastConcept() const 
    inline Concept &  getLastConcept() const {
        //#[ operation getLastConcept() const 
        return getCurrent(last);
        //#]
    }
    
    
    // Check if the list is empty
    //## operation isEmpty() const 
    inline bool isEmpty() const {
        //#[ operation isEmpty() const 
        return (first == NULL);
        //#]
    }
    
    
    // Assignment operator
    // Argument const OMList<Concept> & l : 
    // The list to copy
    //## operation operator=(const OMList<Concept> & ) 
    inline OMList<Concept> &  operator=(const OMList<Concept> & l) {
        //#[ operation operator=(const OMList<Concept> & ) 
        copy(l);
        return *this;
        //#]
    }
    
    
    // Get the element at the provided index
    // Argument int i : 
    // The index
    //## operation operator[](int) const 
    inline Concept &  operator[](int i) const {
        //#[ operation operator[](int) const 
        return getAt(i);
        //#]
    }
    
    
    // Remove the first occurrence of a specific Object (Concept)
    // from list
    // Argument Concept c : 
    // The element to remove
    //## operation remove(Concept ) 
    inline void remove(Concept c) {
        //#[ operation remove(Concept ) 
        if (first == NULL) // Nothing to remove
        	return;
        if (first->concept == c) { // Special case the object is first
        	_removeFirst();
        	return;
        }
        // Search for the object
        Item* prev = first;
        Item* cur = first->next;
        while (cur!=NULL) {
        	if (cur->concept == c) {
        		prev->connectTo(cur->next);
        		if (cur->next == NULL) {
        			last = prev;
        		}
                delete cur;
                --count_;
                return;
        	}
        	prev = cur;
        	cur = cur->next;
        }
        //#]
    }
    
    
    // Remove all items from list
    //## operation removeAll() 
    inline void removeAll() {
        //#[ operation removeAll() 
        while(first != NULL) {
        	_removeFirst();
        }
        //#]
    }
    
    
    // Remove first item from list
    //## operation removeFirst() 
    inline void removeFirst() {
        //#[ operation removeFirst() 
        if (first != NULL) {
        	_removeFirst();
        }
        //#]
    }
    
    
    // Remove a specific Item from list
    // Argument Item* item : 
    // The list node to remove
    //## operation removeItem(Item*) 
    inline void removeItem(Item* item) {
        //#[ operation removeItem(Item*) 
        if (first == NULL) // Nothing to remove
        	return;
        if (first == item) { // Special case the required item is first
        	_removeFirst();
        	return;
        }
        // Search for the item
        Item* prev = first;
        Item* cur = first->next;
        while (cur != NULL) {
        	if (cur == item) { // item found
        		prev->connectTo(cur->next);
        		if (cur->next == NULL) {
        			last = prev;
        		}
        		delete cur;
        		--count_;
        		return;
        	}
        	// Advance to next item
        	prev = cur;
        	cur = cur->next;
        }
        //#]
    }
    
    
    // Remove last item from list - inefficient as we keep no
    // backward pointers
    //## operation removeLast() 
    inline void removeLast() {
        //#[ operation removeLast() 
        removeItem(last);
        //#]
    }
    

protected :
    
    // unsafe Remove first item from list
    //## operation _removeFirst() 
    inline void _removeFirst() {
        //#[ operation _removeFirst() 
        Item* tmp = first;
        first = first->next;
        if (first == NULL) {
        	last = NULL;
        }
        if (tmp != NULL) {
        	delete tmp;
        	--count_;
        }
        //#]
    }
    
    
    // Copy the specified list
    // Argument const OMList<Concept> & l : 
    // The list to copy
    //## operation copy(const OMList<Concept> & ) 
    inline void copy(const OMList<Concept> & l) {
        //#[ operation copy(const OMList<Concept> & ) 
        if (first != l.first) {
        	// avoid self copy
        	OMIterator<Concept> iter(l);
        	while (*iter) {
        		add(*iter);
        		++iter;
        	}
        }
        //#]
    }
    
    
    // Get the element at the given position (called by the iterator)
    // Argument void * pos : 
    // The iterator position
    //## operation getCurrent(void *) const 
    inline virtual Concept &  getCurrent(void * pos) const {
        //#[ operation getCurrent(void *) const 
        if (pos != NULL) {
        	return reinterpret_cast<Item*>(pos)->concept;
        }
        else {
        	return OMNullValue<Concept>::get();
        }
        //#]
    }
    
    
    // Set the initial position for the iterator
    // Argument void*& pos : 
    // The list head (out)
    //## operation getFirst(void*& ) const 
    inline virtual void getFirst(void*& pos) const {
        //#[ operation getFirst(void*& ) const 
        pos = first;
        //#]
    }
    
    
    // Bet the position of the list tail
    // Argument void*& pos : 
    // The list tail (out)
    //## operation getLast(void*& ) const 
    inline virtual void getLast(void*& pos) const {
        //#[ operation getLast(void*& ) const 
        pos = last;
        //#]
    }
    
    
    // Update the provided position to the next position in the container
    // Argument void*& pos : 
    // The iterator position to advance
    //## operation getNext(void*& ) const 
    inline virtual void getNext(void*& pos) const {
        //#[ operation getNext(void*& ) const 
        pos = reinterpret_cast<Item*>(pos)->next;
        //#]
    }
    


////    Additional operations    ////
public :
    
    //## auto_generated 
    inline unsigned long getCount() const {
        return count_;
    }
    


////    Attributes    ////
protected :
    
    // the number of elements in the list
    unsigned long count_;		//## attribute count_ 
    
private :
    
    // the list head
    Item* first;		//## attribute first 
    
    // the tail head
    Item* last;		//## attribute last 
    

};

//## class OMList 




//## class OMList::Item 






#endif  
//
//! Log: $Log: omlist.h $
//! Log: Revision 1.39  2007/04/06 07:08:08  ilgiga
//! Log: bug fix 98191
//


