//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMCollection
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/omcollec.h $
//!	File version	: $Revision: 1.32 $
//
//!	Date changed	: $Date: 2007/04/06 07:08:07 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef omcollec_H 

#define omcollec_H 

#include "OMStaticArray.h"

//----------------------------------------------------------------------------
// omcollec.h                                                                  
//----------------------------------------------------------------------------

template <class  Concept> class OMIterator;

//## package Design::oxf::Services::Containers::TypeSafe 


// A dynamic array
//## class OMCollection 
template <class Concept> class OMCollection : public OMStaticArray<Concept> {
public :
    // Constant defaults used in the collection code
    //## type Defaults 
    enum Defaults {
        DEFAULT_START_SIZE = 20,
        DEFAULT_FACTOR = 2
    };
    
    


////    Constructors and destructors    ////
public :
    
    // copy constructor and assignment operator
    // Argument const OMCollection<Concept> & c : 
    // The collection to copy
    //## operation OMCollection(const OMCollection<Concept> & ) 
    OMCollection(const OMCollection<Concept> & c) : OMStaticArray<Concept>(0)
    	 {
        //#[ operation OMCollection(const OMCollection<Concept> & ) 
        copy(c);
        //#]
    }
    
    
    // Constructor
    // Argument int theSize : 
    // The array initial size
    //## operation OMCollection(int) 
    OMCollection(int theSize = DEFAULT_START_SIZE) : OMStaticArray<Concept>(theSize)  {
        //#[ operation OMCollection(int) 
        //#]
    }
    


////    Operations    ////
public :
    
    // Add an element to the end of the array
    // Argument Concept p : 
    // The element to add
    //## operation add(Concept) 
    inline void add(Concept p) {
        //#[ operation add(Concept) 
        if (this->count >= this->size)
        {
        	reorganize();
        }
        this->theLink[this->count] = p;
        this->count++;
        //#]
    }
    
    
    // add new element if in range, without increase of the container size.
    // Argument int index : 
    // The index
    // Argument Concept p : 
    // The element to add
    //## operation addAt(int,Concept) 
    inline void addAt(int index, Concept p) {
        //#[ operation addAt(int,Concept) 
        if (index < 0) 
        {
        	return;
        }
        if (this->count > index)
        {
        	this->theLink[index] = p;
        }
        else if ((index == this->count) && 
        	(this->size > this->count))
        {
        	this->theLink[this->count] = p;
        	this->count++;
        }
        //#]
    }
    
    
    // Assignment operator
    // Argument const OMCollection<Concept> & c : 
    // The collection to copy
    //## operation operator=(const OMCollection<Concept> & ) 
    inline OMCollection<Concept> &  operator=(const OMCollection<Concept> & c) {
        //#[ operation operator=(const OMCollection<Concept> & ) 
        copy(c);
        return *this;
        //#]
    }
    
    
    // Remove p from the array
    // Argument Concept p : 
    // The element to remove
    //## operation remove(Concept) 
    inline void remove(Concept p) {
        //#[ operation remove(Concept) 
        // Delete p
        for (int i = 0; i < this->count; i++)
        {
        	if (this->theLink[i] == p)
        	{ 
        		removeByIndex(i);
        		// assuming no duplicates
        		return;
        	}
        }
        //#]
    }
    
    
    // Cleanup the array
    //## operation removeAll() 
    inline void removeAll() {
        //#[ operation removeAll() 
        OMDELETE(this->theLink, sizeof(Concept) * this->size);
        this->count = 0;
        this->size = DEFAULT_START_SIZE;
        this->theLink = OMNEW(Concept, this->size);
        //#]
    }
    
    
    // Remove the element at the specified index
    // Argument int i : 
    // The index
    //## operation removeByIndex(int) 
    inline void removeByIndex(int i) {
        //#[ operation removeByIndex(int) 
        this->count--;
        this->theLink[i] = this->theLink[this->count];
        //#]
    }
    
    
    // Reset the collection size
    // Argument int factor : 
    // resize factor
    //## operation reorganize(int) 
    inline void reorganize(int factor = DEFAULT_FACTOR) {
        //#[ operation reorganize(int) 
        if (factor < 1)
        {
        	factor = 1;
        }
        int oldSize = this->size;
        this->size = this->count * factor + 1;
        Concept* tmpLink = OMNEW(Concept, this->size);
        for (int i = 0; i < this->count; i++)
        {
        	tmpLink[i] = this->theLink[i];
        }
        OMDELETE(this->theLink, sizeof(Concept) * oldSize);
        this->theLink = tmpLink;
        //#]
    }
    
    
    // misspelled operation kept for backward compatibility
    // Argument int factor : 
    // resize factor
    //## operation reorgenize(int) 
    inline void reorgenize(int factor = DEFAULT_FACTOR) {
        //#[ operation reorgenize(int) 
        reorganize(factor);
        //#]
    }
    

private :
    
    // Copy a collection
    // Argument const OMCollection<Concept> & c : 
    // The collection to copy
    //## operation copy(const OMCollection<Concept> & ) 
    inline void copy(const OMCollection<Concept> & c) {
        //#[ operation copy(const OMCollection<Concept> & ) 
        OMStaticArray<Concept>::copy(c);
        //#]
    }
    


};
//## class OMCollection 




#endif  
//
//! Log: $Log: omcollec.h $
//! Log: Revision 1.32  2007/04/06 07:08:07  ilgiga
//! Log: bug fix 98191
//


