//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: TypeSafe
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OXFTypeSafeContainers.h $
//!	File version	: $Revision: 1.14 $
//
//!	Date changed	: $Date: 2007/04/06 07:08:06 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef OXFTypeSafeContainers_H 

#define OXFTypeSafeContainers_H 

#include "rawtypes.h"

//----------------------------------------------------------------------------
// OXFTypeSafeContainers.h                                                                  
//----------------------------------------------------------------------------

template <class  Concept> class OMAbstractContainer;
template <class  Concept> class OMCollection;
template <class  Node> class OMHeap;
template <class  Concept> class OMIterator;
template <class  Concept> class OMList;
template <class  Key, class  Concept> class OMMap;
template <class  Concept> class OMNullValue;
template <class  Concept> class OMQueue;
template <class  Concept> class OMStack;
template <class  Concept> class OMStaticArray;

//## package Design::oxf::Services::Containers::TypeSafe 


// Type-safe (template) containers

// When allocating memory, the memory blocks must be aligned with the compiler settings.
// This macro is used in the memory pools, to guarantee that the pool allocates sufficient memory in order to avoid 
// memory alignment issues.
//#[ type ContainersMemoryAlignment 
#ifndef OM_LONG_MEMORY_ALIGNMENT
typedef char omMemoryAlignedType;
#define OM_ALIGNED_SIZEOF(ELEMENT) (sizeof(ELEMENT) + (OMRAW_MEMORY_ALIGNMENT-1))
#else
typedef int omMemoryAlignedType;
#define OM_ALIGNED_SIZEOF(ELEMENT) ((sizeof(ELEMENT) + (OMRAW_MEMORY_ALIGNMENT-1) + 3) / 4)
#endif // OM_LONG_MEMORY_ALIGNMENT
//#]


// NULL array used for null element (OMNullValue)
//## attribute OMContainersNullBlock 

//#[ ignore 
#ifdef OMUseNullBlockContainer
//#]
extern int OMContainersNullBlock[];
//#[ ignore 

#endif // OMUseNullBlockContainer
//#]




#endif  
//
//! Log: $Log: OXFTypeSafeContainers.h $
//! Log: Revision 1.14  2007/04/06 07:08:06  ilgiga
//! Log: bug fix 98191
//


