//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OXFRefManager
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OXFRefManager.h $
//!	File version	: $Revision: 1.15 $
//
//!	Date changed	: $Date: 2007/04/06 07:08:03 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef OXFRefManager_H 

#define OXFRefManager_H 
//----------------------------------------------------------------------------
// OXFRefManager.h                                                                  
//----------------------------------------------------------------------------

class OMOSMutex;

//## package Design::oxf::Services::Guards::DllGuards 


// This class is used to maintain the references for OXF::init(..) call in DLL version of framework
//## class OXFRefManager 

//#[ ignore 
#ifdef FRAMEWORK_DLL
//#]
class OXFRefManager  {


////    Constructors and destructors    ////
public :
    
    // Initialize
    //## operation OXFRefManager() 
    OXFRefManager();
    
    // Cleanup
    //## operation ~OXFRefManager() 
    ~OXFRefManager();


////    Operations    ////
public :
    
    // Reduce the count of the framework users
    //## operation Decrement() 
    long Decrement();
    
    // Increase  the count of the framework users
    //## operation Increment() 
    long Increment();
    
    // Lock the mutex
    //## operation lock() const 
    void lock() const;
    
    // Unlock the mutex
    //## operation unlock() const 
    void unlock() const;


////    Additional operations    ////
public :
    
    //## auto_generated 
    bool getOxfStarted() const;
    
    //## auto_generated 
    void setOxfStarted(bool p_oxfStarted);
    
    //## auto_generated 
    long getCount() const;


////    Framework operations    ////
protected :
    
    //## auto_generated 
    void cleanUpRelations();


////    Attributes    ////
private :
    
    // indicate if the OXF default active class is running (OXF::start() was called)
    bool oxfStarted;		//## attribute oxfStarted 
    
    // reference count to the number of calls
    long totalReferences;		//## attribute totalReferences 
    

////    Relations and components    ////
private :
    
    // The RTOS mutex
    OMOSMutex* theMutex;		//## link theMutex 
    


};

//#[ ignore 

#endif // FRAMEWORK_DLL
//#]



#endif  
//
//! Log: $Log: OXFRefManager.h $
//! Log: Revision 1.15  2007/04/06 07:08:03  ilgiga
//! Log: bug fix 98191
//


