//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: PortMacros
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OXFPortMacros.h $
//!	File version	: $Revision: 1.13 $
//
//!	Date changed	: $Date: 2007/04/06 07:08:02 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef OXFPortMacros_H 

#define OXFPortMacros_H 
//----------------------------------------------------------------------------
// OXFPortMacros.h                                                                  
//----------------------------------------------------------------------------

//## package Design::oxf::Services::Macros::PortMacros 


// Ports access macros

// Get the out bound of the provided port
//#[ type _OPORT 
#define _OPORT(p) p->getOutBound()
//#]

// Check if the current event was sent via the specified port
//#[ type IS_PORT 
#define IS_PORT(p) getCurrentEvent()->getPort() == (void *)(get_##p())
//#]

// Check if the current event was sent via the specified port when using a port with multiplicity > 1
//#[ type IS_PORT_AT 
#define IS_PORT_AT(p,i) getCurrentEvent()->getPort() == (void *)(get_##p(i))
//#]

// Get the out bound of the provided port
//#[ type OPORT 
#define OPORT(p) OUT_PORT(p)
//#]

// Get the out bound of the provided port when using a port with multiplicity > 1
//#[ type OPORT_AT 
#define OPORT_AT(p, i) OUT_PORT_AT(p, i)
//#]

// Get the out bound of the provided port
//#[ type OUT_PORT 
#define OUT_PORT(p) _OPORT(get_##p())
//#]

// Get the out bound of the provided port when using a port with multiplicity > 1
//#[ type OUT_PORT_AT 
#define OUT_PORT_AT(p, i) _OPORT(get_##p(i))
//#]




#endif  
//
//! Log: $Log: OXFPortMacros.h $
//! Log: Revision 1.13  2007/04/06 07:08:02  ilgiga
//! Log: bug fix 98191
//


