//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: MemoryManagerMacros
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OXFMemoryManagerMacros.h $
//!	File version	: $Revision: 1.18 $
//
//!	Date changed	: $Date: 2007/04/06 07:08:00 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef OXFMemoryManagerMacros_H 

#define OXFMemoryManagerMacros_H 

#include "rawtypes.h"

//----------------------------------------------------------------------------
// OXFMemoryManagerMacros.h                                                                  
//----------------------------------------------------------------------------

//## package Design::oxf::Services::Macros::MemoryManagerMacros 


// Memory manager related macros

// Support OS without global placement new/delete operators
//#[ type REPLACEMENT_NEW 
#if (!defined(OM_NO_FRAMEWORK_MEMORY_MANAGER) && !defined(OMOMATE))
#ifdef OM_NO_OS_REPLACEMENT_NEW
inline void * operator new(size_t, void * ptr) { return ptr; }
inline void operator delete(void *, void *) {return; }
#else
#ifdef OM_STL
#include <new>
#else
#include <new.h>
#endif // OM_STL
#endif // OM_NO_OS_REPLACEMENT_NEW
#endif // (!defined(OM_NO_FRAMEWORK_MEMORY_MANAGER) && !defined(OMOMATE))
//#]

// Support OS without support in ANSI assert()
//#[ type OS_ASSERT 
#if (!defined(OM_NO_FRAMEWORK_MEMORY_MANAGER) && !defined(OMOMATE))
#ifdef OM_DISABLE_ASSERT
// Support disabling of assert().
// Done to avoid LINT warnings due to Microsoft implementation.
#ifdef assert
#undef assert
#endif // assert
#define assert(condition)
#else // !OM_DISABLE_ASSERT
#ifdef OM_NO_OS_ASSERT
#ifndef assert
#define assert(condition) if (!(condition)) exit(-1);
#endif // assert
#else
#include <assert.h>
#endif // OM_NO_OS_ASSERT
#endif // OM_DISABLE_ASSERT
#endif // (!defined(OM_NO_FRAMEWORK_MEMORY_MANAGER) && !defined(OMOMATE))
//#]

// Add dummy size parameter to the new operator - compiler dependent code
//#[ type NEW_DUMMY_PARAM 
#ifdef OM_NEW_OPERATOR_NEEDS_DUMMY_PARAM
#define NEW_DUMMY_PARAM ,size_t = 0
#else
#define NEW_DUMMY_PARAM
#endif // OM_NEW_OPERATOR_NEEDS_DUMMY_PARAM
//#]

// Request memory for a given number of instances of the given type
//#[ type OMNEW 
#if (!defined(OM_NO_FRAMEWORK_MEMORY_MANAGER) && !defined(OMOMATE))
#define OMNEW(type, size) new(OMMemoryManager::getMemoryManager()->getMemory(sizeof(type) * (size_t)(size))) type[(size_t)(size)]
#else
// use the global new operator
#define OMNEW(type, size) new type[(size_t)(size)]
#endif // (!defined(OM_NO_FRAMEWORK_MEMORY_MANAGER) && !defined(OMOMATE))
//#]

// Return memory allocated by OMNEW
//#[ type OMDELETE 
#if (!defined(OM_NO_FRAMEWORK_MEMORY_MANAGER) && !defined(OMOMATE))

#define OMDELETE(object,size) OMMemoryManager::getMemoryManager()->	\
	returnMemory(												\
		reinterpret_cast<void*>(object),						\
		static_cast<size_t>(size))

#else
// the dummy variable is used to avoid compilation warnings,
//  it is required for the other definition of the OMDELETE() macro - when the memory manager is used.
#define OMDELETE(object, dummy)		\
	if ((dummy) == 0) { }			\
	delete[] (object);

#endif // (!defined(OM_NO_FRAMEWORK_MEMORY_MANAGER) && !defined(OMOMATE))
//#]

// Request memory for a given number of bytes
//#[ type OMGET_MEMORY 
#if (!defined(OM_NO_FRAMEWORK_MEMORY_MANAGER) && !defined(OMOMATE))
#define OMGET_MEMORY(size) OMMemoryManager::getMemoryManager()->getMemory((size_t)(size))
#else
// use 'regular' new & delete for memory allocation
#define OMGET_MEMORY(size) ::operator new((size_t) (size))
#endif // (!defined(OM_NO_FRAMEWORK_MEMORY_MANAGER) && !defined(OMOMATE))
//#]

// Replacement delete operator declaration
//#[ type OM_DECLARE_REPLACEMENT_DELETE_OPERATOR 
#ifndef OM_NO_COMPILER_SUPPORT_FOR_REPLACEMENT_DELETE
#define OM_DECLARE_REPLACEMENT_DELETE_OPERATOR	\
	static void operator delete (void*, void*)	\
	{											\
		return;									\
	}

#else
#define OM_DECLARE_REPLACEMENT_DELETE_OPERATOR
#endif // OM_NO_COMPILER_SUPPORT_FOR_REPLACEMENT_DELETE
//#]

// Override on the new and delete operators to obtain memory from the framework memory manager
//#[ type OM_DECLARE_FRAMEWORK_MEMORY_ALLOCATION_OPERATORS 
#if (!defined(OM_NO_FRAMEWORK_MEMORY_MANAGER) && !defined(OMOMATE))
#define OM_DECLARE_FRAMEWORK_MEMORY_ALLOCATION_OPERATORS					\
public:																		\
	static void* operator new (size_t size NEW_DUMMY_PARAM)					\
	{																		\
		return OMMemoryManager::getMemoryManager()->getMemory(size);		\
	}																		\
	static void* operator new[] (size_t size NEW_DUMMY_PARAM)				\
	{																		\
		return OMMemoryManager::getMemoryManager()->getMemory(size);		\
	}																		\
	static void * operator new(size_t, void * ptr)							\
	{																		\
		return ptr;															\
	}																		\
	static void operator delete (void * object, size_t size)				\
	{																		\
		if (object != NULL)													\
			OMMemoryManager::getMemoryManager()->returnMemory(object,size);	\
	}																		\
	static void operator delete[] (void * object, size_t size)				\
	{																		\
		if (object != NULL)													\
			OMMemoryManager::getMemoryManager()->returnMemory(object,size);	\
	}			
															\
/////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////
	//OM_DECLARE_REPLACEMENT_DELETE_OPERATOR
/////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////

#else
// empty
#define OM_DECLARE_FRAMEWORK_MEMORY_ALLOCATION_OPERATORS
#endif // (!defined(OM_NO_FRAMEWORK_MEMORY_MANAGER) && !defined(OMOMATE))
//#]

// The pool size for the memory manager switch helper allocated memory list
//#[ type OM_MEMORY_MANAGER_SWITCH_HELPER_POOL_SIZE 
#if (!defined(OM_NO_FRAMEWORK_MEMORY_MANAGER) && !defined(OMOMATE))
#ifndef OM_MEMORY_MANAGER_SWITCH_HELPER_POOL_SIZE
#define OM_MEMORY_MANAGER_SWITCH_HELPER_POOL_SIZE 512
#endif // ifndef OM_MEMORY_MANAGER_SWITCH_HELPER_POOL_SIZE
#endif // (!defined(OM_NO_FRAMEWORK_MEMORY_MANAGER) && !defined(OMOMATE))
//#]




#endif  
//
//! Log: $Log: OXFMemoryManagerMacros.h $
//! Log: Revision 1.18  2007/04/06 07:08:00  ilgiga
//! Log: bug fix 98191
//


