//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: GuardMacros
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OXFGuardMacros.h $
//!	File version	: $Revision: 1.13 $
//
//!	Date changed	: $Date: 2007/04/06 07:07:59 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef OXFGuardMacros_H 

#define OXFGuardMacros_H 
//----------------------------------------------------------------------------
// OXFGuardMacros.h                                                                  
//----------------------------------------------------------------------------

//## package Design::oxf::Services::Macros::GuardMacros 


// Guarding macros

// Unlock a reactive object guard
//#[ type END_REACTIVE_GUARDED_SECTION 
#define END_REACTIVE_GUARDED_SECTION 						\
{ 								\
	if (getThread() != NULL) 	\
	{							\
		getThread()->unlock(); 	\
	}							\
}
//#]

// Unlock an active object guard
//#[ type END_THREAD_GUARDED_SECTION 
#define END_THREAD_GUARDED_SECTION { unlock(); }
//#]

// Guard an operation using an OMGuard enter-exit object
//#[ type GUARD_OPERATION 
#define GUARD_OPERATION OMGuard _omGuard(getGuard()); 
//#]

// Declare an OMProtected object and helpers to support guarding of a resource
//#[ type OMDECLARE_GUARDED 
#define OMDECLARE_GUARDED													\
public:																	\
	inline void lock() const { m_omGuard.lock(); }						\
	inline void unlock() const { m_omGuard.unlock(); }						\
	inline const OMProtected& getGuard() const { return m_omGuard; }	\
private:																\
	OMProtected m_omGuard; 
//#]

// Guard a reactive object destructor
//#[ type START_DTOR_REACTIVE_GUARDED_SECTION 
#define START_DTOR_REACTIVE_GUARDED_SECTION													\
{															\
	if (!isUnderDestruction()) 								\
	{														\
		setUnderDestruction();								\
		if (getToGuardReactive() && (getThread() != NULL)) 	\
		{													\
			getThread()->lock();							\
		}													\
	}														\
}
//#]

// Guard an active object destructor
//#[ type START_DTOR_THREAD_GUARDED_SECTION 
#define START_DTOR_THREAD_GUARDED_SECTION							\
{									\
	if (!isUnderDestruction()) 		\
	{								\
		setUnderDestruction();		\
		if (shouldGuardThread()) 	\
		{							\
			OMThread::lock();		\
		}							\
	}								\
}
//#]

// Lock a reactive object guard
//#[ type START_REACTIVE_GUARDED_SECTION 
#define START_REACTIVE_GUARDED_SECTION 						\
{ 								\
	if (getThread() != NULL) 	\
	{							\
		getThread()->lock();	\
	}							\
}
//#]

// Lock an active object guard
//#[ type START_THREAD_GUARDED_SECTION 
#define START_THREAD_GUARDED_SECTION { lock(); }
//#]




#endif  
//
//! Log: $Log: OXFGuardMacros.h $
//! Log: Revision 1.13  2007/04/06 07:07:59  ilgiga
//! Log: bug fix 98191
//


