//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMMemoryManagerSwitchHelperImpl
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OMMemoryManagerSwitchHelperImpl.h $
//!	File version	: $Revision: 1.16 $
//
//!	Date changed	: $Date: 2007/04/06 07:07:46 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef OMMemoryManagerSwitchHelperImpl_H 

#define OMMemoryManagerSwitchHelperImpl_H 

#include "OXFMemoryManagerMacros.h"
#include <assert.h>
#include "OXFMemoryPoolsMacros.h"
#include "OXFPools.h"

//----------------------------------------------------------------------------
// OMMemoryManagerSwitchHelperImpl.h                                                                  
//----------------------------------------------------------------------------

//## package Design::oxf::Services::MemoryManagement::Manager 


// Support switch of the memory manager after memory was already requested.
// This support is required since the memory must return via the manager that allocated it.
// This class perform the actual recording of the memory it should no be accessed or included directly.
//## class OMMemoryManagerSwitchHelperImpl 

//#[ ignore 
#if (!defined(OM_NO_FRAMEWORK_MEMORY_MANAGER) && !defined(OMOMATE))
//#]
class OMMemoryManagerSwitchHelperImpl  {
public :
    
        
        // A node in the memory managers list
        // Used by OMMemoryManagerSwitchHelper
        //## class OMMemoryManagerSwitchHelperImpl::Node 
        class Node  {
        
            DECLARE_MEMORY_ALLOCATOR(Node, OM_MEMORY_MANAGER_SWITCH_HELPER_POOL_SIZE)
            
        
        
        ////    Constructors and destructors    ////
        public :
            
            // Initialize a node
            // Argument const void * mem : 
            // The memory to record by the node
            // Argument Node* nextNode : 
            // The next node on the list (to connect to)
            //## operation Node(void *,Node*) 
            Node(const void * mem, Node* nextNode);
            
            // Initialize an empty node
            //## operation Node() 
            Node();
            
            //## auto_generated 
            ~Node();
        
        
        ////    Operations    ////
        public :
            
            // assert when run out of memory
            // Argument int /**/ : 
            // dummy - in order to comply with the pool signature.
            //## operation outOfMemoryAssert(int) 
            inline static Node* outOfMemoryAssert(int /**/) {
                //#[ operation outOfMemoryAssert(int) 
                assert(false);
                return 0;
                //#]
            }
            
        
        
        ////    Additional operations    ////
        public :
            
            //## auto_generated 
            const void * getAllocatedMemory() const;
            
            //## auto_generated 
            Node* getNext() const;
            
            //## auto_generated 
            void setNext(Node* p_Node);
        
        
        ////    Framework operations    ////
        protected :
            
            //## auto_generated 
            void cleanUpRelations();
        
        
        ////    Attributes    ////
        public :
            
            // The allocated memory address
            const void * allocatedMemory;		//## attribute allocatedMemory 
            
        
        ////    Relations and components    ////
        public :
            
            // The next node in the memory list
            Node* next;		//## link next 
            
        
        
        };
        
    
//## class OMMemoryManagerSwitchHelperImpl 


////    Constructors and destructors    ////
public :
    
    // CTOR
    //## operation OMMemoryManagerSwitchHelperImpl() 
    OMMemoryManagerSwitchHelperImpl() : shouldUpdateLog(true) ,_recordedMemory(NULL)
    	 {
        //#[ operation OMMemoryManagerSwitchHelperImpl() 
        //#]
    }
    
    
    // DTOR
    //## operation ~OMMemoryManagerSwitchHelperImpl() 
    ~OMMemoryManagerSwitchHelperImpl() {
        //#[ operation ~OMMemoryManagerSwitchHelperImpl() 
        cleanup();
        //#]
        cleanUpRelations();
    }
    


////    Operations    ////
public :
    
    // cleanup the allocated memory list
    //## operation cleanup() 
    void cleanup();
    
    // search for a recorded memory allocation
    // return 'true' if the memory was found in the recorded memory
    //  or 'false' when the memory is not found
    // Argument const void * memory : 
    // The memory to find
    //## operation findMemory(void *) const 
    bool findMemory(const void * memory) const;
    
    // return the internally used singleton instance 
    // of the OMMemoryManagerSwitchHelper
    //## operation instance() 
    static OMMemoryManagerSwitchHelperImpl* instance();
    
    // check if the memory log is empty
    //## operation isLogEmpty() const 
    inline bool isLogEmpty() const {
        //#[ operation isLogEmpty() const 
        return (_recordedMemory == 0);
        //#]
    }
    
    
    // record a single memory allocation
    // return true on success
    // Argument const void * memory : 
    // The memory to log
    //## operation recordMemoryAllocation(void *) 
    bool recordMemoryAllocation(const void * memory);
    
    // record a single memory deallocation
    // return true if memory record found & removed ok
    // Argument const void * memory : 
    // The memory to remove from the log
    //## operation recordMemoryDeallocation(void *) 
    bool recordMemoryDeallocation(const void * memory);


////    Additional operations    ////
public :
    
    //## auto_generated 
    bool shouldUpdate() const;
    
    //## auto_generated 
    void setUpdateState(bool p_shouldUpdateLog);


////    Framework operations    ////
protected :
    
    //## auto_generated 
    void cleanUpRelations();


////    Attributes    ////
private :
    
    // should update the log state flag
    bool shouldUpdateLog;		//## attribute shouldUpdateLog 
    

////    Relations and components    ////
private :
    
    // The head of the recorded memory list
    Node* _recordedMemory;		//## link _recordedMemory 
    


};


//#[ ignore 

#endif //(!defined(OM_NO_FRAMEWORK_MEMORY_MANAGER) && !defined(OMOMATE))
//#]



#endif  
//
//! Log: $Log: OMMemoryManagerSwitchHelperImpl.h $
//! Log: Revision 1.16  2007/04/06 07:07:46  ilgiga
//! Log: bug fix 98191
//


