//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMAnimHelper
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OMAnimHelper.h $
//!	File version	: $Revision: 1.8 $
//
//!	Date changed	: $Date: 2007/04/06 07:07:36 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef OMAnimHelper_H 

#define OMAnimHelper_H 

#include "IOxfAnimHelper.h"

//----------------------------------------------------------------------------
// OMAnimHelper.h                                                                  
//----------------------------------------------------------------------------

class OMString;
class OMTimeout;
class OMUnicodeHelper;

//## package Design::oxf::Anim::AnimImplementation 


// OMReactive animation wrapper
//## class OMAnimHelper 
class RP_FRAMEWORK_DLL OMAnimHelper : public IOxfAnimHelper {


////    Constructors and destructors    ////
public :
    
    //## auto_generated 
    ~OMAnimHelper();


////    Operations    ////
public :
    
    // The operation will return false and an empty string for user events, and the event class name for animated 
    // internal framework events (e.g. start behavior, timeouts)
    // Returns true if the event was handled (invisible framework events should return true and with an empty 
    // signature)
    // Argument const IOxfEvent* event : 
    // the event to get the signature for
    // Argument OMString& className : 
    // The specified event animation signature
    // Argument bool signatureFormat : 
    // Specify that the class name should be return in a signature format i.e. <class>()
    //## operation getFrameworkEventClassName(IOxfEvent,OMString,bool) const 
    bool getFrameworkEventClassName(const IOxfEvent* event, OMString& className, bool signatureFormat = false) const;
    
    // he operation will return false and empty string for user events, and the event signature for animated internal 
    // framework events (e.g. start behavior, timeouts)
    // Returns true if the event was handled (invisible framework events should return true and with an empty 
    // signature)
    // Argument const IOxfEvent* event : 
    // the event to get the signature for
    // Argument OMString& signature : 
    // The specified event animation signature
    //## operation getFrameworkEventSignature(IOxfEvent,OMString) const 
    bool getFrameworkEventSignature(const IOxfEvent* event, OMString& signature) const;
    
    // Get the singleton instance
    //## operation instance() 
    static OMAnimHelper* instance();
    
    // Return true if the provided event is cancelled
    // Argument const IOxfEvent* ev : 
    // the event
    //## operation isCancelledEvent(IOxfEvent) const 
    bool isCancelledEvent(const IOxfEvent* ev) const;
    
    // Return true if the provided event is a timeout
    // Argument const IOxfEvent* ev : 
    // the event
    //## operation isTimeoutEvent(IOxfEvent) const 
    bool isTimeoutEvent(const IOxfEvent* ev) const;

private :
    
    // Fill the signature for the provided delay-timeout
    // Argument const OMTimeout* tm : 
    // The delay-timeout
    // Argument OMString& signature : 
    // The signature to fill
    //## operation fillDelaySignature(OMTimeout,OMString) const 
    void fillDelaySignature(const OMTimeout* tm, OMString& signature) const;
    
    // Fill the string with the time for the provided timeout
    // Argument const OMTimeout* tm : 
    // The timeout
    // Argument OMString& str : 
    // The string to fill
    //## operation fillTime(OMTimeout,OMString) const 
    void fillTime(const OMTimeout* tm, OMString& str) const;
    
    // Fill the signature for the provided timeout
    // Argument const OMTimeout* tm : 
    // The timeout
    // Argument OMString& signature : 
    // The signature to fill
    //## operation fillTimeoutSignature(OMTimeout,OMString) const 
    void fillTimeoutSignature(const OMTimeout* tm, OMString& signature) const;


};


#endif  
//
//! Log: $Log: OMAnimHelper.h $
//! Log: Revision 1.8  2007/04/06 07:07:36  ilgiga
//! Log: bug fix 98191
//


