//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMAbstractContainer
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OMAbstractContainer.h $
//!	File version	: $Revision: 1.15 $
//
//!	Date changed	: $Date: 2007/04/06 07:07:34 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef OMAbstractContainer_H 

#define OMAbstractContainer_H 

#include "OMNullValue.h"

//----------------------------------------------------------------------------
// OMAbstractContainer.h                                                                  
//----------------------------------------------------------------------------

template <class  Concept> class OMIterator;

//## package Design::oxf::Services::Containers::TypeSafe 


// A generic type-safe container, Used by OMIterator<> to iterate over the derived containers.
//## class OMAbstractContainer 
template <class Concept> class OMAbstractContainer  {


////    Friends    ////
public :
    
    friend  class OMIterator<Concept>;


////    Constructors and destructors    ////
public :
    
    // Virtual destructor to enable polymorphic deletion
    //## operation ~OMAbstractContainer() 
    virtual ~OMAbstractContainer() {
        //#[ operation ~OMAbstractContainer() 
        //#]
    }
    


////    Operations    ////
private :
    
    // Get the element at the given position (called by the iterator)
    // Argument void * pos : 
    // The current iterator position
    //## operation getCurrent(void *) const 
    virtual Concept &  getCurrent(void * pos) const=0;
    
    // Set the initial position for the iterator
    // Argument void*& pos : 
    // The position to set
    //## operation getFirst(void*&) const 
    virtual void getFirst(void*& pos) const=0;
    
    // Update the provided position to the next position in the container
    // Argument void*& pos : 
    // The position to update
    //## operation getNext(void*&) const 
    virtual void getNext(void*& pos) const=0;


};
//## class OMAbstractContainer 





#endif  
//
//! Log: $Log: OMAbstractContainer.h $
//! Log: Revision 1.15  2007/04/06 07:07:34  ilgiga
//! Log: bug fix 98191
//


