//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: IOxfTickTimerFactory
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/IOxfTickTimerFactory.h $
//!	File version	: $Revision: 1.10 $
//
//!	Date changed	: $Date: 2007/04/06 07:07:33 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef IOxfTickTimerFactory_H 

#define IOxfTickTimerFactory_H 

#include "os.h"

//----------------------------------------------------------------------------
// IOxfTickTimerFactory.h                                                                  
//----------------------------------------------------------------------------

//## package Design::oxf::Services::Time::TimeAPI 


// Low-level timer factory interface.
// Enable the user to plug-in its own tick-timers that are created by the implementation of the factory.
// The factory enables the user to replace the low-level timer without modifying the adapter timer implementation.
//## class IOxfTickTimerFactory 
class RP_FRAMEWORK_DLL IOxfTickTimerFactory  {
public :
    //#[ ignore 
    // A callback function signature that should be passed to the tick-timer to perform a tick action
    typedef void (*TimerManagerCallBack)(void*);
    //#]
    
    


////    Constructors and destructors    ////
public :
    
    // Virtual destructor to enable polymorphic deletion
    //## operation ~IOxfTickTimerFactory() 
    virtual ~IOxfTickTimerFactory() {
        //#[ operation ~IOxfTickTimerFactory() 
        //#]
    }
    


////    Operations    ////
public :
    
    // create a real-time timer.
    // the timer should call the TimerManagerCallBack(callBackParams) every tickTime.
    // The method returns a handle to the timer, so it can be deleted when the timer manager is destroyed.
    // Argument OxfTimeUnit tickTime : 
    // The timer resolution
    // Argument TimerManagerCallBack callBack : 
    // The timer action callback
    // Argument void * callBackParams : 
    // callback arguments
    //## operation createRealTimeTimer(OxfTimeUnit,TimerManagerCallBack,void *) const 
    virtual OMOSTimer* createRealTimeTimer(OxfTimeUnit tickTime, TimerManagerCallBack callBack, void * callBackParams)
     const=0;
    
    // create a simulated-time timer.
    // the timer should call the TimerManagerCallBack(callBackParams) when the rest of the application is idle.
    // The method returns a handle to the timer, so it can be deleted when the timer manager is destroyed.
    // Argument TimerManagerCallBack callBack : 
    // The timer action callback
    // Argument void * callBackParams : 
    // callback arguments
    //## operation createSimulatedTimeTimer(TimerManagerCallBack,void *) const 
    virtual OMOSTimer* createSimulatedTimeTimer(TimerManagerCallBack callBack, void * callBackParams) const=0;


};


#endif  
//
//! Log: $Log: IOxfTickTimerFactory.h $
//! Log: Revision 1.10  2007/04/06 07:07:33  ilgiga
//! Log: bug fix 98191
//


