//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: IOxfAnimReactive
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/IOxfAnimReactive.h $
//!	File version	: $Revision: 1.16 $
//
//!	Date changed	: $Date: 2007/04/06 07:07:28 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef IOxfAnimReactive_H 

#define IOxfAnimReactive_H 

#include "rp_framework_dll_definition.h"

//----------------------------------------------------------------------------
// IOxfAnimReactive.h                                                                  
//----------------------------------------------------------------------------

class AOMSState;
class IOxfEvent;
class IOxfReactive;
class OMString;

//## package Design::oxf::Anim::AnimAPI 


// An animation interface to the reactive class implementation
// Enables the animation layer to communicate with the reactive class implementation
//## class IOxfAnimReactive 
class RP_FRAMEWORK_DLL IOxfAnimReactive  {


////    Constructors and destructors    ////
public :
    
    // Cleanup
    //## operation ~IOxfAnimReactive() 
    virtual ~IOxfAnimReactive() {
        //#[ operation ~IOxfAnimReactive() 
        //#]
    }
    


////    Operations    ////
public :
    
    // Checks if the queue can accept a new event (if it is not full)
    //## operation canAcceptEvents() const 
    virtual bool canAcceptEvents() const=0;
    
    // get the identifier of the OS thread that is associated with the active context of the reactive instance
    //## operation getContextThread() const 
    virtual void * getContextThread() const=0;
    
    // Returns the "real" reactive part. 
    // Used (for example) to send events
    //## operation getOxfReactive() const 
    virtual IOxfReactive* getOxfReactive() const=0;
    
    // Send an animated event to the reactive context
    // Argument IOxfEvent* ev : 
    // The event
    // Argument void * sender : 
    // The event sender
    //## operation send(IOxfEvent,void *) 
    virtual bool send(IOxfEvent* ev, void * sender)=0;
    
    // Serializes the states.
    // Argument AOMSState* states : 
    // The animation states vector to fill.
    // AnimServices provides operations to fill the vector so all you need to do is to pass this pointer to these 
    // operations.
    //## operation serializeStates(AOMSState) const 
    virtual void serializeStates(AOMSState* states) const=0;


};


#endif  
//
//! Log: $Log: IOxfAnimReactive.h $
//! Log: Revision 1.16  2007/04/06 07:07:28  ilgiga
//! Log: bug fix 98191
//


