#ifndef omnote_H
#define omnote_H "$Id: omnote.h 1.17 2007/05/29 11:56:03 ilelpa Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/omcom/rcs/omnote.h $
//	file version:	$Revision: 1.17 $
//
//	purpose: define the OMNotify type and operations on it	
//		OMNotifys are messages sent from executable to tracer/animator
//		or from tracer/animator to executable
//
//	author(s):	Yachin Pnueli
//	date started:	20.5.96
//	date changed:	$Date: 2007/05/29 11:56:03 $
//	last change by:	$Author: ilelpa $
//
//	(c) Copyright Telelogic 1995, 2007
//

//
//	Each Notify/Command includes in comment the data that should be sent with it. For
//	more details on exact format of specific messages see
//  in the file where the message is created or consumed
//

#ifdef USING_DLL
#include <Dll/RP_ANIM_DLL/rp_anim_dll_definition.h>
#else
#define RP_ANIM_DLL
#endif

enum OMNotify {
	// 1. Regular messages (methods informing that something has happened)
	// 1.1 Regular messages sent to both TOMClass and TOMInstance items
	becameActivated,
	becameDeactivated,	// Possibly + the active method
	controlModified,	// either of the above
	// 1.2 Regular messages sent to a TOMClass items
	instanceCreated, 	// + pointer to the AOMInstance created
	instanceDeleted,	// + pointer to the TOMInstance deleted
	// 1.3 Regular messages sent to a TOMInstance
	enteredState,
	exitedState,   		// +  StateHandle
	stateModified,
	terminationReached, // 
	startedTransition,
	endedTransition,	// + TransitionHandle
	relationConnected, 	// + Pointer to TOMInstance added, Relation handle,
						// Boolean is it Composite, OMBoolean is it a singleton
	relationDisconnected,	// Pointer to TOMInstance deleted, Relation handle
	relationCleared, 	// Relation handle
	relationModified,
	// 1.4 Regular message sent to breakpoint items (any TOMProxy)
	// Not implemented in Prototype 3.
	breakpointActive,	// pointer to breakpoint proxy.
	// 1.5 Regular messages sent multiple types of destinations
	methodCalled,		// TOMInstances of from/to + method
						// (Signature or name+parameters)
	methodReturned,		// NULL.
	eventSent,
	eventTaken,			// TOMInstances of from/to + event
						// (Signature or name+parameters)
	setName,			// For global objects
	updatedAttributeValues,	// List of Attribute Name, Attribute Value
	timeoutSet,
	eventCancelled,

	classList,			// A list of all classes and event classes
	supperClassList,	// A list of all super classes of the " and "

	instanceList,		// A list of all "global" instances

	// 2. Serialize messages (messages where an item sends its "status"
	// 2.1 Serialize AOMInstance messages
	attributeValues,	// List of Attribute Name, Attribute Value
	updatedRelationsValues,		// relationHandle + list of TOMProxies in relation
	relationValues,		// relationHandle + list of TOMProxies in relation
	relationsValues,	// Relation Count + List of relations
	stateConfiguration,	// List of StateHandles (one for every active states)
	instanceValue,		// An InterestMask, + the above 4
	// 2.2 Serialize for "static" objects (AOMClass, callStack eventqueue etc.)
	// Not implemented in Prototype 3.
	callStackValues,	// List of methods
	eventQueueValues,	// List of Events
	pendingTimeoutValues, // List of pairs (event,time)
	classValues,		// List of pairs (AOMInstance*, TOMInstance*)
						// The TOMInstance* may be NULL.
						// This will cause the creation of a new TOMInstance
	allValues,			// Sereialize the entire executable
						// To implement this we need a TOMClassOfClasses item
	// 3. Messages requesting the creatation of a new proxy
	createProxy,		// Type of proxy to create (a OMProxyType value)
						// + Pointer to AOMItem
	errorFound,			// Code of the message causing the error
	// Commands
	// Not implemented in Prototype 3.
	createInstance, 	// + constructor parameters
	deleteInstance,		// + pointer to the to be deleted AOMInstance
	// Commands sent to an instance
	connectToRelation, 	// Relation handle + AOMInstance to be added
	disconnectFromRelation,	// Relation handle + AOMINstance to be removed
	clearRelation,
	callMethod,			// The Method (name + paramerter pairs (name,value) )
	takeEvent,			// The Event  (name + paramerter pairs (name,value) )
	setAttributeValues,		//  (Attribute name, Attribute Value)
	setStateConfiguration,	// List of active States
	// Commands set to various animated executable items
	setBreakpoint,	// breakpoint description.
	removeBreakpoint,	// breakpoint description.
	freezeBreakpoint,	// breakpoint description.
	activateBreakpoint,	// breakpoint description.
	proxyCreated,	// pointer to TOMInstance + new InterestMask
	newInterestMask,	// new InterestMask
	sendYourself,	// new InterestMask
	// Commands set to specific animated executable items
	addEventToQueue, // reciever + Event (name + parameter values)
	// Commands/Notifies between AOM/TOM steppers
	stoppedForStep,
	stoppedForEvent,
	stoppedForIdle,
	stoppedForBreakpoint,
	quitExecutable,
	suspendThread,
	resumeThread,
	// Commands to schedDispatcher
	stoppedMyself,
	waitForUser,
	sendBecameDeactivated,
	stoppedByUser,	// user invoked "break"
	stoppedByDebugger,
	withTimeStamp,		// add timestamp to the messages
	withoutTimeStamp,	// remove timestamp to the messages
	msgSenderWait,
	msgSenderResume,

	opList,
	createProxyOperation,
	callOpRequest,
	callOpReply,
	debuggerBreak,
	foreignMsg,
	omNameValue,
	opReturn,
	timeRequest,
	timeNotification

};

// Convert from OMNotify to String
RP_ANIM_DLL const char * omnotify2String(OMNotify);

//
// $Log: omnote.h $
// Revision 1.17  2007/05/29 11:56:03  ilelpa
// Timer service for test conductor
// Revision 1.16  2007/03/11 12:34:37  ilgiga
// Change copyright comment
// Revision 1.15  2007/03/01 16:43:32  ilgiga
// Telelogic instead of i-Logix
// Revision 1.14  2003/05/15 14:21:53  Eldad
// Fixed compile in Solaris
// Revision 1.13  2003/05/15 06:45:18  Eldad
// Serailization of output params and return value
// Revision 1.12  2003/05/08 09:57:24  Eldad
// Foreign Message
// Revision 1.11  2002/09/26 08:13:13  Eldad
// Supporting debug breakpoints notifications sent from the debugger to the animation.
// (Green Hills).
// Revision 1.10.1.2  2002/09/24 12:38:58  Eldad
// Revision 1.10.1.1  2002/07/29 08:31:27  Eldad
// Duplicate revision
// Revision 1.9.1.1  2002/07/16 15:15:01  Eldad
// Duplicate revision
// Revision 1.8.1.2  2002/07/03 15:54:13  Eldad
// Sending Messaging on a separate thread.
// Revision 1.8.1.1  2000/01/31 09:50:00  Eldad
// Duplicate revision
// Revision 1.7.1.2  2000/01/30 07:49:41  amos
// add withTimeStamp and withoutTimeStamp to OMNote - to support passing the timestamp intrest from TOM to AOM
// Revision 1.7  1999/11/08 14:01:51  zvika
// Add DLLs.
// Revision 1.6  1999/01/07 12:08:55  ofer
// adding stoppedByDebugger to intereset mask
// used by aomdbgbrk [taskid] command
// Revision 1.5  1998/08/02 15:08:58  beery
// changing boolean->OMBoolean
// Revision 1.4  1998/05/21 12:32:24  yachin
// Notify Tom when events are canceled
// Revision 1.3  1997/07/20 11:37:24  yachin
// Adding globals to animation
// Revision 1.2  1996/12/26 09:47:23  yachin
// Revision 1.1  1996/11/24 12:37:21  yachin
// Initial revision
//

#endif
