#ifndef ommask_H
#define ommask_H "$Id: ommask.h 1.18 2007/03/11 12:34:37 ilgiga Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/omcom/rcs/ommask.h $
//	file version:	$Revision: 1.18 $
//
//	purpose: define the OMInterestMask class
//  an InterestMask is a mask of 23 bits (int) describing what
//  "aspects" of an animation item are currently interesting.
//  an OMInterestMask is a class which contains an InterestMask
//  and can perform operations on it.
//
//	Also include Interest masks for STEPPERS
//
//	author(s):	Yachin Pnueli
//	date started:	9.7.96
//	date changed:	$Date: 2007/03/11 12:34:37 $
//	last change by:	$Author: ilgiga $
//
//	(c) Copyright Telelogic 1995, 2007
//

#include <oxf/rp_framework_dll_definition.h>

#ifdef USING_DLL
#include <Dll/RP_ANIM_DLL/rp_anim_dll_definition.h>
#else
#define RP_ANIM_DLL
#endif 

#ifndef _OM_NO_IOSTREAM
#ifdef OM_STL
#include <iostream>
#else
#include <iostream.h>
#endif // OM_STL
#endif // _OM_NO_IOSTREAM

// 1. List of "aspects"

// 1.1 Creation/Deletion of an item, its changing of name
const unsigned int  OMExistInterest			=	0x00000001;
// 1.2 Adding/Removing items from Relations
const unsigned int  OMRelationInterest		=	0x00000002;
// 1.3 Initialization/change in values of attributes
const unsigned int  OMAttributesInterest	=	0x00000004;
// 1.4 Initialization/Change of state of object
const unsigned int  OMStateInterest			=	0x00000008;
// 1.5 Report on gaining loosing Control of object
const unsigned int  OMControlInterest		=	0x00000010;
// 1.6 Report on "regular" method calls
const unsigned int  OMMethodsInterest		=	0x00000020;
// 1.7 Report on Constructor calls
const unsigned int  OMConstructorsInterest	=	0x00000040;
// 1.8 Report on Destructor calls
const unsigned int  OMDestructorsInterest	=	0x00000080;
// 1.9 Report on Timeout calls
const unsigned int  OMTimeoutsInterest		=	0x00000100;
// 1.10 Pass interest mask to my subClasses 
const unsigned int  OMSubClassInterest		=	0x00000200;
// 1.11 Include parameters in methods/events
const unsigned int  OMParameterInterest		=	0x00000400;
// 1.12 Pass interest mask to my descendents 
//const unsigned int  OMInstanceInterest	=	0x00000800;
const unsigned int  OMThreadInterest		=	0x00000800;

// 1.13 Check BreakPoints for this object
const unsigned int  OMBreakPointInterest	=	0x00001000;

// 1.14 Report when anim browser (i.e. TOM) is waiting for user's input
const unsigned int OMUserControl            =   0x00002000;

// 2. Useful "mask" constants 

// 2.1 Report on sending of events
const unsigned int  OMSendEventInterest		=	OMStateInterest;
// 2.2 Report on receiving events
const unsigned int  OMReceiveEventInterest	=	
				OMStateInterest | OMMethodsInterest;
// 2.3 Report on events
const unsigned int  OMEventInterest			=	
				OMReceiveEventInterest | OMSendEventInterest;
// 2.4 Nothing is interesting
const unsigned int  OMNoInterest			=	0x00000000;

// 2.5 Everything interesting ( "&" all non breakpoint "subjects" )
// Eldad: we skipped 1000 since it was skipped before (the old value of 
// OMAllInterest was fff and did not include OMBreakpoint interest). 
// Yachin and I don't know why OMBreakpoint was not included or what will
// happen if the value is changed.
// This mask is used for the notifyReadyForInput calls.

#ifdef OMTRACER
const unsigned int  OMAllInterest			=	0x00000fff;
#else
const unsigned int  OMAllInterest			=	0x00002fff;
#endif
// 2.6 Pass interest mask to a class's instances 
const unsigned int  OMInstanceInterest		=	0x000005fe;

// 3. The class itself
class RP_ANIM_DLL RP_FRAMEWORK_DLL OMInterestMask {
	unsigned int mask;
public:
	OMInterestMask(const unsigned int theMask = OMNoInterest) {
		mask = theMask;
	}

	// Method to convert back to "int"
	int toInt() const { return mask; }
	// Accessor
   	OMBoolean isInteresting(unsigned int theMask = OMAllInterest) const
	{ 
		if (mask & theMask)
			return TRUE;
		else
			return FALSE;
	}
	// & of interest masks
	OMInterestMask operator&(const OMInterestMask& theMask) {
		return operator&(theMask.mask); 	
	}
	OMInterestMask operator&(const unsigned int theMask) {
		return OMInterestMask( mask & theMask );	
	}
	// Difference between OMInterestMasks
	// a-b returns subjects interesting in "a" but not in "b"
	OMInterestMask operator-(const OMInterestMask& theMask) {
		return operator-(theMask.mask);
	}
	OMInterestMask operator-(const unsigned int theMask) {
		return OMInterestMask( mask & (~theMask) );
	}
	OMInterestMask operator-=(const unsigned int theMask) {
		mask &= (~theMask);
		return *this;
	}
	OMInterestMask operator-=(const OMInterestMask& theMask) {
		return operator-=(theMask.mask);
	}
	// Sums of OMInterestMasks
	// a+b returns subjects interesting in either "a" or "b" (or both)
	OMInterestMask operator+(const unsigned int theMask) {
		return OMInterestMask( mask | theMask );
	}
	OMInterestMask operator+(const OMInterestMask& theMask) {
		return operator+(theMask.mask);
	}
	OMInterestMask& operator+=(const unsigned int theMask) {
		mask |= theMask;
		return *this;
	}
	OMInterestMask& operator+=(const OMInterestMask& theMask) {
		return operator+=(theMask.mask);
	}
	// Comparison operators
	OMBoolean operator==(const OMInterestMask theMask) {
		return mask == theMask.mask;	}
	OMBoolean operator!=(const OMInterestMask theMask) {
		return mask != theMask.mask;	}

};

// Function to print OMInterestMasks as "hexa" integers
#ifndef _OM_NO_IOSTREAM
inline omostream& operator<<(omostream& os, const OMInterestMask mask) {
	return os<<omhex<<mask.toInt();
}
#endif // _OM_NO_IOSTREAM


//
//	Special interest masks for AOMStepper/TOMStepper
//

// Stop reasons which are not breakpoints proper
const unsigned int  OMNoStop			=	0x00000000;
const unsigned int  OMStopWhenNext		=	0x00000001;
const unsigned int  OMStopWhenEvent		=	0x00000002;
const unsigned int  OMStopWhenIdle		=	0x00000004;
const unsigned int  OMStopWhenStep		=	0x00000020;
// Currently unused. In future tell my proxy I stopped on break Point.
const unsigned int  OMStopBreakPoint	=	0x00000008;
// Stop event implecitly includes the stop idle
const unsigned int  OMNotifyIdle		=	0x00000027;//(20+4+2+1)

//
// $Log: ommask.h $
// Revision 1.18  2007/03/11 12:34:37  ilgiga
// Change copyright comment
// Revision 1.17  2007/03/01 16:43:32  ilgiga
// Telelogic instead of i-Logix
// Revision 1.16  2002/07/16 15:30:28  amos
// add include to iostream only when _OM_NO_IOSTREAM is not defined
// Revision 1.15  2002/07/16 07:30:50  amos
// add include to iostream
// Revision 1.14  2002/07/15 12:30:38  avrahams
// Back to main
// Revision 1.13.1.2  2002/07/04 11:33:50  avrahams
// Cleanup std namespace usage
// Revision 1.13.1.1  2001/06/14 16:05:16  avrahams
// Duplicate revision
// Revision 1.13  2001/06/14 16:05:16  Eldad
// Avoiding the mask changes in Tracer.
// Revision 1.12  2001/05/22 10:41:38  amos
// Revision 1.11.1.1  2001/05/02 12:46:36  Eldad
// Duplicate revision
// Revision 1.10  2000/12/27 09:01:58  amos
// Add support for framework as DLL - for support in Rhapsody C++ COM
// Revision 1.9  2000/01/19 12:32:25  amos
// back to main branch
// Revision 1.8.1.3  2000/01/12 14:07:04  amos
// fix masks for null transition step
// Revision 1.8.1.2  2000/01/04 15:11:38  amos
// change masks names: OMStopWhenStep to OMStopWhenNext, OMStopWhenSingleStep to OMStopWhenStep
// Revision 1.8.1.1  2000/01/03 16:24:55  amos
// add a OMSingleStep mask
// Revision 1.8  1999/11/08 18:36:54  zvika
// Add DLLs.
// Revision 1.7  1999/05/11 09:54:34  ofer
// Windows CE changes
// no iostream support and unicode ONLY ( no exceptions)
// Revision 1.6  1998/11/23 10:49:40  beery
// Revision 1.5  1998/08/02 15:08:58  beery
// changing boolean->OMBoolean
// Revision 1.4  1998/06/16 12:46:58  yachin
// Fix borland bug of bool is unsigned char
// Revision 1.3  1997/03/09 10:17:16  yachin
// bug fix
// Revision 1.2  1997/01/21 10:59:20  yachin
// changed _int32 to int
// Revision 1.1  1996/11/24 12:37:19  yachin
// Initial revision
//

#endif 
