/*********************************************************************
	Rhapsody	: 7.1 
	Component	: AnimMessages 
	Configuration 	: DefaultConfig
	Model Element	: AnimTimeNotification
	File Path	: ..\AnimTimeNotification.h
*********************************************************************/


#ifndef AnimTimeNotification_H 

#define AnimTimeNotification_H 

#include "RiCppAnimMessages.h"
#include "AnimAbstractMessage.h"
#include "oxf/rawtypes.h"

//## package RiCppAnimMessages 

//----------------------------------------------------------------------------
// AnimTimeNotification.h                                                                  
//----------------------------------------------------------------------------

class AnimField;
class AnimIntField;
class AnimMessage;
class AnimPointerField;
class AnimTimestampField;


// Notifies Rhapsody that the time specified in the AnimTimeRequest has elapsed
//## class AnimTimeNotification 
class AnimTimeNotification : public AnimAbstractMessage {


////    Constructors and destructors    ////
public :
    
    //## operation AnimTimeNotification() 
    AnimTimeNotification();
    
    //## auto_generated 
    virtual ~AnimTimeNotification();


////    Operations    ////
public :
    
    // Clones the message object.
    //## operation clone() 
    virtual AnimMessage* clone();
    
    //## operation setActualTimeInterval(int) 
    void setActualTimeInterval(int value);
    
    //## operation setElapsedTime(int) 
    void setElapsedTime(int value);
    
    //## operation setTimeInterval(int) 
    void setTimeInterval(int value);

protected :
    
    //## operation registerInTranslator() 
    void registerInTranslator();


////    Additional operations    ////
public :
    
    //## auto_generated 
    AnimIntField* getActualTimeInterval() const;
    
    //## auto_generated 
    AnimIntField* createNewActualTimeInterval();
    
    //## auto_generated 
    void deleteActualTimeInterval();
    
    //## auto_generated 
    AnimIntField* getElapsedTime() const;
    
    //## auto_generated 
    AnimIntField* createNewElapsedTime();
    
    //## auto_generated 
    void deleteElapsedTime();
    
    //## auto_generated 
    AnimIntField* getTimeInterval() const;
    
    //## auto_generated 
    AnimIntField* createNewTimeInterval();
    
    //## auto_generated 
    void deleteTimeInterval();


////    Framework operations    ////
protected :
    
    //## auto_generated 
    void initRelations();
    
    //## auto_generated 
    void cleanUpRelations();


////    Attributes    ////
private :
    
    // A static instance for registration.
    static AnimTimeNotification _timeNotification;		//## attribute _timeNotification 
    

////    Relations and components    ////
protected :
    
    AnimIntField* actualTimeInterval;		//## classInstance actualTimeInterval 
    
    
    AnimIntField* elapsedTime;		//## classInstance elapsedTime 
    
    
    AnimIntField* timeInterval;		//## classInstance timeInterval 
    


};


#endif  
/*********************************************************************
	File Path	: ..\AnimTimeNotification.h
*********************************************************************/

