/*********************************************************************
	Rhapsody	: 6.0 
	Component	: MessageTranslator 
	Configuration 	: DefaultConfig
	Model Element	: AnimStringOrPointerField
	File Path	: ..\AnimStringOrPointerField.h
*********************************************************************/


#ifndef AnimStringOrPointerField_H 

#define AnimStringOrPointerField_H 

#include "RiCppAnimMessageTranslator.h"
#include "AnimSimpleField.h"
#include "oxf/rawtypes.h"

//## package RiCppAnimMessageTranslator 

//----------------------------------------------------------------------------
// AnimStringOrPointerField.h                                                                  
//----------------------------------------------------------------------------
class AnimField;
class AnimMessageTranslator;


// The field contains either a string value or a pointer value. It may be used for storing serilaized values of arguments or attributes.
//## class AnimStringOrPointerField 
class AnimStringOrPointerField : public AnimSimpleField {


////    Constructors and destructors    ////
public :
    
    //## auto_generated 
    AnimStringOrPointerField();
    
    //## auto_generated 
    virtual ~AnimStringOrPointerField();


////    Operations    ////
public :
    
    //## operation clone() 
    AnimField* clone();
    
    // Call translator to dencode field from its specified protocol.
    // Argument AnimMessageTranslator* translator : 
    // The translator to dencode field. 
    //## operation decode(AnimMessageTranslator*) 
    virtual void decode(AnimMessageTranslator* translator);
    
    // Call translator to encode field to its specified protocol.
    // Argument AnimMessageTranslator* translator : 
    // The translator to encode field. 
    //## operation encode(AnimMessageTranslator*) 
    virtual void encode(AnimMessageTranslator* translator);
    
    // Returns the pointer value.
    //## operation getPointerValue() 
    virtual void * getPointerValue() const;
    
    // Return the string value as void*.
    //## operation getStringValue(OMBoolean) 
    virtual void * getStringValue(OMBoolean cloneStr = TRUE) const;
    
    //## operation getValue() 
    virtual void * getValue() const;
    
    //## operation getValue(OMBoolean) 
    virtual void * getValue(OMBoolean cloneStr) const;
    
    //## operation isPointer() 
    OMBoolean isPointer() const;
    
    //## operation isString() 
    OMBoolean isString() const;
    
    //## operation operator=(const AnimStringOrPointerField&) 
    AnimStringOrPointerField& operator=(const AnimStringOrPointerField& field);
    
    // Argument OMString val : 
    // The value of the field.
    //## operation operator=(OMString) 
    AnimStringOrPointerField& operator=(OMString val);
    
    // Argument void * pointerVal : 
    // The pointer value of the field.
    //## operation operator=(void *) 
    AnimStringOrPointerField& operator=(void * pointerVal);
    
    // Marks the field as containing a pointer value.
    //## operation setAsPointer() 
    void setAsPointer();
    
    // Marks the field as containing a string value.
    //## operation setAsString() 
    void setAsString();
    
    //## operation setPointerValue(void *) 
    void setPointerValue(void * p_value);
    
    //## operation setStringValue(void *) 
    void setStringValue(void * p_value);
    
    //## operation setValue(void *) 
    void setValue(void * p_value);


////    Attributes    ////
protected :
    
    // FALSE means pointer value unspecified.
    // TRUE means the field contains pointer value.
    OMBoolean isPointerFlag;		//## attribute isPointerFlag 
    
    // FALSE means string value unspecified.
    // TRUE means the field contains string value.
    OMBoolean isStringFlag;		//## attribute isStringFlag 
    
    // Stores the pointer value.
    void * pointerValue;		//## attribute pointerValue 
    
    // Stores the sting value.
    OMString stringValue;		//## attribute stringValue 
    

};


#endif  
/*********************************************************************
	File Path	: ..\AnimStringOrPointerField.h
*********************************************************************/

