/*********************************************************************
	Rhapsody	: 6.0 
	Component	: AnimMessages 
	Configuration 	: DefaultConfig
	Model Element	: AnimSetBreakpoint
	File Path	: ..\AnimSetBreakpoint.h
*********************************************************************/


#ifndef AnimSetBreakpoint_H 

#define AnimSetBreakpoint_H 

#include "RiCppAnimMessages.h"
#include "AnimAbstractMessage.h"
#include "oxf/rawtypes.h"

//## package RiCppAnimMessages 

//----------------------------------------------------------------------------
// AnimSetBreakpoint.h                                                                  
//----------------------------------------------------------------------------
class AnimCodeField;
class AnimField;
class AnimMessage;
class AnimPointerField;
class AnimStringField;
class AnimTimestampField;


// A message used for setting a breakpoint.
//## class AnimSetBreakpoint 
class AnimSetBreakpoint : public AnimAbstractMessage {


////    Constructors and destructors    ////
public :
    
    //## operation AnimSetBreakpoint() 
    AnimSetBreakpoint();
    
    //## auto_generated 
    virtual ~AnimSetBreakpoint();


////    Operations    ////
public :
    
    // Clones the message object.
    //## operation clone() 
    virtual AnimMessage* clone();
    
    //## operation setAnimItem(void *) 
    void setAnimItem(void * value);
    
    //## operation setBreakpointCode(unsigned char) 
    void setBreakpointCode(unsigned char value);
    
    //## operation setBreakpointData(OMString) 
    void setBreakpointData(OMString value);

protected :
    
    //## operation registerInTranslator() 
    void registerInTranslator();


////    Additional operations    ////
public :
    
    //## auto_generated 
    AnimPointerField* getAnimItem() const;
    
    //## auto_generated 
    AnimPointerField* newAnimItem();
    
    //## auto_generated 
    void deleteAnimItem();
    
    //## auto_generated 
    AnimCodeField* getBreakpointCode() const;
    
    //## auto_generated 
    AnimCodeField* newBreakpointCode();
    
    //## auto_generated 
    void deleteBreakpointCode();
    
    //## auto_generated 
    AnimStringField* getBreakpointData() const;
    
    //## auto_generated 
    AnimStringField* newBreakpointData();
    
    //## auto_generated 
    void deleteBreakpointData();


////    Framework operations    ////
protected :
    
    //## auto_generated 
    void initRelations();
    
    //## auto_generated 
    void cleanUpRelations();


////    Attributes    ////
private :
    
    // A static instance for registration.
    static AnimSetBreakpoint animSetBreakpoint;		//## attribute animSetBreakpoint 
    

////    Relations and components    ////
protected :
    
    AnimPointerField* animItem;		//## classInstance animItem 
    
    
    AnimCodeField* breakpointCode;		//## classInstance breakpointCode 
    
    
    AnimStringField* breakpointData;		//## classInstance breakpointData 
    


};


#endif  
/*********************************************************************
	File Path	: ..\AnimSetBreakpoint.h
*********************************************************************/

