/*********************************************************************
	Rhapsody	: 6.0 
	Component	: MessageTranslator 
	Configuration 	: DefaultConfig
	Model Element	: AnimRhapTranslator
	File Path	: ..\AnimRhapTranslator.h
*********************************************************************/


#ifndef AnimRhapTranslator_H 

#define AnimRhapTranslator_H 

#include "RiCppAnimMessageTranslator.h"
#include "AnimAbstractMessageTranslator.h"
#include "omcom/omsdata.h"

//## package RiCppAnimMessageTranslator 

//----------------------------------------------------------------------------
// AnimRhapTranslator.h                                                                  
//----------------------------------------------------------------------------
class AnimAbstractMessage;
class AnimBooleanField;
class AnimCodeField;
class AnimIntField;
class AnimListField;
class AnimMessage;
class AnimMessageField;
class AnimPointerField;
class AnimStringField;
class AnimStringOrPointerField;
class AnimTimestampField;


// Encodes\decodes messages to\from Rhapsody protocol.
//## class AnimRhapTranslator 
class OMOSMutex;

class AnimRhapTranslator : public AnimAbstractMessageTranslator {


////    Constructors and destructors    ////
protected :
    
    //## operation ~AnimRhapTranslator() 
    virtual ~AnimRhapTranslator();

private :
    
    //## operation AnimRhapTranslator() 
    AnimRhapTranslator();


////    Operations    ////
public :
    
    // Decode AnimIntField.
    // Argument AnimIntField* field : 
    // The field to be encoded.
    //## operation decodeField(AnimIntField*) 
    virtual void decodeField(AnimIntField* field);
    
    // Decode AnimPointerField.
    // Argument AnimPointerField* field : 
    // The field to be encoded.
    //## operation decodeField(AnimPointerField*) 
    virtual void decodeField(AnimPointerField* field);
    
    // Decode AnimListField.
    // Argument AnimListField* field : 
    // The field to be encoded.
    //## operation decodeField(AnimListField*) 
    virtual void decodeField(AnimListField* field);
    
    // Decode AnimStringField.
    // Argument AnimStringField* field : 
    // The field to be encoded.
    //## operation decodeField(AnimStringField*) 
    virtual void decodeField(AnimStringField* field);
    
    // In principle this method is never used since in Rhapsody, the "real" message is wrapped if a timestamp exists. (see decodeMessage for the actual decoding). 
    // Argument AnimTimestampField* field : 
    // The field to be encoded.
    //## operation decodeField(AnimTimestampField*) 
    virtual void decodeField(AnimTimestampField* field);
    
    // Decode AnimMessageField.
    // Argument AnimMessageField* field : 
    // The field to be encoded.
    //## operation decodeField(AnimMessageField*) 
    virtual void decodeField(AnimMessageField* field);
    
    // Decode AnimBooleanField.
    // Argument AnimBooleanField* field : 
    // The field to be encoded.
    //## operation decodeField(AnimBooleanField*) 
    virtual void decodeField(AnimBooleanField* field);
    
    // Decode AnimIntField.
    // Argument AnimCodeField* field : 
    // The field to be encoded.
    //## operation decodeField(AnimCodeField*) 
    virtual void decodeField(AnimCodeField* field);
    
    // Decode AnimPointerField.
    // Argument AnimStringOrPointerField* field : 
    // The field to be encoded.
    //## operation decodeField(AnimStringOrPointerField*) 
    virtual void decodeField(AnimStringOrPointerField* field);
    
    // Decodes protocol data to an AnimMessage.
    // Attention: this method allocates an AnimMessage instance. 
    // The caller is responsible to free it.
    // Argument void * data : 
    // Protocol data to be decoded.
    //## operation decodeMessage(void *) 
    virtual AnimMessage* decodeMessage(void * data);
    
    // Encode AnimIntField.
    // Argument AnimIntField* field : 
    // The field to be encoded.
    //## operation encodeField(AnimIntField*) 
    virtual void encodeField(AnimIntField* field);
    
    // Encode AnimListField.
    // Argument AnimListField* field : 
    // The field to be encoded.
    //## operation encodeField(AnimListField*) 
    virtual void encodeField(AnimListField* field);
    
    // Encode AnimPointerField.
    // Argument AnimPointerField* field : 
    // The field to be encoded.
    //## operation encodeField(AnimPointerField*) 
    virtual void encodeField(AnimPointerField* field);
    
    // Encode AnimStringField.
    // Argument AnimStringField* field : 
    // The field to be encoded.
    //## operation encodeField(AnimStringField*) 
    virtual void encodeField(AnimStringField* field);
    
    // Encode AnimTimestampField by "wrapping the message" (this is the current Rhapsody protocol implementation).
    // This is NOT symmetric with the decode.
    // Argument AnimTimestampField* field : 
    // The field to be encoded.
    //## operation encodeField(AnimTimestampField*) 
    virtual void encodeField(AnimTimestampField* field);
    
    // Encode AnimMessageField
    // Argument AnimMessageField* field : 
    // The field to be encoded.
    //## operation encodeField(AnimMessageField*) 
    virtual void encodeField(AnimMessageField* field);
    
    // Encode AnimBooleanField.
    // Argument AnimBooleanField* field : 
    // The field to be encoded.
    //## operation encodeField(AnimBooleanField*) 
    virtual void encodeField(AnimBooleanField* field);
    
    // Encode AnimIntField.
    // Argument AnimCodeField* field : 
    // The field to be encoded.
    //## operation encodeField(AnimCodeField*) 
    virtual void encodeField(AnimCodeField* field);
    
    // Encode AnimPointerField.
    // Argument AnimStringOrPointerField* field : 
    // The field to be encoded.
    //## operation encodeField(AnimStringOrPointerField*) 
    virtual void encodeField(AnimStringOrPointerField* field);
    
    // Encodes message to protocol.
    // Attention: This method allocates memory for the OMSData but does not release it. 
    // The caller is responsible to release the return value.
    // Argument AnimMessage* message : 
    // Message to be encoded\translated before sending to the other side 
    // (application or browser).
    //## operation encodeMessage(AnimMessage*) 
    virtual void * encodeMessage(AnimMessage* message);
    
    // initialize the mutexes that support multi-threaded application protection.
    // This method is called at the framework initialization.
    //## operation initializeMultiThreadedProtection() 
    void initializeMultiThreadedProtection();
    
    //## operation instance() 
    static AnimRhapTranslator* instance();


////    Additional operations    ////
protected :
    
    //## auto_generated 
    OMSData* getEncodedData() const;
    
    //## auto_generated 
    void setEncodedData(OMSData* p_encodedData);


////    Attributes    ////
protected :
    
    // A singleton instance.
    static AnimRhapTranslator* _instance;		//## attribute _instance 
    
    // The message being decoded.
    AnimMessage* decodedMessage;		//## attribute decodedMessage 
    
    OMSData* encodedData;		//## attribute encodedData 
    
private :
    
    // Mutex to protect decoding
    OMOSMutex* decodeMutex;		//## attribute decodeMutex 
    
    // Mutex to protect encoding
    OMOSMutex* encodeMutex;		//## attribute encodeMutex 
    
    // An OMSData attribute used during decoding. 
    OMSData* omsData;		//## attribute omsData 
    
    // An OMSPosition attribute used during decoding. 
    OMSPosition omsDataPosition;		//## attribute omsDataPosition 
    

};


#endif  
/*********************************************************************
	File Path	: ..\AnimRhapTranslator.h
*********************************************************************/

