/*********************************************************************
	Rhapsody	: 6.0 
	Component	: AnimMessages 
	Configuration 	: DefaultConfig
	Model Element	: AnimNameValueData
	File Path	: ..\AnimNameValueData.h
*********************************************************************/


#ifndef AnimNameValueData_H 

#define AnimNameValueData_H 

#include "RiCppAnimMessages.h"
#include "AnimAbstractMessage.h"
#include "oxf/rawtypes.h"

//## package RiCppAnimMessages 

//----------------------------------------------------------------------------
// AnimNameValueData.h                                                                  
//----------------------------------------------------------------------------
class AnimField;
class AnimMessage;
class AnimPointerField;
class AnimStringField;
class AnimStringOrPointerField;
class AnimTimestampField;


// Hold a name (AnimStringField) value (AnimStringOrPointerField) pair.
//## class AnimNameValueData 
class AnimNameValueData : public AnimAbstractMessage {


////    Constructors and destructors    ////
public :
    
    //## operation AnimNameValueData() 
    AnimNameValueData();
    
    //## auto_generated 
    virtual ~AnimNameValueData();


////    Operations    ////
public :
    
    // Clones the message object.
    //## operation clone() 
    virtual AnimMessage* clone();
    
    // Set the class name.
    //## operation setTheName(OMString) 
    void setTheName(OMString value);
    
    //## operation setTheValue(const AnimStringOrPointerField&) 
    void setTheValue(const AnimStringOrPointerField& value);

protected :
    
    //## operation registerInTranslator() 
    void registerInTranslator();


////    Additional operations    ////
public :
    
    //## auto_generated 
    AnimStringField* getTheName() const;
    
    //## auto_generated 
    AnimStringField* newTheName();
    
    //## auto_generated 
    void deleteTheName();
    
    //## auto_generated 
    AnimStringOrPointerField* getTheValue() const;
    
    //## auto_generated 
    AnimStringOrPointerField* newTheValue();
    
    //## auto_generated 
    void deleteTheValue();


////    Framework operations    ////
protected :
    
    //## auto_generated 
    void initRelations();
    
    //## auto_generated 
    void cleanUpRelations();


////    Attributes    ////
private :
    
    // A static instance for registration.
    static AnimNameValueData nameValiePrototype;		//## attribute nameValiePrototype 
    

////    Relations and components    ////
protected :
    
    // The name.
    AnimStringField* theName;		//## classInstance theName 
    
    
    // The value.
    AnimStringOrPointerField* theValue;		//## classInstance theValue 
    


};


#endif  
/*********************************************************************
	File Path	: ..\AnimNameValueData.h
*********************************************************************/

