/*********************************************************************
	Rhapsody	: 6.0 
	Component	: MessageTranslator 
	Configuration 	: DefaultConfig
	Model Element	: AnimListField
	File Path	: ..\AnimListField.h
*********************************************************************/


#ifndef AnimListField_H 

#define AnimListField_H 

#include "RiCppAnimMessageTranslator.h"
#include <oxf/omcollec.h>
#include "AnimField.h"
#include "oxf/rawtypes.h"

//## package RiCppAnimMessageTranslator 

//----------------------------------------------------------------------------
// AnimListField.h                                                                  
//----------------------------------------------------------------------------
class AnimMessageTranslator;
class AnimSimpleField;


// A List containing AnimClassData messages.
//## class AnimListField 
class AnimListField : public AnimField {


////    Constructors and destructors    ////
public :
    
    // Argument AnimSimpleField* fieldP : 
    // The type of fields this list contains.
    //## operation AnimListField(AnimSimpleField* ) 
    AnimListField(AnimSimpleField* fieldP);
    
    //## operation AnimListField() 
    AnimListField();
    
    //## operation ~AnimListField() 
    virtual ~AnimListField();


////    Operations    ////
public :
    
    //## operation addField(AnimSimpleField*) 
    void addField(AnimSimpleField* p_AnimSimpleField);
    
    //## operation clone() 
    AnimField* clone();
    
    // Call translator to dencode field from its specified protocol.
    // Argument AnimMessageTranslator* translator : 
    // The translator to dencode field. 
    //## operation decode(AnimMessageTranslator*) 
    virtual void decode(AnimMessageTranslator* translator);
    
    // Call translator to encode field to its specified protocol.
    // Argument AnimMessageTranslator* translator : 
    // The translator to encode field. 
    //## operation encode(AnimMessageTranslator*) 
    virtual void encode(AnimMessageTranslator* translator);
    
    // Returns a clone of the field prototype.
    //## operation getFieldPrototypeClone() 
    AnimSimpleField* getFieldPrototypeClone() const;
    
    // return the next field in the message.
    //## operation getNextField() 
    virtual AnimSimpleField* getNextField() const;
    
    //## operation operator=(const AnimListField&) 
    AnimListField& operator=(const AnimListField& _field);
    
    //## operation removeField(AnimSimpleField*) 
    void removeField(AnimSimpleField* p_AnimSimpleField);
    
    //## operation resetFieldIterator() 
    void resetFieldIterator();
    
    //## operation setFieldPrototype(AnimSimpleField*) 
    void setFieldPrototype(AnimSimpleField* fieldP);

protected :
    
    //## operation cleanUpRelations() 
    void cleanUpRelations();


////    Additional operations    ////
public :
    
    //## auto_generated 
    int getSize() const;
    
    //## auto_generated 
    void setSize(int p_size);
    
    //## auto_generated 
    OMIterator<AnimSimpleField*> getField() const;
    
    //## auto_generated 
    void clearField();


////    Attributes    ////
protected :
    
    // A field iterator, used for successive getNextField() calls.
    OMIterator<AnimSimpleField*>* fieldIterator;		//## attribute fieldIterator 
    
    // A prototype of the fields to be in the list.
    AnimSimpleField* fieldPrototype;		//## attribute fieldPrototype 
    
    // Number of fields in list.
    int size;		//## attribute size 
    

////    Relations and components    ////
protected :
    
    OMCollection<AnimSimpleField*> field;		//## link field 
    


};


#endif  
/*********************************************************************
	File Path	: ..\AnimListField.h
*********************************************************************/

