/*********************************************************************
	Rhapsody	: 6.0 
	Component	: AnimMessages 
	Configuration 	: DefaultConfig
	Model Element	: AnimDebuggerBreakPoint
	File Path	: ..\AnimDebuggerBreakPoint.h
*********************************************************************/


#ifndef AnimDebuggerBreakPoint_H 

#define AnimDebuggerBreakPoint_H 

#include "RiCppAnimMessages.h"
#include "AnimAbstractMessage.h"
#include "AnimStringOrPointerField.h"
#include "oxf/rawtypes.h"

//## package RiCppAnimMessages 

//----------------------------------------------------------------------------
// AnimDebuggerBreakPoint.h                                                                  
//----------------------------------------------------------------------------
class AnimBooleanField;
class AnimField;
class AnimIntField;
class AnimMessage;
class AnimPointerField;
class AnimTimestampField;


// A notification a debugger breakpoint is about to take place.
//## class AnimDebuggerBreakPoint 
class AnimDebuggerBreakPoint : public AnimAbstractMessage {


////    Constructors and destructors    ////
public :
    
    //## operation AnimDebuggerBreakPoint() 
    AnimDebuggerBreakPoint();
    
    //## auto_generated 
    virtual ~AnimDebuggerBreakPoint();


////    Operations    ////
public :
    
    // Clones the message object.
    //## operation clone() 
    virtual AnimMessage* clone();
    
    //## operation setIsRhapsodyBreak(OMBoolean) 
    void setIsRhapsodyBreak(OMBoolean value);
    
    //## operation setTaskID(int) 
    void setTaskID(int id);

protected :
    
    //## operation registerInTranslator() 
    void registerInTranslator();


////    Additional operations    ////
public :
    
    //## auto_generated 
    AnimBooleanField* getIsRhapsodyBreak() const;
    
    //## auto_generated 
    AnimBooleanField* newIsRhapsodyBreak();
    
    //## auto_generated 
    void deleteIsRhapsodyBreak();
    
    //## auto_generated 
    AnimIntField* getTaskID() const;
    
    //## auto_generated 
    AnimIntField* newTaskID();
    
    //## auto_generated 
    void deleteTaskID();


////    Framework operations    ////
protected :
    
    //## auto_generated 
    void initRelations();
    
    //## auto_generated 
    void cleanUpRelations();


////    Attributes    ////
private :
    
    // A static instance for registration.
    static AnimDebuggerBreakPoint animDebuggerBreakPointPrototype;		//## attribute animDebuggerBreakPointPrototype 
    

////    Relations and components    ////
protected :
    
    // Indicates if an exception was raised.
    AnimBooleanField* isRhapsodyBreak;		//## classInstance isRhapsodyBreak 
    
    
    AnimIntField* taskID;		//## classInstance taskID 
    


};


#endif  
/*********************************************************************
	File Path	: ..\AnimDebuggerBreakPoint.h
*********************************************************************/

