/*********************************************************************
	Rhapsody	: 6.0 
	Component	: MessageTranslator 
	Configuration 	: DefaultConfig
	Model Element	: AnimAbstractMessageTranslator
	File Path	: ..\AnimAbstractMessageTranslator.h
*********************************************************************/


#ifndef AnimAbstractMessageTranslator_H 

#define AnimAbstractMessageTranslator_H 

#include "RiCppAnimMessageTranslator.h"
#include <oxf/ommap.h>
#include "AnimMessageTranslator.h"
#include "oxf/rawtypes.h"

//## package RiCppAnimMessageTranslator 

//----------------------------------------------------------------------------
// AnimAbstractMessageTranslator.h                                                                  
//----------------------------------------------------------------------------
class AnimAbstractMessage;
class AnimMessage;


// An abstract translator. Implements 'common' translator mechanism. 
//## class AnimAbstractMessageTranslator 
class AnimAbstractMessageTranslator : public AnimMessageTranslator {


////    Constructors and destructors    ////
public :
    
    //## operation AnimAbstractMessageTranslator() 
    AnimAbstractMessageTranslator();
    
    //## auto_generated 
    virtual ~AnimAbstractMessageTranslator();

protected :
    
    // Copy constructor.
    //## operation AnimAbstractMessageTranslator(const AnimAbstractMessageTranslator& /*  */) 
    AnimAbstractMessageTranslator(const AnimAbstractMessageTranslator& /* _translator */);


////    Operations    ////
public :
    
    //## operation getLastErrorMessage() 
    virtual OMString getLastErrorMessage() const;
    
    // Get a clone of the message according to code.
    //## operation getMessageClone(int) 
    AnimMessage* getMessageClone(int code);
    
    // Register message prototypes to be 'cloned' for message decoding.
    // Argument AnimMessage* animMessage : 
    // Message to be registered.
    //## operation registerMessagePrototype(AnimMessage*) 
    virtual void registerMessagePrototype(AnimMessage* animMessage);

protected :
    
    //## operation operator=(const AnimAbstractMessageTranslator& /*  */) 
    void operator=(const AnimAbstractMessageTranslator& /* _translator */);


////    Additional operations    ////
public :
    
    //## auto_generated 
    void setLastErrorMessage(OMString p_lastErrorMessage);
    
    //## auto_generated 
    OMIterator<AnimAbstractMessage*> getMessagePrototypes() const;
    
    //## auto_generated 
    void clearMessagePrototypes();
    
    //## auto_generated 
    void removeMessagePrototypes(AnimAbstractMessage* p_AnimAbstractMessage);
    
    //## auto_generated 
    AnimAbstractMessage* getMessagePrototypes(int key) const;
    
    //## auto_generated 
    void addMessagePrototypes(int key, AnimAbstractMessage* p_AnimAbstractMessage);


////    Framework operations    ////
protected :
    
    //## auto_generated 
    void cleanUpRelations();


////    Attributes    ////
protected :
    
    // A string containing the last error message during encoding\decoding. 
    OMString lastErrorMessage;		//## attribute lastErrorMessage 
    

////    Relations and components    ////
protected :
    
    OMMap<int, AnimAbstractMessage*> messagePrototypes;		//## link messagePrototypes 
    


};


#endif  
/*********************************************************************
	File Path	: ..\AnimAbstractMessageTranslator.h
*********************************************************************/

