#ifndef aomtimerservice_H
#define aomtimerservice_H "$Id: aomtimerservice.h 1.5 2007/06/12 08:26:02 ilelpa Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/aom/rcs/aomtimerservice.h $
//	file version:	$Revision: 1.5 $
//
//	purpose: AOMTimerService is meant to be used to get time notification for an 
//			 external plugin (like TestConductor) that needs to get a notification
//			 that a time interval has passed in the animated application
//
//	author(s):	
//	date started:	
//	date changed:	$Date: 2007/06/12 08:26:02 $
//	last change by:	$Author: ilelpa $
//
//	(c) Copyright Telelogic Inc., 2007
//

#include <oxf/IOxfReactive.h>
#include "aomdisp.h"

class AOMTimerService : public IOxfReactive
{
public:
	
	// singleton pattern: get the singleton instance
	static AOMTimerService* instance();

	// request to be notified after deltaT
	void requestTimeNotification(const OxfTimeUnit delateT);

	// overrides the OMReacitve send - simply notifies that the time has passed
    virtual bool send(IOxfEvent* ev, const IOxfEventGenerationParams& params);
    
	// overrides the OMReacitve send - simply notifies that the time has passed
    virtual bool send(IOxfEvent* ev);

protected:
	// service operation to notify Rhapsody that the time has elapsed
	void notifyTimeElapsed(IOxfTimeout* timeout);

private:
	// avoid creation of instances other than the singleon
	AOMTimerService();

	// stores the singleton instance
	static AOMTimerService* _instance;

	// for getting the actual time difference
	OMMap <IOxfTimeout*, OxfTimeUnit> timeout2Basetime;

/* the following is an empty implementation of IOxfReactive pure virtual operations */
public:
    virtual bool cancelTimeout(const IOxfTimeout* timeout) {return false;}
    virtual void destroy() {}
    virtual void endBehavior(const char* /*theTerminator*/ = 0) {}
    virtual TakeEventStatus handleEvent(IOxfEvent* /*ev*/) {return eventNotConsumed;}
    virtual void popNullTransition() {}
    virtual void pushNullTransition() {}
    virtual bool startBehavior() {return false;}
protected:
    virtual void handleNotConsumed(IOxfEvent*, EventNotConsumedReason) {}
    virtual void handleTrigger(IOxfEvent*) {};
    virtual IOxfTimeout* scheduleTimeout(OxfTimeUnit , const char* ){ return NULL; };
public:
    virtual IOxfActive* getActiveContext() const {return NULL;};
    virtual void setActiveContext(IOxfActive*) {};
    virtual IOxfEvent* getCurrentEvent() const {return NULL;};

};

//
// $Log: aomtimerservice.h $
// Revision 1.5  2007/06/12 08:26:02  ilelpa
// Fixed AOM-OXF Decoupling - using only the interface IOxfReactive
// Revision 1.3  2007/06/11 14:39:37  ilelpa
// Fix build
// Revision 1.2  2007/06/10 07:48:44  ilelpa
// Fixed timer service for OSC
// Revision 1.1  2007/05/29 11:57:01  ilelpa
// Initial revision
//

#endif
