#ifndef aommsg_H
#define aommsg_H "$Id: aommsg.h 1.51 2007/03/11 11:57:52 ilgiga Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/aom/rcs/aommsg.h $
//	file version:	$Revision: 1.51 $
//
//	purpose: define AOMSxxxx classes above OMSData
//	These classes are the various message components or messages sent 
//	between AOM and TOM
//
//	author(s):	Yachin Pnueli
//	date started:	26.5.96
//	date changed:	$Date: 2007/03/11 11:57:52 $
//	last change by:	$Author: ilgiga $
//
//	(c) Copyright Telelogic 1995, 2007
//

#include "aomitem.h"
#ifndef OM_NO_OS_ASSERT
#include <assert.h>
#endif // OM_NO_OS_ASSERT

//
//	An AOMSSmartData is an OMSData item which given an AOMAnimationItem * 
//	to send knows to "transform it" to its proxy or a meaningful alternative
//
class RP_FRAMEWORK_DLL AOMSData:public OMSData {
public:
	virtual ~AOMSData() { }
	AOMSData() { }
	AOMSData(const AOMAnimationItem* destination, OMNotify what) {
		addItem(destination);
		addItem(what);
	}
//	AOMSSmartData(const char * s):OMSData(s) { }
	AOMSData(const AOMAnimationItem* destination, OMNotify what,const char * s) {
		addItem(destination);
		addItem(what);
		addItem(s);
	}
	AOMSData(const AOMAnimationItem* destination, OMNotify what,OMSData& s) {
		addItem(destination);
		addItem(what);
		addItem(s);
	}
	// A method to send an item by sending its proxy address
	void addItem(const AOMAnimationItem * const value) { 
		if (isCodeItem(value))
			OMSData::addItem((void *)value);
		else if (aomIsValidItem(value)) {  // Hope its an AOMAnimationItem
			if (value->getProxy()==0 || // The case of pre main objects
					value->getProxy()==OMInConstruction) {
				OMSData::addItem(OMInConstruction);
				OMSData::addItem(value);
			}
			else
				OMSData::addItem(value->getProxy());
		} else // If not then mark as non-existent
			OMSData::addItem(OMGarbage);
	}
	virtual void addItem(const unsigned char item)	{ OMSData::addItem(item); }	
	virtual void addItem(const bool item)			{ OMSData::addItem(item); }	
	virtual void addItem(const OMNotify item)		{ OMSData::addItem(item); }
	virtual void addItem(const OMSData& item)		{ OMSData::addItem(item); }
//	void addItem(const void * item); // deleted on purpose
	virtual void addItem(const int item)			{ OMSData::addItem(item); }
	virtual void addItem(const char * item)			{ OMSData::addItem(item); }
	virtual void addItem(const OMString * item)		{ OMSData::addItem(item); }
	virtual void addItem(const OMString& item)		{ OMSData::addItem(item); }

	virtual void addItem(const OMHandle* h, const OMString* i) { OMSData::addItem(h,i); }
	virtual void addItem(const OMHandle* h, const char* i) { OMSData::addItem(h,i); }
	virtual void addItem(const OMHandle* h, const void* i) { OMSData::addItem(h,i); }
	
	virtual void addItem(const void* item) { OMSData::addItem(item); }
	virtual void addItem(const unsigned long item) { OMSData::addItem(item); }

};
//
// A list of items where each item is a-priori known to be a singleton 
//	or a doubleton.
// Use it in one of two modes:
// 1. The number of items is not known A-priori.
//	1.1 list.setSList(countUnknown)
//  1.2 list.addItem(item) as many times as needed
//  1.3 list.end() to tell the list the last item was entered
//		end() returns the number of items in the list.
// 2. The number of items is known A-priori to be "n"
//	2.1 list.setSList(n)
//  2.2 list.addItem(item) "n" times
//	Note that calling end() here will have no effect except to return the 
//	number of items actually added.
//


const int countUnknown = (-1);	// Param./Attr. count of an item is unknown
const int positionUnneeded = (-1);

class RP_FRAMEWORK_DLL AOMSList:public AOMSData {
	int count;
	int position;
protected:
	virtual ~AOMSList() { }
	AOMSList():count(countUnknown) { }
	AOMSList(const AOMAnimationItem* destination, OMNotify what)
		:AOMSData(destination,what), count(countUnknown)  { }
	// "Actual" Constructors
	void setSList(const int theCount) { 
		// set count and position
		if (theCount==countUnknown) {
			// Remember the position where "count" should be placed
			position = getLength();
			 // Place there a dummy to advance the position
			OMSData::addItem(0);
		} else {
			 // Remember there is no need to remember the count position
			position = positionUnneeded;
			// Store the actual "count" in place
			OMSData::addItem(theCount); 
		}
		count = 0; // Start counting how many items we actually have
	}

public:

	// For single value
	virtual void addItem(const char * value)	{ count++; OMSData::addItem(value); }
	virtual void addItem(const int value)	{ count++; OMSData::addItem(value); }
	virtual void addItem(const OMString* value) { count++; OMSData::addItem(value); }
	virtual void addItem(AOMAnimationItem * value) { count++; AOMSData::addItem(value);	 }
	// For double value
	virtual void addItem(const OMHandle* name, const OMString* value) {
		count++;
		OMSData::addItem(name);
		OMSData::addItem(value);
	}
	virtual void addItem(const OMHandle* name, const char * value) {
		count++; 
		OMSData::addItem(name);
		OMSData::addItem(value);
	}

	virtual void addItem(const OMHandle* name, AOMAnimationItem * value) {
		count++; 
		OMSData::addItem(name);
		AOMSData::addItem(value);
	}

	virtual void addItemAndItsProxy(AOMAnimationItem* item) {
		count++; 
		OMSData::addItem(item);
		AOMSData::addItem(item);
	}

	virtual void addItem(OMSData& msg) {
		count++; 
		OMSData::addItem(msg);
	}

	virtual void addItem(const unsigned long item) { AOMSData::addItem(item); }
	virtual void addItem(const void* item) { AOMSData::addItem(item); }
	virtual void addItem(const char* h, const void* i) { AOMSData::addItem(h, i); }
	virtual void addItem(const OMString& item) { AOMSData::addItem(item); }
	virtual void addItem(const OMSData& item) { AOMSData::addItem(item); }
	virtual void addItem(const OMNotify item) { AOMSData::addItem(item); }
	virtual void addItem(const unsigned char item) { AOMSData::addItem(item); }
	virtual void addItem(const bool item) { AOMSData::addItem(item); }
	
	
	int end() {
		// Write the count if necessary
		if (position!=positionUnneeded)
			addItemAtPosition(count, position);
		return count;
	}

};


//
// An AOMSAttributes is an AOMSList where each item is a pair of name + value.
// Note: value is either (char *), (OMString*) or (AOMAnimationItem *)
//
class RP_FRAMEWORK_DLL AOMSAttributes: public AOMSList {
public:
	virtual ~AOMSAttributes() { }
	AOMSAttributes() { }
	void setCount(int attrCount) { setSList(attrCount); }
	AOMSAttributes(const AOMAnimationItem * destination, OMNotify what)
		:AOMSList(destination,what) { }
/*
	void addAttribute(OMHandle* name, const OMString* value) { 
		AOMSList::addItem(name,value);
	}
*/

	void addAttribute(const OMHandle* name, char * value) { 
		AOMSList::addItem(name,value);
		delete[] value; // To avoid the leak in x2String
	}

	void addAttribute(const OMHandle* name, AOMAnimationItem * value) { 
		AOMSList::addItem(name,value);
	}
};

//
// An AOMSState is an AOMSList of the currrently active states
// each state is identified by its handle
//
class RP_FRAMEWORK_DLL AOMSState: public AOMSList
{
public:
	virtual ~AOMSState() { }
	// Constructors
	AOMSState() { setSList(countUnknown); }
	// Allows only OMHandle values
	void addTerminate(bool isTerminated) { 
		OMSData::addCode((unsigned char)isTerminated); }
	void addState(const char* name) { AOMSList::addItem(name); }
	void addState(const OMString* name) { AOMSList::addItem(name); }
};

//
// An AOMSMethod is an AOMSAttributes which has a "title".
// This title is either the name of the method, in which case it is
// followed by pairs of parameter name,value
// or it is the Signature of the method in which case no elements follow
// (theCount=AOMSnoParameters).
//
//	AOMSnoParameters is needed to distinguish the case of No Parameters from
//  the case where we send parameters but happen to have "0" of them.
//
class RP_FRAMEWORK_DLL AOMSMethod :public AOMSAttributes {
public:
	virtual ~AOMSMethod() { }
	// Constructors
	AOMSMethod(const OMHandle* name, int theCount=OMSnoParameters){
		addItem(name);
		setSList(theCount);
	}
	char * getMethodName() { 
		OMSPosition p = getFirst();
		return getChar(p); }
};

//
// An AOMSEvent is currently identical to an AOMSMethod
//
class RP_FRAMEWORK_DLL AOMSEvent :public AOMSMethod {
public:
	virtual ~AOMSEvent() { }
	// Constructors
	AOMSEvent(const OMHandle* name, int theCount=OMSnoParameters)
		:AOMSMethod(name, theCount) { }
	void addEventId(const void* id) { OMSData::addItem(id); }
};


//
// An AOMSRelation is an AOMList with a title (the relation name) where each
// item is a singleton of type AOMInstance *.
//
class RP_FRAMEWORK_DLL AOMSRelation :public AOMSList {
protected:
	void setSRelation(const OMHandle* relationName, 
					 bool isComposite, 
					 bool isSingleton, 
					 int theCount) {
		AOMSList::addItem(relationName);
		OMSData::addCode((unsigned char)isComposite);
		OMSData::addCode((unsigned char)isSingleton);
		setSList(theCount);
	}
	AOMSRelation() { }
	AOMSRelation(const AOMAnimationItem * destination, OMNotify what)
		:AOMSList(destination,what){ }
public:
	virtual ~AOMSRelation() { }
	// Constructors
	AOMSRelation(const OMHandle* relationName, 
				 bool isComposite, 
				 bool isSingleton, 
				 int theCount=countUnknown) { 
		setSRelation(relationName, isComposite, isSingleton, theCount); }

	void addItem(const char * value) { AOMSList::addItem(value); }
	// Allow singleton values only
	virtual void addItem(AOMAnimationItem * value) { if (value != 0) AOMSList::addItem(value); }
	virtual void addItem(OMSData& item) { AOMSData::addItem(item); }
	virtual void addItem(const OMString* item) { AOMSData::addItem(item); }
	virtual void addItem(const int item) { AOMSData::addItem(item); }
	virtual void addItem(const char* h, const char* i) { AOMSData::addItem(h, i); }
	virtual void addItem(const char* h, const OMString* i) { AOMSData::addItem(h, i); }
	virtual void addItem(const unsigned char item) { AOMSList::addItem(item); }
	virtual void addItem(const bool item) { AOMSList::addItem(item); }
	virtual void addItem(const OMNotify item) { AOMSList::addItem(item); }
	virtual void addItem(const OMSData& item) { AOMSList::addItem(item); }
	virtual void addItem(const OMString& item) { AOMSList::addItem(item); }
	virtual void addItem(const char* h, const void* i) { AOMSList::addItem(h, i); }
	virtual void addItem(const void* item) { AOMSList::addItem(item); }
	virtual void addItem(const unsigned long item) { AOMSList::addItem(item); }
	virtual void addItem(const char* h, AOMAnimationItem* i) {AOMSList::addItem(h, i); }
};


//
// AOMSRelations is an AOMSList where each "item" is a relation
// however to avoid copy overhead this is not realy a "list of lists"
// but rather a flat list of title, count, (title count elements)^*
// 
class RP_FRAMEWORK_DLL AOMSRelations :public AOMSRelation {
	int relCount;
	int relPosition;
	void setSList(int theCount) { 
		// set count and position
		if (theCount==countUnknown) {
			relPosition = getLength();
			OMSData::addItem(0); // just a dummy to advance the position
		} else {
			relPosition = positionUnneeded;
			OMSData::addItem(theCount); 
		}
		relCount = 0;
	}
public:
	virtual ~AOMSRelations() { }
	// Constructors
	AOMSRelations() { }
	void setCount(int attrCount) { setSList(attrCount); }

	void addRelation(const OMHandle* relationName, 
					 bool isComposite, 
					 bool isSingleton, 
					 int theCount=countUnknown) {
		// If we have a previous relation - end it
		if (relCount>0)	AOMSRelation::end();
		// Start the new relation
		setSRelation(relationName, isComposite, isSingleton, theCount);
		// update the Relation count
		relCount++;
	}
	int end() {
		// If we have a previous relation - end it
		if (relCount>0)	AOMSRelation::end();
		// Write the count if necessary
		if (relPosition!=positionUnneeded)
			addItemAtPosition(relCount, relPosition);
		return relCount;
	}
};


//
// An AOMSClass is an AOMSList where each item is a pair of 
//	AOMInstance *. TOMInstance *
//
class AOMSClass: public AOMSList {
public:
	virtual ~AOMSClass() { }
	AOMSClass(const AOMAnimationItem * destination, int attrCount)
		:AOMSList(destination, classValues) { setSList(attrCount); }

	virtual void addItem(AOMAnimationItem* item) { 
		if (aomIsValidItem(item))  // Hope the element is o.k.
			AOMSList::addItemAndItsProxy(item);
		else // Send error and ignore the element (should never happen)
			sendError("Found bad element in class");
	}

	virtual void addItem(const char* item) { AOMSList::addItem(item); }
	virtual void addItem(const unsigned char item) { AOMSList::addItem(item); }
	virtual void addItem(const bool item) { AOMSList::addItem(item); }
	virtual void addItem(const OMNotify item) { AOMSList::addItem(item); }
	virtual void addItem(const OMSData& item) { AOMSList::addItem(item); }
	virtual void addItem(const OMString& item) { AOMSList::addItem(item); }
	virtual void addItem(const char* h, const void* i) { AOMSList::addItem(h, i); }
	virtual void addItem(const void* item) { AOMSList::addItem(item); }
	virtual void addItem(const unsigned long item) { AOMSList::addItem(item); }
	virtual void addItem(const char* h, AOMAnimationItem* i) { AOMSList::addItem(h, i); }
	virtual void addItem(OMSData& item) { AOMSList::addItem(item); }
	virtual void addItem(const char* h, const char* i) { AOMSList::addItem(h, i); }
	virtual void addItem(const char* h, const OMString* i) { AOMSList::addItem(h, i); }
	virtual void addItem(const OMString* item) { AOMSList::addItem(item); }
	virtual void addItem(const int item) { AOMSList::addItem(item); }

};

//
//	The class of list of methods
//
class AOMSListOfMethods: public AOMSList {
public:
	virtual ~AOMSListOfMethods() { }
	// In constructor
	AOMSListOfMethods(const int theCount) {
		setSList(theCount);
	}
	void addMethodCall(AOMAnimationItem * caller, 
						AOMAnimationItem * called, 
						OMSData * method) {
		addItem(caller); // Also incrememnt the count
		AOMSData::addItem(called);
		AOMSData::addItem(*method);
	}
	void addMethodCall(AOMAnimationItem * caller, 
						AOMAnimationItem * called, 
						OMSData * method,
						OMMethodType type) {
		addMethodCall(caller, called, method);
		AOMSData::addCode((unsigned char)type);
	}

	void addMethodCall(int caller, 
						int called, 
						OMSData * method) {
		addItem(caller); // Also incrememnt the count
		AOMSData::addItem(called);
		AOMSData::addItem(*method);
	}
	void addMethodCall(int caller, 
						int called, 
						OMSData * method,
						OMMethodType type) {
		addMethodCall(caller, called, method);
		AOMSData::addCode((unsigned char)type);
	}

};


// used to report on creation of classes, events and packages.
// moved from AOMDisp.cpp for Java needs
class AOMSCreationMessage: public AOMSList {
public:
	virtual ~AOMSCreationMessage() { }
	AOMSCreationMessage(OMNotify theCode)
		:AOMSList(0, theCode) { setSList(countUnknown); }
	virtual void addItem(OMSData& msg) { AOMSList::addItem(msg); }

	virtual void addItem(const char* item) { AOMSList::addItem(item); }
	virtual void addItem(const unsigned char item) { AOMSList::addItem(item); }
	virtual void addItem(const bool item) { AOMSList::addItem(item); }
	virtual void addItem(const OMNotify item) { AOMSList::addItem(item); }
	virtual void addItem(const OMSData& item) { AOMSList::addItem(item); }
	virtual void addItem(const OMString& item) { AOMSList::addItem(item); }
	virtual void addItem(const char* h, const void* i) { AOMSList::addItem(h, i); }
	virtual void addItem(const void* item) { AOMSList::addItem(item); }
	virtual void addItem(const unsigned long item) { AOMSList::addItem(item); }
	virtual void addItem(const char* h, AOMAnimationItem* i) { AOMSList::addItem(h, i); }
	virtual void addItem(const char* h, const char* i) { AOMSList::addItem(h, i); }
	virtual void addItem(const char* h, const OMString* i) { AOMSList::addItem(h, i); }
	virtual void addItem(const OMString* item) { AOMSList::addItem(item); }
	virtual void addItem(const int item) { AOMSList::addItem(item); }
	virtual void addItem(AOMAnimationItem * value) { AOMSList::addItem(value); }


};


//
// $Log: aommsg.h $
// Revision 1.51  2007/03/11 11:57:52  ilgiga
// Change copyright comment
// Revision 1.50  2007/03/01 16:31:25  ilgiga
// Telelogic instead of i-Logix
// Revision 1.49  2005/04/21 10:03:25  amos
// Revision 1.48.1.3  2005/03/16 14:02:35  amos
// Revision 1.48.1.2  2005/03/10 14:25:07  amos
// Implementing AnimServices
// Revision 1.48.1.1  2004/08/11 07:12:11  amos
// Duplicate revision
// Revision 1.47  2004/06/27 15:43:04  amos
// move to model-based oxf in RiC++
// Revision 1.46  2004/05/02 09:07:23  amos
// add override on OMSData void addItem(const bool)
// Revision 1.44  2002/07/07 10:46:16  amos
// framework cleanup from RTOS specific code - back to r41 main branch
// Revision 1.43.2.2  2002/07/07 10:46:16  amos
// replace adaptor specific #ifdef with generic statements
// Revision 1.43.2.1  2001/12/09 08:51:17  amos
// Duplicate revision
// Revision 1.42  2001/06/21 10:37:52  Eldad
// Solaris warnings.
// Revision 1.41.1.1  2001/06/21 08:45:04  builder
// Revision 1.41  2001/05/16 12:32:33  amos
// merge OSE 4.3.1 support into r40
// Revision 1.40  2001/04/02 07:17:08  Eldad
// Initializing cout member - eliminate purify warning.
// Revision 1.39  2001/01/04 18:45:58  amos
// merge  (COM supprot) into r31
// Revision 1.38  2000/12/21 17:49:51  amos
// move to error level 4
// Revision 1.37.1.1  2000/12/27 08:45:20  amos
// Add support for framework as DLL - for support in Rhapsody C++ COM
// Revision 1.37  2000/09/06 15:05:12  ofer
// have to use the delete[]  when deleteing the value
// since the os.str allocate array of chars
// Revision 1.36  2000/08/06 07:04:25  amos
// merge 1.33.3.1 (changes to remove Solaris warnings) into 1.35
// Revision 1.35  2000/08/03 12:37:49  Eldad
// 1.34.1.2 to main branch
// Revision 1.34.1.2  2000/08/03 12:18:40  Eldad
// Removd constraints and added methods in favour of Java animation 
// translation
// Revision 1.34.1.1  2000/07/09 15:30:28  Eldad
// Duplicate revision
// Revision 1.33.2.2  2000/06/25 13:58:32  Eldad
// Revision 1.33.3.1  2000/07/24 11:28:12  amos
// in AOMSAttributes/AOMSList/AOMRelation/AOMRealtions replacetype of arguments from OMHandle* with const OMHandle*
// Revision 1.33  1999/05/11 11:56:29  ofer
// Windows CE changes
// no iostream support and unicode ONLY ( no exceptions)
// Revision 1.32  1999/02/18 11:51:00  yachin
// Fix bug 29466
// Revision 1.31  1999/02/16 06:08:03  yachin
// Speed up of construction during animation
// Revision 1.30  1998/08/02 15:02:05  beery
// changing boolean->bool
// Revision 1.29  1997/07/24 05:23:38  yachin
// Revision 1.28  1997/03/31 13:42:02  yachin
// Fix Unix Warning
// Revision 1.27  1997/02/26 08:01:14  yachin
// added x2String which takes 2 parameters, 
// addAttribute now deletes the char * pointer
// Revision 1.26  1997/02/06 13:31:05  yachin
// Switch from try to aomIsValidItem
// Revision 1.25  1996/12/23 11:52:45  yachin
// Add ids to events
// Revision 1.24  1996/12/08 10:10:37  yachin
// Revision 1.23  1996/11/24 12:55:26  yachin
// Revision 1.22  1996/10/23 08:07:57  yachin
// Fix bug i nshow #callStack
// Revision 1.21  1996/10/21 11:38:27  yachin
// Cleanup on state notifies + fixes on timeouts + support for breakpoints
// Revision 1.20  1996/10/13 11:41:02  yachin
// Bug fixes
// Revision 1.19  1996/10/09 07:33:59  yachin
// Revision 1.18  1996/09/29 12:41:49  yachin
// Send Relations together with "create proxy" message (fix relations bug
// Revision 1.17  1996/09/25 09:58:53  yachin
// Fix bug in eventQueueValues message
// Revision 1.16  1996/09/08 11:25:07  yachin
// Fixed some prolem with cons tin const functions
// Revision 1.15  1996/09/03 11:58:53  yachin
// Fix bugs in show #callStack
// Revision 1.14  1996/09/02 13:40:44  yachin
// Preparations for connecting with call stack view and MSC
// Revision 1.13  1996/08/28 05:35:24  ofer
// Revision 1.12  1996/08/08 08:22:17  yachin
// Prototype 4 major revision
// Revision 1.11  1996/07/28 06:24:00  yachin
// Revision 1.10  1996/07/28 06:17:24  yachin
// Revision 1.9  1996/07/28 06:07:53  yachin
// Revision 1.8  1996/07/18 10:48:56  yachin
// Post Prototype 3 rewrite: virtual destructors, remarks, type changes and safe programing on deleted items
// Revision 1.7  1996/07/15 12:38:41  yachin
// Revision 1.6  1996/07/14 07:30:17  yachin
// Revision 1.5  1996/07/10 09:12:08  yachin
// Revision 1.4  1996/07/10 05:46:59  yachin
// Reorganization + some stuff for OMANIMATOR
// Revision 1.3  1996/06/20 10:21:53  yachin
// Revision 1.2  1996/06/19 10:18:50  yachin
// Revision 1.1  1996/06/17 05:33:20  yachin
// Initial revision
//

#endif
