#ifndef aominst_H
#define aominst_H "$Id: aominst.h 1.47 2007/03/11 11:57:52 ilgiga Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/aom/rcs/aominst.h $
//	file version:	$Revision: 1.47 $
//
//	purpose:	Super class of all Executable "instance" items
//				( "     "    "   "  real classes)
//
//	author(s):	  Yachin Pnueli
//	date started:	5.6.96
//	date changed:	$Date: 2007/03/11 11:57:52 $
//	last change by:	$Author: ilgiga $
//
//	(c) Copyright Telelogic 1995, 2007
//
#include "aomitem.h"
//
//	AOMInstance	-	The Animated executable Instances
//
class AOMClass;
class AOMSAttributes;
class AOMSRelations;
class AOMSState;
class AOMSMethod;
class AOMEvent;
class IOxfReactive;
class IOxfEvent;
class IOxfAnimReactive;

class RP_FRAMEWORK_DLL AOMInstance : public AOMAnimationItem
{
public:
	AOMInstance();
	AOMInstance(AOMInstance&);
	AOMInstance(const IOxfReactive* reactivePart);
	virtual ~AOMInstance();

	virtual void serializeAttributes(AOMSAttributes *) const { }
	virtual void serializeRelations(AOMSRelations *) const { }
	virtual void serializeStates(AOMSState *) const { }
	 // overide by the real class
	virtual AOMClass * getClass() const { return 0; }

	void registerInClass(AOMAnimationItem *);
	void deregisterFromClass(AOMAnimationItem *);
	void cserializeRelations(AOMSRelations&) const;
	void cserializeAttributes(AOMSAttributes&) const;
	void sendMyself(OMInterestMask theMask);

	void notifySynchronize() const { notifySynchronizeAttr(); }
	// Synchronize attribute values with proxy
	void notifySynchronizeAttr() const;

	void notifyItemAddedToRelation(const OMHandle* relation, 
								   AOMInstance * item,
								   bool isComposite, 
								   bool isSingleton);
	
	void notifyItemRemovedFromRelation(const OMHandle* relation,
									   AOMInstance *removedItem);
	
	void notifyClearRelation(const OMHandle* relation);

	void notifyTermination(const OMHandle * terminator) const
	{
		notifyStateMessage(terminationReached, terminator);
	}
	void notifyEnterToState(const OMHandle* state) const
	{
		notifyStateMessage(enteredState, state);
	}

	void notifyExitFromState(const OMHandle* state) const
	{
		notifyStateMessage(exitedState, state);
	}

	void notifyStartedTransition(const OMHandle* transition) const
	{
		notifyStateMessage(startedTransition, transition);
	}

	void notifyEndedTransition(const OMHandle* transition) const
	{
		notifyStateMessage(endedTransition, transition);
	}

	void setInstanceName(char *instName, int mult=-1) 
	{
		instanceNameIndex = mult;

		if (instanceName != 0)
			delete[] instanceName;

		if (instName != 0) {
			instanceName = new char[strlen(instName) + 1];
			strcpy(instanceName, instName);
			sendInstanceName();
		}
		else {
			instanceName = 0;
		}

	}

	static void setAOMInstanceName(AOMInstance *inst, char *instName, int mult=-1)
	{
		if (inst != 0) {
			inst->setInstanceName(instName, mult);
		}
	}

	virtual void* getMyReal() { return this; }
	virtual void handleMessage(OMNotify r, OMSData* s, OMSPosition& p);
	IOxfAnimReactive* getReactivePart() const { return theReactivePtr;}
	// previladged operation to set the reactive part
	// should be used with care
	void setReactivePart(IOxfAnimReactive* animR);

	virtual void handleMessage(AnimMessage *msg) { AOMAnimationItem::handleMessage(msg); }

protected:
	// Serialize methods
	void serialize(AOMSData& s, OMInterestMask theMask); // Serialize all
	void cserializeStates(AOMSState&) const;

	void notifyStateMessage(OMNotify what, const OMHandle* who) const;
	void createProxy();
	void registerInClass(AOMAnimationItem *, AOMClass*);
	virtual int getDefaultMask() const;

	char* instanceName;
	
	// an attribute indicating the index displayed,
	int instanceNameIndex;

	void sendInstanceName();

private:
	IOxfAnimReactive* theReactivePtr;

};



//
// $Log: aominst.h $
// Revision 1.47  2007/03/11 11:57:52  ilgiga
// Change copyright comment
// Revision 1.46  2007/03/01 16:31:24  ilgiga
// Telelogic instead of i-Logix
// Revision 1.45  2005/06/06 15:34:28  amos
// Revision 1.44.1.3  2005/06/06 12:32:22  amos
// remove redundant APIs that are no longer needed due to the introduction of the IOxfAnimHelper
// Revision 1.44.1.2  2005/05/31 16:24:48  amos
// AOMInstance:
// Add the deletion of the anim reactive proxy to the destructor
// Fix setReactivePart() in order to support setReactivePart(0)
// Revision 1.44.1.1  2005/04/21 10:03:22  amos
// Duplicate revision
// Revision 1.43.1.5  2005/03/16 14:02:32  amos
// Revision 1.43.1.4  2005/03/10 14:25:06  amos
// Implementing AnimServices
// Revision 1.43.1.3  2005/03/09 12:22:34  amos
// Initial support in decoupling of AOM from the OXF core implementation
// Revision 1.43.1.2  2005/03/03 14:06:22  amos
// Decouple the AOM event queue and the OXF thread event queue
// Revision 1.43.1.1  2004/09/08 13:02:39  amos
// Duplicate revision
// Revision 1.42.1.2  2004/09/07 14:17:43  amos
// Rename the framework interfaces and types to ensure unique names as well as updating all references.
// - IActive changed to IOxfActive
// - IReactive changed to IOxfReactive
// - IEvent changed to IOxfEvent
// - ITimeout changed to IOxfTimeout
// - IEventGenerationParams changed to IOxfEventGenerationParams
// - TimeUnit changed to OxfTimeUnit
// Revision 1.42.1.1  2004/06/27 15:43:04  amos
// Duplicate revision
// Revision 1.41.1.2  2004/02/04 13:52:08  amos
// Revision 1.41.1.1  2002/07/15 12:33:18  amos
// Duplicate revision
// Revision 1.40  2001/12/03 12:08:19  Eldad
// Support for instance names in animation.
// Revision 1.39.1.2  2001/11/29 07:25:44  Eldad
// Revision 1.39.1.1  2001/06/21 10:37:21  Eldad
// Duplicate revision
// Revision 1.38  2001/03/20 11:18:24  vova
// Back to main from 1.37.1.3
// Revision 1.37.1.3  2001/03/05 16:56:29  vova
// AOMInstance constructor body deleted and moved to .cpp
// Revision 1.37.1.2  2001/02/20 09:49:10  vova
// Partial Animation friend using scheme
// Revision 1.39  2001/02/15 09:38:54  vova
// Partial Animation friend using scheme
// Revision 1.38  2001/02/07 13:59:53  vova
// Revision 1.37  2001/01/28 14:54:09  vova
// Function name changed
// Revision 1.36  2001/01/25 09:35:49  vova
// Bug 41530 fixed: redundant getAOMInstPtr declaration deleted
// Revision 1.35  2001/01/10 16:25:30  vova
// Merge with Partial Animation additions
// Revision 1.34  2000/12/27 08:44:56  amos
// Add support for framework as DLL - for support in Rhapsody C++ COM
// Revision 1.33  1999/10/19 10:49:42  yachin
// By default instances report on operation (bug 32529)
// Revision 1.33.1.3  2001/01/03 16:36:03  vova
// getReactPart added
// Revision 1.33.1.2  2000/08/30 16:12:03  vova
// Partial Animation: Phases 1,2
// Revision 1.33.1.1  1999/10/19 10:49:42  vova
// Duplicate revision
// Revision 1.32  1999/02/16 06:08:01  yachin
// Speed up of construction during animation
// Revision 1.31  1998/08/02 15:02:03  beery
// changing boolean->bool
// Revision 1.30  1997/07/24 05:23:36  yachin
// Revision 1.29  1997/04/09 10:42:36  ofer
// remove class qualifier from class definition
// (the gnu 2.51 used to compile VxWorks warn about it)
// aomdisp.h
// aominst.h
// Revision 1.28  1997/04/06 11:36:52  yachin
// Assorted bug fixes
// Revision 1.27  1997/02/04 08:27:23  yachin
// Revision 1.26  1997/01/22 11:55:24  yachin
// Inverse composite relation bug fix
// Revision 1.25  1997/01/21 11:46:23  yachin
// instrumentation macros moved to aommacro.h
// Revision 1.24  1996/11/24 12:55:25  yachin
// Revision 1.23  1996/11/11 11:46:50  yachin
// Support multi-thread part I
// Revision 1.22  1996/11/10 07:50:59  yachin
// fixed gotControl breakpoint + breakPoint to dead objects
// Revision 1.21  1996/10/22 07:44:43  yachin
// omhandle changed to char * + derived changes
// Revision 1.20  1996/10/21 11:38:26  yachin
// Cleanup on state notifies + fixes on timeouts + support for breakpoints
// Revision 1.19  1996/10/09 07:33:58  yachin
// Revision 1.18  1996/09/29 12:41:49  yachin
// Send Relations together with "create proxy" message (fix relations bug
// Revision 1.17  1996/09/18 09:58:26  lusia
//  enter/exit notification for flat statechart implementation
// Revision 1.16  1996/09/02 13:40:43  yachin
// Preparations for connecting with call stack view and MSC
// Revision 1.15  1996/08/29 10:46:04  ofer
// Revision 1.14  1996/08/14 12:38:18  yachin
// Separate "updated" data from "show" data
// Revision 1.13  1996/08/12 12:34:40  yachin
// Seperated show from trace (possibly has bug if existence is canceled and then turned on).
// Revision 1.12  1996/08/08 08:22:16  yachin
// Prototype 4 major revision
// Revision 1.11  1996/08/06 12:49:52  yachin
// Tracer for Prototype 4
// Revision 1.10  1996/07/18 10:48:54  yachin
// Post Prototype 3 rewrite: virtual destructors, remarks, type changes and safe programing on deleted items
// Revision 1.9  1996/07/10 12:48:34  yachin
// Revision 1.8  1996/07/10 05:46:58  yachin
// Reorganization + some stuff for OMANIMATOR
// Revision 1.7  1996/07/03 12:44:38  yachin
// Fixing bugs for "const" and "static" functions
// Revision 1.6  1996/06/30 12:21:42  yachin
// Make OMBASE!!! virtual !!!!  AOMInstance
// Revision 1.5  1996/06/25 12:56:32  yachin
// Revision 1.4  1996/06/23 11:18:50  yachin
// Changes for integration with oxf
// Revision 1.3  1996/06/20 10:21:52  yachin
// Revision 1.2  1996/06/19 10:18:49  yachin
// Revision 1.1  1996/06/17 05:33:16  yachin
// Initial revision
//

#endif
