#ifndef aomeque_H
#define aomeque_H "$Id: aomeque.h 1.20 2007/03/11 11:57:51 ilgiga Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/aom/rcs/aomeque.h $
//	file version:	$Revision: 1.20 $
//
//	purpose:	AOMEventQueue class
//				merged with previously OMVernboseEventQueue
//
//	author(s):	  Yachin Pnueli
//	date started:	27.1.97 (split from aomothoer.h)
//	date changed:	$Date: 2007/03/11 11:57:51 $
//	last change by:	$Author: ilgiga $
//
//	(c) Copyright Telelogic 1995, 2007
//


#include "aomitem.h"
#include <oxf/omqueue.h>

class IOxfEvent;
class OMOSMutex;
class AOMEvent;
class AOMInstance;
class AOMThread;

//
//	AOMEventQueue	-	The "application" event queue
//	Also responsible for notifying sent/take events
//						
class  AOMEventQueue:public AOMAnimationItem
{
public:
	AOMEventQueue(AOMThread* owner);
	virtual ~AOMEventQueue();

    // handle queue events in the application queue
	void onEventGetBegin(bool add2q);
    void onEventGetEnd(const IOxfEvent* ev, bool add2q);
    void onEventPutBegin(const IOxfEvent* ev, bool blocking, bool add2q);
    void onEventPutEnd(const IOxfEvent* ev, bool add2q);

	// Services
	bool isEmpty() const
	{
		return queue.isEmpty();
	}

	void sendMyself(OMInterestMask theMask);

	// EventQueue notification methods
	void notifyEventSent(AOMEvent * event, 
						 AOMAnimationItem * const sender, 
						 AOMInstance * const receiver);

	void notifyEventReceived(AOMEvent * event, 
							 AOMAnimationItem * const sender, 
							 AOMInstance * const receiver);

	// Timeout notification methods
	void notifyTimeoutSet(AOMEvent * const event, 
						  AOMAnimationItem * const item);

	void notifyEventCancelled(AOMEvent * const event, 
							  AOMAnimationItem * const item);
	
	void notifyTimeoutCancelled(AOMEvent * const event, 
							  AOMAnimationItem * const item);

	// reset the queue state
	// used by the owner AOMThread on change of the actual thread
	void reset();

private:
	// notification helpers
	bool isMaskInteresting(AOMAnimationItem *const item, int mask) const;
	bool isMaskInteresting(AOMAnimationItem *const i1,
								AOMAnimationItem *const i2,
								int mask) const;

	bool isEventInteresting(AOMAnimationItem *const i1,
								AOMAnimationItem *const i2) const;
	bool withParameters(AOMAnimationItem *const i1,
								AOMAnimationItem *const i2) const;
	
	bool withParameters(AOMAnimationItem *const item) const;
	bool isTimeoutInteresting(AOMAnimationItem *const item) const;
	void notifyEventEvent(AOMEvent * event, 
						 AOMAnimationItem * const sender, 
						 AOMInstance * const receiver,
						 OMNotify what);
	
	virtual int getDefaultMask() const { return OMAllInterest; }

	// reset the owner thread wakeup token
	void resetWakeupToken() const;

	// set information required for onEventGetEnd()
	void setEventReceivedInfo(const IOxfEvent* ev,
							AOMEvent*& aomEv,
							AOMInstance*& receiver,
							OMString& eventName,
							bool& report) const;

	// Indicator that the put is expected to be blocking for a long duration
	bool blockingPut;
	// The owner thread
	AOMThread* theOwner;
	// The normal mutex of the queue
	OMOSMutex* queueMutex;
	// the shadow queue
	OMQueue<const IOxfEvent*> queue;
};

//
// $Log: aomeque.h $
// Revision 1.20  2007/03/11 11:57:51  ilgiga
// Change copyright comment
// Revision 1.19  2007/03/01 16:31:23  ilgiga
// Telelogic instead of i-Logix
// Revision 1.18  2005/09/15 07:29:25  vova
// AOM shadow queue will not be modified when timeouts expire (we need to simulate the enter to/exit from queue of the timeouts in order for the animation to display them properly).
// Revision 1.17  2005/05/15 14:18:34  amos
// AOMEventQueue: add a new public operation - void reset()
//   The operation reset the queue state
//   It is used by the owner AOMThread on change of the actual thread
// Revision 1.16  2005/04/21 10:03:19  amos
// Revision 1.15.1.5  2005/04/18 12:09:00  amos
// Revision 1.15.1.4  2005/04/11 12:57:59  amos
// Revision 1.15.1.3  2005/04/10 15:25:21  amos
// Revision 1.15.1.2  2005/03/03 14:06:22  amos
// Decouple the AOM event queue and the OXF thread event queue
// Revision 1.15.1.1  2004/09/08 13:02:38  amos
// Duplicate revision
// Revision 1.14.1.2  2004/09/07 14:17:42  amos
// Rename the framework interfaces and types to ensure unique names as well as updating all references.
// - IActive changed to IOxfActive
// - IReactive changed to IOxfReactive
// - IEvent changed to IOxfEvent
// - ITimeout changed to IOxfTimeout
// - IEventGenerationParams changed to IOxfEventGenerationParams
// - TimeUnit changed to OxfTimeUnit
// Revision 1.14.1.1  2004/06/27 15:43:02  amos
// Duplicate revision
// Revision 1.13.2.3  2004/04/25 07:58:32  amos
// rename put to putMessage using the new API
// Revision 1.13.2.2  2004/02/03 14:51:08  amos
// Revision 1.13.2.1  2003/05/26 10:52:58  amos
// Duplicate revision
// Revision 1.12  2003/05/19 14:17:51  vova
// Revision 1.11  2000/11/08 15:28:51  amos
// back to main branch
// Revision 1.10.1.2  2000/11/08 15:28:51  amos
// modify AOMEventQueue::put() to return a value
// Revision 1.10.1.1  1999/07/29 10:28:40  amos
// Duplicate revision
// Revision 1.9  1999/02/16 06:08:00  yachin
// Speed up of construction during animation
// Revision 1.8  1999/02/03 15:55:47  amos
// back to main branch
// Revision 1.7.1.2  1999/02/03 14:11:56  amos
// change in getEventList()
// Revision 1.7  1999/01/26 08:28:06  amos
// back to main brunch
// Revision 1.6.1.2  1999/01/19 12:18:22  amos
// support in setting the message queue size from OMTread constructor
// Revision 1.6.1.1  1998/08/02 15:04:02  amos
// Duplicate revision
// Revision 1.5  1998/05/21 12:33:58  yachin
// Notify Tom when events are canceled
// Revision 1.4  1997/04/15 03:40:04  yachin
// eventQueue no longer an OMAbstractContainer
// Revision 1.3  1997/02/03 06:31:28  yachin
// Revision 1.2  1997/01/28 10:54:42  yachin
// without low level signal
// Revision 1.1  1997/01/27 09:44:44  yachin
// Initial revision
//

#endif
