#ifndef aomee_H
#define aomee_H "$Id: aomee.h 1.35 2007/03/11 11:57:50 ilgiga Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/aom/rcs/aomee.h $
//	file version:	$Revision: 1.35 $
//
//	purpose:	AOMEnterExit class - used to detect the entering and exiting 
//									 into user methods
//				Also: Instrumentation macros for:
//				1. Classes (definitions + implementation)
//				2. method calls ("regular", constructors and destructors).
//
//	author(s):	  Yachin Pnueli
//	date started:	6.6.96
//	date changed:	$Date: 2007/03/11 11:57:50 $
//	last change by:	$Author: ilgiga $
//
//	(c) Copyright Telelogic 1995, 2007
//
#include "aoxf.h"
#include "aomdisp.h"
#include "aomcalls.h"
#include "aomthrd.h"

class RP_FRAMEWORK_DLL AOMEnterExit
{
public:
	AOMEnterExit(const AOMAnimationItem* const instance, 
				 AOMSMethod* method,
				 OMMethodType type,
				 bool destroyAOMInstance = false,
				 void* theUserClass = 0) :
		cs(0), needToDestroyAOMInstance(destroyAOMInstance),userClass(theUserClass)
	{
		if (instance != 0)
		{
			// A call from a non animated object
			if (method != 0)
			{
				cs = OMGetCurrentCallStack();
				cs->push(instance,method,type);
			}
		}
	}

	~AOMEnterExit()
	{ 
		if (cs != 0 && aomIsValidItem(cs))
		{
			cs->pop(); 
		}
		if (needToDestroyAOMInstance)
		{
			AOMSchedDispatcher::instance()->registerAOMInstance(userClass, 0);
		}
	}

private:
	AOMCallStack* cs;
	bool needToDestroyAOMInstance;
	void* userClass;
};


inline bool withCallStackParameters(const AOMAnimationItem* const me)
{
	return ((aomIsValidItem(me) && me->isInteresting(OMParameterInterest)) ||
		OMGetCurrentCallStack()->isInteresting(OMParameterInterest));
}


//
// $Log: aomee.h $
// Revision 1.35  2007/03/11 11:57:50  ilgiga
// Change copyright comment
// Revision 1.34  2007/03/01 16:31:23  ilgiga
// Telelogic instead of i-Logix
// Revision 1.33  2005/04/21 10:03:17  amos
// Revision 1.32.2.2  2005/03/16 14:02:30  amos
// Revision 1.32  2005/01/27 14:43:59  amos
// AOMEnterExit destructor: add check that the callstack is still valid
// Revision 1.31  2004/06/27 15:43:01  amos
// move to model-based oxf in RiC++
// Revision 1.30.1.2  2004/02/03 13:17:20  amos
// Revision 1.30.1.1  2002/01/08 13:35:46  amos
// Duplicate revision
// Revision 1.29  2001/01/10 16:15:19  vova
// Merge with Partial Animation additions
// Revision 1.28  2000/12/27 08:44:36  amos
// Add support for framework as DLL - for support in Rhapsody C++ COM
// Revision 1.27  1999/01/21 12:08:06  beery
// adjust to classes which were generated by Rhapsody but are part of the oxf itself and are not instrumented
// Revision 1.27.2.2  2000/09/06 11:54:07  vova
// Bug fixes in Partial Animation
// Revision 1.27.2.1  1999/01/21 12:08:06  vova
// Duplicate revision
// Revision 1.26.1.2  1999/01/17 08:23:45  beery
// Revision 1.26  1998/08/02 15:04:01  beery
// changing boolean->bool
// Revision 1.25  1997/09/16 11:21:21  yachin
// Fix bug #2782
// Revision 1.24  1997/04/06 11:36:51  yachin
// Assorted bug fixes
// Revision 1.23  1997/01/27 09:44:17  yachin
// Enter foreign threads
// Revision 1.22  1997/01/26 13:49:53  yachin
// ReWrite for Foreign Threads
// Revision 1.21  1997/01/21 11:46:21  yachin
// instrumentation macros moved to aommacro.h
// Revision 1.20  1997/01/21 10:54:06  yachin
// User Threads part I
// Revision 1.19  1997/01/14 13:52:01  yachin
// Revision 1.18  1996/12/30 09:55:25  yachin
// Multi Thread support part III
// Revision 1.17  1996/12/26 13:48:42  yachin
// Revision 1.16  1996/11/24 12:55:23  yachin
// Revision 1.15  1996/10/09 07:33:56  yachin
// Revision 1.14  1996/09/16 09:27:06  yachin
// Revision 1.13  1996/09/08 13:27:48  yachin
// Patch for trigger operation
// Revision 1.12  1996/09/08 11:25:06  yachin
// Fixed some prolem with cons tin const functions
// Revision 1.11  1996/09/04 13:13:34  yachin
// Connect to Israel
// Revision 1.10  1996/09/02 13:40:42  yachin
// Preparations for connecting with call stack view and MSC
// Revision 1.9  1996/08/28 05:35:22  ofer
// Revision 1.8  1996/08/08 08:22:14  yachin
// Prototype 4 major revision
// Revision 1.7  1996/07/18 10:48:53  yachin
// Post Prototype 3 rewrite: virtual destructors, remarks, type changes and safe programing on deleted items
// Revision 1.6  1996/07/03 12:44:37  yachin
// Fixing bugs for "const" and "static" functions
// Revision 1.5  1996/06/26 08:39:51  yachin
// Revision 1.4  1996/06/25 11:51:56  yachin
// Revision 1.3  1996/06/20 10:21:51  yachin
// Revision 1.2  1996/06/19 10:18:47  yachin
// Revision 1.1  1996/06/17 05:33:12  yachin
// Initial revision
//

#endif
