#ifndef aomdisp_H
#define aomdisp_H "$Id: aomdisp.h 1.40 2007/03/11 11:57:50 ilgiga Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/aom/rcs/aomdisp.h $
//	file version:	$Revision: 1.40 $
//
//	purpose:	The Animated Executable's dispatcher
//
//	author(s):	  Yachin Pnueli
//	date started:	30.5.96
//	date changed:	$Date: 2007/03/11 11:57:50 $
//	last change by:	$Author: ilgiga $
//
//	(c) Copyright Telelogic 1995, 2007
//
#include <oxf/omlist.h>
#include <oxf/ommap.h>
#include <oxf/omprotected.h>
#include <omcom/omnote.h>

//
//	AOMSchedDispatcher	-	The animated executable's dispatcher
//			(commuincates with tracer dispatcher and/or animation dispatcher)
// Some important notes:
//	1. AOMSchedDispatcher is implemented as a "classical" singleton
//	accessed only through a "instance()"method. This is needed
//	to ensure it exists before various pre-main static items
//	access it.
//	2. To actually connect with O-Mate we need destination
//	parameters (where is this O-Mate running). These we get
//	in "init(/*params*/).
//	Before init() messages are not sent. Instead they are stored
//	in a list.
//
class OMOSEventFlag;
class OMOSMutex;
class IOxfReactive;
class IOxfAnimReactive;

class OMSData;

class AOMSCreationMessage;
class AOMStepper;
class AOMAnimationItem;
class AOMInstance;
class AOMEvent;
class AOMPackage;

#ifdef OMANIMATOR
class OMOSConnectionPort;
class AOMMessageSender;
#endif

class AnimMessageTranslator;
class AnimClassData;
class AnimRegisterClasses;
class AnimMessage;


/* 
   Defining PROTECT_ACTIVE_AND_STOPPED_STEPPERS_LIST
   would result in protecting activeStepperList and 
   stoppedStepperList containers.
   This was done to fix bug 96777, 
   however, this may cause performance degragation.
   For now we do not protect this by default.
*/
//#define PROTECT_ACTIVE_AND_STOPPED_STEPPERS_LIST

class AOMSchedDispatcher
{
public:
	// To prevent spurious constructions
	AOMSchedDispatcher();
	// To disable copy constructor
	AOMSchedDispatcher(const AOMSchedDispatcher& ) { }

	~AOMSchedDispatcher();

	// Implementation of singleton
	static AOMSchedDispatcher * getInstance();
	RP_FRAMEWORK_DLL static AOMSchedDispatcher * instance();

	// API to manage user instance to AOMInstance association
	RP_FRAMEWORK_DLL void registerAOMInstance(const void* userClass, AOMInstance* itsAOMInstance);
	RP_FRAMEWORK_DLL AOMInstance* getAOMInstance(const void* userClass);
	
	// API to manage reactive instance to anim reactive association
	RP_FRAMEWORK_DLL void registerAnimReacive(const IOxfReactive* reactive, IOxfAnimReactive* animReactive);
	RP_FRAMEWORK_DLL IOxfAnimReactive* getAnimReactive(const IOxfReactive* reactive) const;

	// API to manage user event to AOEvent association
	RP_FRAMEWORK_DLL void registerAOMEvent(const void* userEvent, AOMEvent* itsAOMEvent);
	RP_FRAMEWORK_DLL AOMEvent* getAOMEvent(const void* userEvent);

	RP_FRAMEWORK_DLL void sendForeignMessage(OMString& payload, void* destOrSource = NULL);

	// send a notification a debugger break point is about to take place
	// (called from the debugger itself)
	static void notifyDebugBreakPoint(bool isRhapsodyBP);

	// Initialization routine
	void init(const char* host_name=0, unsigned int port_num=0);

	// Communication routines
	void closeConnection();
	void putMessage(OMSData*);  // O-mate to Application
	void notify(OMNotify n, AOMStepper* s = 0); // steppers to sched-disp

	void sendMessage(OMSData&); // Application to O-Mate

	///////////////////////////////////////////////////////////////////////////
	///////////////////////////////////////////////////////////////////////////
	///////////////////////////////////////////////////////////////////////////
		void sendMessage_safety(OMSData * m);
	///////////////////////////////////////////////////////////////////////////
	///////////////////////////////////////////////////////////////////////////
	///////////////////////////////////////////////////////////////////////////

	void sendProxyMessage(AOMAnimationItem*,OMSData&);
	void sendProxyMessage(AOMInstance*,OMSData&);
	void sendProxyMessage(AOMPackage*,OMSData&);

	void registerClass(AOMAnimationItem*, OMSData&);
	void registerClass(AOMAnimationItem *, AnimClassData& );

	bool isNotRegistered(AOMStepper* s);

	void setTerminating();
	bool isActive() const {
		return myState!=initializing && myState!=terminating;
	}
	static const int timeoutOnWaitForThreadsToStop;
	bool withDebugger() const;

	// encode "new style" messages, sends the encoded message and delete
	// the message.
	void encodeAndSendMessage(AnimMessage *msg);

private:

	// The  dispatcher singleton
	
	static AOMSchedDispatcher* _instance;

	// a translator used to convert OMSData to AnimMessage
	// instances, and vice versa.
	AnimMessageTranslator *animMessageTranslator;

	// The list of pre-initialize unsent messages
	// init only
	AOMSCreationMessage* classCreationMessage; 
	// instead of classCreationMessage
	AnimRegisterClasses* animRegisterClasses; 

	// + event classes
	// Currently init only
	OMList<AOMAnimationItem*> theClasses; 
	// List of pre-Main instances
	OMList<AOMInstance*> theInstances; 
	// List of packages
	OMList<AOMPackage*> thePackages; 
	// init only
	AOMSCreationMessage* instanceCreationMessage; 
	// map of user to animated instances
	OMMap <const void*,AOMInstance*> userClass2AOMInstance;
	// map from reactive instances to their animated proxys
	OMMap<const IOxfReactive*, IOxfAnimReactive*> reactive2AnimReactive;
	// map of animated events
	OMMap <const void*, AOMEvent*> userEvent2AOMEvent; 
	// initialization - list of messages that were created in pre-main
	// and should be send when the animation is initialized
	OMList<OMSData*> unhandledMessageList;
	OMList<AOMStepper*> activeStepperList;
	OMList<AOMStepper*> stoppedStepperList;

	// protecting the statechart
	OMOSMutex* statechartMutex;
	// protecting the userClass2AOMInstance map 
	OMProtected aomInstancesMapGuard;
	// protecting the reactive2AnimReactive map
	OMProtected aomAnimReactiveGuard;
	// protecting the userEvent2AOMEvent map
	OMProtected aomEventsMapGuard;	
	OMOSEventFlag* allStopped;

#ifdef PROTECT_ACTIVE_AND_STOPPED_STEPPERS_LIST	
	OMOSMutex* activeStepperListMutex;
	OMOSMutex* stoppedStepperListMutex;
#endif

	// the dispacher state
	enum schedulerStates
	{
		initializing,
		threadsWorking,
		threadsShouldStop,
		threadsStopped,
		terminating
	};
	schedulerStates myState;
	// additional state flagsS
	bool shouldWaitForUser;
	bool shouldNotifyUser;
	bool shouldWaitForMsgSender;
	bool withDbg;
	bool m_withTimeStamp;


#ifdef OMANIMATOR
	// Stuff to communicate with O-Mate
	static void portToMessageQueue(OMSData* m);
	OMOSConnectionPort* connPort ;
	// Signal for single thread wait at init.
	OMOSEventFlag* stopSignal; // init only

	// An active class for sending messages
	AOMMessageSender *messageSender;

#endif
#ifdef OMTRACER
	bool communicationToTOMEnabled; // Moke of the connection port
#endif

	AOMSchedDispatcher& operator = (const AOMSchedDispatcher& ) { return *this; }
	void schedullerTakeOneLessActive();

	void enterThreadsWorking(AOMStepper *);
	void enterThreadsShouldStop(AOMStepper* initiator);
	void enterThreadsStopped();

	void handleMessage(OMSData*);
	void simpleHandleMessage(OMSData*);

	void localWaitForProxy(AOMAnimationItem* i);

	// This method is never to be called.
	// It is simply present in order to inforce the
	// linker to link with the message classes.
	void dummy();

};



//
// $Log: aomdisp.h $
// Revision 1.40  2007/03/11 11:57:50  ilgiga
// Change copyright comment
// Revision 1.39  2007/03/01 16:31:23  ilgiga
// Telelogic instead of i-Logix
// Revision 1.38  2006/10/31 14:47:19  eldad
// Protected the steppers collections
// Revision 1.37  2006/09/27 11:46:43  eldad
// Foreign Message - dest parameter
// Revision 1.36  2005/04/21 10:03:17  amos
// Revision 1.35.1.2  2005/03/16 14:02:29  amos
// Revision 1.35  2003/05/08 10:04:26  Eldad
// Foreign Message
// Revision 1.34  2002/09/26 08:11:28  Eldad
// Supporting debug breakpoints notifications sent from the debugger to the animation.
// (Green Hills).
// Revision 1.33.2.3  2002/09/24 15:26:12  Eldad
// Added argument for isRhapsodyBreakpoint
// Revision 1.33.2.2  2002/09/24 12:40:58  Eldad
// Revision 1.33.2.1  2002/07/29 11:36:13  Eldad
// Duplicate revision
// Revision 1.32.1.1  2002/07/16 10:03:50  Eldad
// Duplicate revision
// Revision 1.31.1.2  2002/07/03 15:52:45  Eldad
// Sending Threads on a separate thread.
// Revision 1.31.1.1  2002/03/25 15:21:35  Eldad
// Duplicate revision
// Revision 1.30  2001/12/18 09:59:45  vova
// 51922: DLL export has been added for Animation service functions(getAOMEvent(), getAOMInstance() , etc)
// Revision 1.29  2001/07/29 15:49:38  sasha
// Correct return value of the return type of the method 
// bool withDebugger().
// Revision 1.28  2001/07/05 10:10:44  vova
// #46366: partial animation bug: uninitialized class instance attributes should be animated/traced
// Revision 1.27  2001/04/10 10:27:51  vova
// #42798 fixed for pSOS compiler
// Revision 1.26  2001/04/02 07:24:24  Eldad
// Merge 1.25 + 1.24.1.3
// Revision 1.25  2001/03/27 17:47:01  vova
// Bug #42798:compilation error
// Revision 1.24  2001/03/20 11:16:33  vova
// Back to main
// Revision 1.24.1.3  2001/04/02 07:21:51  Eldad
// AnimMessage handling
// Revision 1.24.1.2  2001/03/22 09:41:25  Eldad
// Backup
// Revision 1.24.1.1  2001/03/20 11:16:33  Eldad
// Duplicate revision
// Revision 1.23.1.3  2001/03/05 13:40:59  vova
// Constructor must be public, otherwise pSOS and VxWorks compilation fail.
// Revision 1.23.1.2  2001/02/20 09:42:16  vova
// Partial Animation: maps added for AOM objects. Copy constructor added.
// Revision 1.24  2001/02/15 09:44:09  vova
// Partial Animation: maps added for AOM objects. Copy constructor added.
// Revision 1.23  2000/01/31 09:43:04  amos
// back to main branch
// Revision 1.22.2.2  2000/01/30 07:53:50  amos
// add boolean member m_withTimeStamp to AOMDispatcher, if the member is true, the AOMDispatcher add the time stamp to the message.
// The initial value of m_withTimeStamp is false.
// The value of the attribute is set in AOMDispatcher::notify() by a message from TOM.
// Revision 1.22.2.1  1999/03/10 13:06:08  amos
// Duplicate revision
// Revision 1.21  1999/01/07 12:12:05  ofer
// using GLOBAL function StoppedDebuggerOrNotifyBreakpoint
// the debug mode is known by the method withDebugger()
// and private data member withDbg
// Revision 1.20  1998/09/09 13:17:24  ofer
// zombie bugfix
// Revision 1.19  1998/08/02 15:04:01  beery
// changing boolean->bool
// Revision 1.18  1997/08/11 11:15:46  yachin
// stop timer during "user's turn" in anim/trace
// Revision 1.17  1997/08/05 15:26:15  yachin
// Yet again
// Revision 1.16  1997/08/05 13:50:04  yachin
// bug fix on bug fix
// Revision 1.15  1997/07/20 11:41:03  yachin
// Adding globals to animation
// Revision 1.14  1997/06/05 14:28:24  ofer
// Using OSEndApplication instead of exit
// Added AOMSCHEDDISPATCHER::closeConnection method
// aomdisp.cpp/h
// Revision 1.13  1997/04/09 10:44:10  ofer
// remove class qualifier from class definition
// (the gnu 2.51 used to compile VxWorks warn about it)
// aomdisp.h
// aominst.h
// Revision 1.12  1997/01/21 10:54:06  yachin
// User Threads part I
// Revision 1.11  1997/01/19 07:39:05  yachin
// Rewrite of aomSchedDisp statechart
// Revision 1.10  1996/12/26 13:48:42  yachin
// Revision 1.9  1996/12/24 12:12:40  yachin
// Add parametrized hostName portId
// Revision 1.8  1996/11/24 12:55:22  yachin
// Revision 1.7  1996/10/09 07:33:56  yachin
// Revision 1.6  1996/09/24 07:11:41  yachin
// Single threaded AOM
// Revision 1.5  1996/09/01 11:29:25  yachin
// Revision 1.4  1996/08/28 05:35:22  ofer
// Revision 1.3  1996/07/18 10:48:53  yachin
// Post Prototype 3 rewrite: virtual destructors, remarks, type changes and safe programing on deleted items
// Revision 1.2  1996/06/19 10:18:47  yachin
// Revision 1.1  1996/06/17 05:33:12  yachin
// Initial revision
//

#endif
