#ifndef aomclass_H
#define aomclass_H "$Id: aomclass.h 1.30 2007/03/11 11:57:50 ilgiga Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/aom/rcs/aomclass.h $
//	file version:	$Revision: 1.30 $
//
//	purpose:	Class of all executable "class" items
//
//	author(s):	  Yachin Pnueli
//	date started:	2.6.96
//	date changed:	$Date: 2007/03/11 11:57:50 $
//	last change by:	$Author: ilgiga $
//
//	(c) Copyright Telelogic 1995, 2007
//
#include "aomitem.h"
#include <oxf/omlist.h>

class AOMInstance;
class AOMOperation;
class AOMSMethod;
//
//	AOMClass	-	The Classes of "classes"
//
class AOMClass :public AOMAnimationItem {
private:
	// These two are needed for faster serialization of aominstance* items
	// The first time they are"countUnknown" and then we actually count
	// the entries. The second time we already know the count. see aommsg.h
	// class AOMSList
	int attributeCount;
	int relationCount;
	// AOMClass * myContext;
	AOMClass ** superClasses;
	int superClassCount;
	OMList<AOMInstance *> instanceList;
	OMList<AOMOperation *> operationList;
	OMString className;

	void simpleInit(char const* clsName, 
					bool isSingleton, 
					const char* context,
					const int theSuperClassCount=0);
	void sendMyself(OMInterestMask theMask);
	virtual int getDefaultMask() const { return OMExistInterest; }
public:
	// Destructor
	RP_FRAMEWORK_DLL virtual ~AOMClass();

	// Constructors
	// Note "context" here is the naming scope of the class
	// its inheritance is determined by the "superClass" parameter

	// 1. the No base class constructor
	RP_FRAMEWORK_DLL AOMClass(const char * clsName, bool isSingleton, 
			 const char * context) {
		simpleInit(clsName, isSingleton, context);
	}

	// 2. Single Base class constructor
	RP_FRAMEWORK_DLL AOMClass(const char * clsName, 
			 AOMClass * theSuperClass,
			 bool isSingleton,
			 const char * context) {
		simpleInit(clsName, isSingleton, context, 1); // one super class
		// Set "super classes" to point to the single super class
		superClasses = (AOMClass **) theSuperClass;
	}

	// 3. Multi base class constructor
	RP_FRAMEWORK_DLL AOMClass(const char * clsName,
			 int theSuperClassCount,
			 AOMClass ** theSuperClasses,
			 bool isSingleton,
			 const char *context) {
		simpleInit(clsName, isSingleton, context, theSuperClassCount);
		// Set the "super classes" array
		superClasses = theSuperClasses;
	}

	// Other methods
	RP_FRAMEWORK_DLL void addItem(AOMInstance * , AOMAnimationItem *);
	RP_FRAMEWORK_DLL void removeItem(AOMInstance * , AOMAnimationItem *);

	// Methods dealing with superClasses
	RP_FRAMEWORK_DLL int getSuperClassCount() const { return superClassCount; }
	RP_FRAMEWORK_DLL AOMClass *getSuperClass(int i)const;
	// Methods dealing with the number of attributes/relations in a class
	RP_FRAMEWORK_DLL void setAttributeCount(int theCount) { attributeCount = theCount; }
	RP_FRAMEWORK_DLL void setRelationCount(int theCount)  { relationCount = theCount; }
	RP_FRAMEWORK_DLL int getAttributeCount() const { return attributeCount; }
	RP_FRAMEWORK_DLL int getRelationCount() const { return relationCount; }

	RP_FRAMEWORK_DLL void serializeSuperClasses(AOMSData& s) const;

	RP_FRAMEWORK_DLL void addOperation(AOMOperation *op);
	// register the operation in Rhapsody
	RP_FRAMEWORK_DLL void registerOperations();
	
	RP_FRAMEWORK_DLL OMString getClassName();

	// do not notify got and lost control
	virtual void notifyGotControl() const { }
	virtual void notifyLostControl() const { }
	
	/*
	 * methods not yet implemented
	AOXFInstance * createNewInstance(....
	*/
};


//
// $Log: aomclass.h $
// Revision 1.30  2007/03/11 11:57:50  ilgiga
// Change copyright comment
// Revision 1.29  2007/03/01 16:31:22  ilgiga
// Telelogic instead of i-Logix
// Revision 1.28  2006/08/31 13:16:58  eldad
// Fix crash when an attempt to break on got\lost control on AOMClass is made
// Revision 1.27  2005/04/21 10:03:15  amos
// Revision 1.26.1.2  2005/03/16 14:02:28  amos
// Revision 1.26  2002/08/20 15:59:20  vova
// 57137: The following warning message has been avoided:
// "Warning: className hides AOMClass::className"
// Revision 1.25  2002/07/31 15:53:50  Eldad
// Fix solaris adaptor warnings.
// Revision 1.24  2002/07/29 11:35:48  Eldad
// Anim Op Calls.
// Revision 1.23.1.1  2000/12/27 08:44:22  Eldad
// Duplicate revision
// Revision 1.22  1999/02/16 06:07:58  yachin
// Speed up of construction during animation
// Revision 1.21  1998/08/02 15:04:00  beery
// changing boolean->bool
// Revision 1.20  1997/02/11 10:00:02  yachin
// Changes for name-spaces
// 
// Revision 1.19  1997/01/21 11:46:20  yachin
// instrumentation macros moved to aommacro.h
// Revision 1.18  1996/11/24 12:55:21  yachin
// Revision 1.17  1996/11/10 07:50:59  yachin
// fixed gotControl breakpoint + breakPoint to dead objects
// Revision 1.16  1996/10/21 11:38:23  yachin
// Cleanup on state notifies + fixes on timeouts + support for breakpoints
// Revision 1.15  1996/10/09 07:33:55  yachin
// Revision 1.14  1996/09/04 13:13:34  yachin
// Connect to Israel
// Revision 1.13  1996/09/02 13:40:42  yachin
// Preparations for connecting with call stack view and MSC
// Revision 1.12  1996/08/29 10:46:02  ofer
// Revision 1.11  1996/08/15 08:40:45  yachin
// Revision 1.10  1996/08/12 12:34:39  yachin
// Seperated show from trace (possibly has bug if existence is canceled and then turned on).
// Revision 1.9  1996/08/08 08:22:13  yachin
// Prototype 4 major revision
// Revision 1.8  1996/08/06 12:49:50  yachin
// Tracer for Prototype 4
// Revision 1.7  1996/07/18 10:48:52  yachin
// Post Prototype 3 rewrite: virtual destructors, remarks, type changes and safe programing on deleted items
// Revision 1.6  1996/07/10 05:46:57  yachin
// Reorganization + some stuff for OMANIMATOR
// Revision 1.5  1996/07/03 12:44:36  yachin
// Fixing bugs for "const" and "static" functions
// Revision 1.4  1996/06/24 11:15:19  yachin
// OMANIMATOR version should work
// Revision 1.3  1996/06/20 10:21:50  yachin
// Revision 1.2  1996/06/19 10:18:45  yachin
// Revision 1.1  1996/06/17 05:33:09  yachin
// Initial revision
//

#endif
