////////////////////////////////////////////////////////////////////////////////////////////
//
//! file name : $Source: R:/StmOO/Master/cg/LangCpp/WebComponents/rcs/TemplatedAdapters.h $
//! file version : $Revision: 1.28 $
//
// Rhapsody : 7.1 
// Component : GeneralComponent 
// Configuration : Microsoft Debug
// Model Element : NonConstTemplatedAdapters
//
// purpose: Contains templates to refine the basic attribute adapters found in CppWebAdaptersPkg so that they connect to user-defined classes with C++ non-constant attributes accessors.
//
// 
//! date changed: $Date: 2007/04/04 10:08:17 $
//! last change by: $Author: ilgiga $
//
// (c) Copyright Telelogic 2000, 2007
//
// Note: This file was generated by Rhapsody
//
////////////////////////////////////////////////////////////////////////////////////////////
 


#ifndef TemplatedAdapters_H 

#define TemplatedAdapters_H 

#include <oxf/omtypes.h>
#include <oxf/os.h>
// dependency CppWebAdaptersPkg 
#include "CppWebAdaptersPkg.h"
// class ClassOperationWebAdapterTmpl 
#include "ClassOperationWebAdapter.h"
// class NonConstBoolAttrWebAdapterTmpl 
#include "IntAttrWebAdapter.h"
// class NonConstCharAttrWebAdapterTmpl 
#include "CharAttrWebAdapter.h"
// class NonConstDoubleAttrWebAdapterTmpl 
#include "DoubleAttrWebAdapter.h"
// class NonConstLongAttrWebAdapterTmpl 
#include "LongAttrWebAdapter.h"
// class NonConstOMStringAttrWebAdapterTmpl 
#include "CStrAttrWebAdapter.h"
// class NonConstUCharAttrWebAdapterTmpl 
#include "ULongAttrWebAdapter.h"
// class ClassWebAdapterTmpl 
#include "ClassWebAdapter.h"
// class EventReceptionWebAdapterTmpl 
#include "EventReceptionWebAdapter.h"

//----------------------------------------------------------------------------
// TemplatedAdapters.h                                                                  
//----------------------------------------------------------------------------

class BasicWebAdapter;
template <class  ParentClass> class BoolAttrWebAdapterTmpl;
template <class  ParentClass> class CharAttrWebAdapterTmpl;
template <class  ParentClass> class ClassOperationWebAdapterTmpl;
template <class  AdapteeClass> class ClassWebAdapterTmpl;
template <class  ParentClass> class ConstClassOperationWebAdapterTmpl;
template <class  ParentClass> class CStrAttrWebAdapterTmpl;
template <class  ParentClass> class DoubleAttrWebAdapterTmpl;
template <class  ParentClass, class  EventClass> class EventReceptionWebAdapterTmpl;
template <class  ParentClass> class IntAttrWebAdapterTmpl;
template <class  ParentClass> class LongAttrWebAdapterTmpl;
template <class  ParentClass> class NonConstBoolAttrWebAdapterTmpl;
template <class  ParentClass> class NonConstCharAttrWebAdapterTmpl;
template <class  ParentClass> class NonConstDoubleAttrWebAdapterTmpl;
template <class  ParentClass> class NonConstIntAttrWebAdapterTmpl;
template <class  ParentClass> class NonConstLongAttrWebAdapterTmpl;
template <class  ParentClass> class NonConstOMBooleanAttrWebAdapterTmpl;
template <class  ParentClass> class NonConstOMStringAttrWebAdapterTmpl;
template <class  ParentClass> class NonConstShortAttrWebAdapterTmpl;
template <class  ParentClass> class NonConstUCharAttrWebAdapterTmpl;
template <class  ParentClass> class NonConstUIntAttrWebAdapterTmpl;
template <class  ParentClass> class NonConstULongAttrWebAdapterTmpl;
template <class  ParentClass> class NonConstUShortAttrWebAdapterTmpl;
template <class  ParentClass> class OMBooleanAttrWebAdapterTmpl;
template <class  ParentClass> class OMStringAttrWebAdapterTmpl;
template <class  ParentClass> class ShortAttrWebAdapterTmpl;
template <class  ParentClass> class UCharAttrWebAdapterTmpl;
template <class  ParentClass> class UIntAttrWebAdapterTmpl;
template <class  ParentClass> class ULongAttrWebAdapterTmpl;
template <class  ParentClass> class UShortAttrWebAdapterTmpl;

//## package NonConstTemplatedAdapters 


// Contains templates to refine the basic attribute adapters found in CppWebAdaptersPkg so that they connect to user-defined classes with C++ non-constant attributes accessors.


//## package NonConstTemplatedAdapters 


//## class ClassOperationWebAdapterTmpl 
template <class ParentClass> class ClassOperationWebAdapterTmpl : public ClassOperationWebAdapter {
protected :
    typedef void (ParentClass::*no_arg_operation)();
    
    


////    Constructors and destructors    ////
public :
    
    //## operation ClassOperationWebAdapterTmpl(ParentClass *,const char *,omtypename no_arg_operation) 
    ClassOperationWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename no_arg_operation anOperation);


////    Operations    ////
public :
    
    //## operation GetPermissions() const 
    virtual int GetPermissions() const;
    
    //## operation Send() 
    virtual void Send();


////    Attributes    ////
protected :
    
    // A pointer to the user-defined no-arg operation.
    no_arg_operation theOperation;		//## attribute theOperation 
    

};
//## class ClassOperationWebAdapterTmpl 



template <class ParentClass> ClassOperationWebAdapterTmpl<ParentClass> ::ClassOperationWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename no_arg_operation anOperation) : ClassOperationWebAdapter(
theParent,
name),
theOperation(anOperation) {
    //#[ operation ClassOperationWebAdapterTmpl(ParentClass *,const char *,omtypename no_arg_operation) 
    //#]
}

template <class ParentClass> int ClassOperationWebAdapterTmpl<ParentClass> ::GetPermissions() const {
    //#[ operation GetPermissions() const 
    int permissions = 0;
    if (theOperation)
        permissions |= WRITE_PERMISSION;
    return permissions;
    //#]
}

template <class ParentClass> void ClassOperationWebAdapterTmpl<ParentClass> ::Send() {
    //#[ operation Send() 
    ParentClass * pAdapteeParent = (ParentClass *)(adapteeParent);
    void (ParentClass::*pUserDefineOperation)() = theOperation;
    if (theOperation) // for safety
        (pAdapteeParent->*pUserDefineOperation)();
    //#]
}

//## package NonConstTemplatedAdapters 


//## class NonConstBoolAttrWebAdapterTmpl 
template <class ParentClass> class NonConstBoolAttrWebAdapterTmpl : public IntAttrWebAdapter {
protected :
    typedef bool (ParentClass::*getter)();
    
    typedef void (ParentClass::*setter)(bool);
    
    


////    Constructors and destructors    ////
public :
    
    //## operation NonConstBoolAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    NonConstBoolAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod);


////    Operations    ////
public :
    
    //## operation GetPermissions() const 
    virtual int GetPermissions() const;
    
    //## operation GetValue() 
    virtual int GetValue();
    
    //## operation Register() 
    virtual void Register();
    
    //## operation SetValue(int) 
    virtual void SetValue(int val);


////    Attributes    ////
protected :
    
    getter adapteeGetMethod;		//## attribute adapteeGetMethod 
    
    setter adapteeSetMethod;		//## attribute adapteeSetMethod 
    

};
//## class NonConstBoolAttrWebAdapterTmpl 



template <class ParentClass> NonConstBoolAttrWebAdapterTmpl<ParentClass> ::NonConstBoolAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod) : IntAttrWebAdapter(
(void*)theParent,
name),
adapteeGetMethod(getMethod),
adapteeSetMethod(setMethod) {
    //#[ operation NonConstBoolAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    //#]
}

template <class ParentClass> int NonConstBoolAttrWebAdapterTmpl<ParentClass> ::GetPermissions() const {
    //#[ operation GetPermissions() const 
    int permissions = 0;
    if (adapteeGetMethod)
        permissions |= READ_PERMISSION;
    if (adapteeSetMethod)
        permissions |= WRITE_PERMISSION;
    return permissions;
     
    //#]
}

template <class ParentClass> int NonConstBoolAttrWebAdapterTmpl<ParentClass> ::GetValue() {
    //#[ operation GetValue() 
    ParentClass * theAdapteeParent = (ParentClass *)(adapteeParent);
    bool (ParentClass::*getMethod)() = adapteeGetMethod;
    if (getMethod == (getter) NULL) // for safety
        return INT_MAX;
    bool value = (theAdapteeParent->*adapteeGetMethod)();
    return (value == true) ? 1 : 0;
    
    //#]
}

template <class ParentClass> void NonConstBoolAttrWebAdapterTmpl<ParentClass> ::Register() {
    //#[ operation Register() 
    if (!isRegistered)
    {
        id = C_RegisterWebBool(name, this);
        isRegistered = true;
    }
    
    //#]
}

template <class ParentClass> void NonConstBoolAttrWebAdapterTmpl<ParentClass> ::SetValue(int val) {
    //#[ operation SetValue(int) 
    ParentClass * theAdapteeParent = (ParentClass *)(adapteeParent);
    void (ParentClass::*setMethod)(bool) = adapteeSetMethod;
    if (setMethod) { // for safety
        bool boolVal = (val != 0) ? true : false;
        (theAdapteeParent ->*setMethod)(boolVal);
    }
    //#]
}

//## package NonConstTemplatedAdapters 


//## class NonConstCharAttrWebAdapterTmpl 
template <class ParentClass> class NonConstCharAttrWebAdapterTmpl : public CharAttrWebAdapter {
protected :
    typedef char (ParentClass::*getter)();
    
    typedef void (ParentClass::*setter)(char);
    
    


////    Constructors and destructors    ////
public :
    
    //## operation NonConstCharAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    NonConstCharAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod);


////    Operations    ////
public :
    
    //## operation GetPermissions() const 
    virtual int GetPermissions() const;
    
    //## operation GetValue() 
    virtual char GetValue();
    
    //## operation SetValue(char) 
    virtual void SetValue(char val);


////    Attributes    ////
protected :
    
    getter adapteeGetMethod;		//## attribute adapteeGetMethod 
    
    setter adapteeSetMethod;		//## attribute adapteeSetMethod 
    

};
//## class NonConstCharAttrWebAdapterTmpl 



template <class ParentClass> NonConstCharAttrWebAdapterTmpl<ParentClass> ::NonConstCharAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod) : CharAttrWebAdapter(
(void*)theParent,
name),
adapteeGetMethod(getMethod),
adapteeSetMethod(setMethod) {
    //#[ operation NonConstCharAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    //#]
}

template <class ParentClass> int NonConstCharAttrWebAdapterTmpl<ParentClass> ::GetPermissions() const {
    //#[ operation GetPermissions() const 
    int permissions = 0;
    if (adapteeGetMethod)
        permissions |= READ_PERMISSION;
    if (adapteeSetMethod)
        permissions |= WRITE_PERMISSION;
    return permissions;
    
    //#]
}

template <class ParentClass> char NonConstCharAttrWebAdapterTmpl<ParentClass> ::GetValue() {
    //#[ operation GetValue() 
    ParentClass * theAdapteeParent = (ParentClass *)(adapteeParent);
    char (ParentClass::*getMethod)() = adapteeGetMethod;
    if (getMethod == (getter) NULL) // for safety
        return CHAR_MAX;
    return (theAdapteeParent->*adapteeGetMethod)();
    
    //#]
}

template <class ParentClass> void NonConstCharAttrWebAdapterTmpl<ParentClass> ::SetValue(char val) {
    //#[ operation SetValue(char) 
    ParentClass * theAdapteeParent = (ParentClass *)(adapteeParent);
    void (ParentClass::*setMethod)(char) = adapteeSetMethod;
    if (setMethod) { // for safety
        (theAdapteeParent ->*setMethod)(val);
    }
    //#]
}

//## package NonConstTemplatedAdapters 


//## class NonConstDoubleAttrWebAdapterTmpl 
template <class ParentClass> class NonConstDoubleAttrWebAdapterTmpl : public DoubleAttrWebAdapter {
protected :
    typedef double (ParentClass::*getter)();
    
    typedef void (ParentClass::*setter)(double);
    
    


////    Constructors and destructors    ////
public :
    
    //## operation NonConstDoubleAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    NonConstDoubleAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod);


////    Operations    ////
public :
    
    //## operation GetPermissions() const 
    virtual int GetPermissions() const;
    
    //## operation GetValue() 
    virtual double GetValue();
    
    //## operation SetValue(double) 
    virtual void SetValue(double val);


////    Attributes    ////
protected :
    
    getter adapteeGetMethod;		//## attribute adapteeGetMethod 
    
    setter adapteeSetMethod;		//## attribute adapteeSetMethod 
    

};
//## class NonConstDoubleAttrWebAdapterTmpl 



template <class ParentClass> NonConstDoubleAttrWebAdapterTmpl<ParentClass> ::NonConstDoubleAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod) : DoubleAttrWebAdapter(
(void*)theParent,
name),
adapteeGetMethod(getMethod),
adapteeSetMethod(setMethod)
 {
    //#[ operation NonConstDoubleAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    //#]
}

template <class ParentClass> int NonConstDoubleAttrWebAdapterTmpl<ParentClass> ::GetPermissions() const {
    //#[ operation GetPermissions() const 
    int permissions = 0;
    if (adapteeGetMethod)
        permissions |= READ_PERMISSION;
    if (adapteeSetMethod)
        permissions |= WRITE_PERMISSION;
    return permissions;
    //#]
}

template <class ParentClass> double NonConstDoubleAttrWebAdapterTmpl<ParentClass> ::GetValue() {
    //#[ operation GetValue() 
    ParentClass * theAdapteeParent = (ParentClass *)(adapteeParent);
    double (ParentClass::*getMethod)() = adapteeGetMethod;
    if (getMethod == (getter) NULL) // for safety
        return DBL_MAX;
    return (theAdapteeParent->*adapteeGetMethod)();
    
    //#]
}

template <class ParentClass> void NonConstDoubleAttrWebAdapterTmpl<ParentClass> ::SetValue(double val) {
    //#[ operation SetValue(double) 
    ParentClass * theAdapteeParent = (ParentClass *)(adapteeParent);
    void (ParentClass::*setMethod)(double) = adapteeSetMethod;
    if (setMethod) // for safety
        (theAdapteeParent->*setMethod)(val);
    //#]
}

//## package NonConstTemplatedAdapters 


//## class NonConstIntAttrWebAdapterTmpl 
template <class ParentClass> class NonConstIntAttrWebAdapterTmpl : public IntAttrWebAdapter {
protected :
    typedef int (ParentClass::*getter)();
    
    typedef void (ParentClass::*setter)(int);
    
    


////    Constructors and destructors    ////
public :
    
    //## operation NonConstIntAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    NonConstIntAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod);


////    Operations    ////
public :
    
    //## operation GetPermissions() const 
    virtual int GetPermissions() const;
    
    //## operation GetValue() 
    virtual int GetValue();
    
    //## operation SetValue(int) 
    virtual void SetValue(int val);


////    Attributes    ////
protected :
    
    getter adapteeGetMethod;		//## attribute adapteeGetMethod 
    
    setter adapteeSetMethod;		//## attribute adapteeSetMethod 
    

};
//## class NonConstIntAttrWebAdapterTmpl 



template <class ParentClass> NonConstIntAttrWebAdapterTmpl<ParentClass> ::NonConstIntAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod) : IntAttrWebAdapter(
(void*)theParent,
name),
adapteeGetMethod(getMethod),
adapteeSetMethod(setMethod) {
    //#[ operation NonConstIntAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    //#]
}

template <class ParentClass> int NonConstIntAttrWebAdapterTmpl<ParentClass> ::GetPermissions() const {
    //#[ operation GetPermissions() const 
    int permissions = 0;
    if (adapteeGetMethod)
        permissions |= READ_PERMISSION;
    if (adapteeSetMethod)
        permissions |= WRITE_PERMISSION;
    return permissions;
    //#]
}

template <class ParentClass> int NonConstIntAttrWebAdapterTmpl<ParentClass> ::GetValue() {
    //#[ operation GetValue() 
    ParentClass * theAdapteeParent = (ParentClass *)(adapteeParent);
    int (ParentClass::*getMethod)() = adapteeGetMethod;
    if (getMethod == (getter) NULL) // for safety
        return INT_MAX;
    return (theAdapteeParent->*adapteeGetMethod)();
    
    //#]
}

template <class ParentClass> void NonConstIntAttrWebAdapterTmpl<ParentClass> ::SetValue(int val) {
    //#[ operation SetValue(int) 
    ParentClass * theAdapteeParent = (ParentClass *)(adapteeParent);
    void (ParentClass::*setMethod)(int) = adapteeSetMethod;
    if (setMethod) // for safety
        (theAdapteeParent ->*setMethod)(val);
    //#]
}

//## package NonConstTemplatedAdapters 


//## class NonConstLongAttrWebAdapterTmpl 
template <class ParentClass> class NonConstLongAttrWebAdapterTmpl : public LongAttrWebAdapter {
protected :
    typedef long (ParentClass::*getter)();
    
    typedef void (ParentClass::*setter)(long);
    
    


////    Constructors and destructors    ////
public :
    
    //## operation NonConstLongAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    NonConstLongAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod);


////    Operations    ////
public :
    
    //## operation GetPermissions() const 
    virtual int GetPermissions() const;
    
    //## operation GetValue() 
    virtual long GetValue();
    
    //## operation SetValue(long) 
    virtual void SetValue(long val);


////    Attributes    ////
protected :
    
    getter adapteeGetMethod;		//## attribute adapteeGetMethod 
    
    setter adapteeSetMethod;		//## attribute adapteeSetMethod 
    

};
//## class NonConstLongAttrWebAdapterTmpl 



template <class ParentClass> NonConstLongAttrWebAdapterTmpl<ParentClass> ::NonConstLongAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod) : LongAttrWebAdapter(
(void*)theParent,
name),
adapteeGetMethod(getMethod),
adapteeSetMethod(setMethod) {
    //#[ operation NonConstLongAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    //#]
}

template <class ParentClass> int NonConstLongAttrWebAdapterTmpl<ParentClass> ::GetPermissions() const {
    //#[ operation GetPermissions() const 
    int permissions = 0;
    if (adapteeGetMethod)
        permissions |= READ_PERMISSION;
    if (adapteeSetMethod)
        permissions |= WRITE_PERMISSION;
    return permissions;
    //#]
}

template <class ParentClass> long NonConstLongAttrWebAdapterTmpl<ParentClass> ::GetValue() {
    //#[ operation GetValue() 
    ParentClass * theAdapteeParent = (ParentClass *)(adapteeParent);
    long (ParentClass::*getMethod)() = adapteeGetMethod;
    if (getMethod == (getter) NULL) // for safety
        return LONG_MAX;
    return (theAdapteeParent->*adapteeGetMethod)();
    
    //#]
}

template <class ParentClass> void NonConstLongAttrWebAdapterTmpl<ParentClass> ::SetValue(long val) {
    //#[ operation SetValue(long) 
    ParentClass * theAdapteeParent = (ParentClass *)(adapteeParent);
    void (ParentClass::*setMethod)(long) = adapteeSetMethod;
    if (setMethod) // for safety
        (theAdapteeParent ->*setMethod)(val);
    //#]
}

//## package NonConstTemplatedAdapters 


//## class NonConstOMBooleanAttrWebAdapterTmpl 
template <class ParentClass> class NonConstOMBooleanAttrWebAdapterTmpl : public IntAttrWebAdapter {
protected :
    typedef OMBoolean (ParentClass::*getter)();
    
    typedef void (ParentClass::*setter)(OMBoolean);
    
    


////    Constructors and destructors    ////
public :
    
    //## operation NonConstOMBooleanAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    NonConstOMBooleanAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod);


////    Operations    ////
public :
    
    //## operation GetPermissions() const 
    virtual int GetPermissions() const;
    
    //## operation GetValue() 
    virtual int GetValue();
    
    //## operation Register() 
    virtual void Register();
    
    //## operation SetValue(int) 
    virtual void SetValue(int val);


////    Attributes    ////
protected :
    
    getter adapteeGetMethod;		//## attribute adapteeGetMethod 
    
    setter adapteeSetMethod;		//## attribute adapteeSetMethod 
    

};
//## class NonConstOMBooleanAttrWebAdapterTmpl 



template <class ParentClass> NonConstOMBooleanAttrWebAdapterTmpl<ParentClass> ::NonConstOMBooleanAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod) : IntAttrWebAdapter(
(void*)theParent,
name),
adapteeGetMethod(getMethod),
adapteeSetMethod(setMethod) {
    //#[ operation NonConstOMBooleanAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    //#]
}

template <class ParentClass> int NonConstOMBooleanAttrWebAdapterTmpl<ParentClass> ::GetPermissions() const {
    //#[ operation GetPermissions() const 
    int permissions = 0;
    if (adapteeGetMethod)
        permissions |= READ_PERMISSION;
    if (adapteeSetMethod)
        permissions |= WRITE_PERMISSION;
    return permissions;
    //#]
}

template <class ParentClass> int NonConstOMBooleanAttrWebAdapterTmpl<ParentClass> ::GetValue() {
    //#[ operation GetValue() 
    ParentClass * theAdapteeParent = (ParentClass *)(adapteeParent);
    OMBoolean (ParentClass::*getMethod)() = adapteeGetMethod;
    if (getMethod == (getter) NULL) // for safety
        return INT_MAX;
    OMBoolean value = (theAdapteeParent->*adapteeGetMethod)();
    return (value == TRUE) ? 1 : 0;
    
    //#]
}

template <class ParentClass> void NonConstOMBooleanAttrWebAdapterTmpl<ParentClass> ::Register() {
    //#[ operation Register() 
    if (!isRegistered) {
        id = C_RegisterWebBool(name, this);
        isRegistered = true;
    }
    
    //#]
}

template <class ParentClass> void NonConstOMBooleanAttrWebAdapterTmpl<ParentClass> ::SetValue(int val) {
    //#[ operation SetValue(int) 
    ParentClass * theAdapteeParent = (ParentClass *)(adapteeParent);
    void (ParentClass::*setMethod)(OMBoolean) = adapteeSetMethod;
    if (setMethod) { // for safety 
        OMBoolean boolVal = (val != 0) ? TRUE : FALSE;
        (theAdapteeParent ->*setMethod)(boolVal);
    }
    //#]
}

//## package NonConstTemplatedAdapters 


//## class NonConstOMStringAttrWebAdapterTmpl 
template <class ParentClass> class NonConstOMStringAttrWebAdapterTmpl : public CStrAttrWebAdapter {
protected :
    typedef OMString (ParentClass::*getter)();
    
    typedef void (ParentClass::*setter)(OMString);
    
    


////    Constructors and destructors    ////
public :
    
    //## operation NonConstOMStringAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    NonConstOMStringAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod);


////    Operations    ////
public :
    
    //## operation GetPermissions() const 
    virtual int GetPermissions() const;
    
    //## operation GetValue() 
    virtual char* GetValue();
    
    //## operation SetValue(char*) 
    virtual void SetValue(char* val);


////    Additional operations    ////
protected :
    
    OMString getLocalString() const;
    
    void setLocalString(OMString p_localString);


////    Attributes    ////
protected :
    
    getter adapteeGetMethod;		//## attribute adapteeGetMethod 
    
    setter adapteeSetMethod;		//## attribute adapteeSetMethod 
    
    OMString localString;		//## attribute localString 
    

};
//## class NonConstOMStringAttrWebAdapterTmpl 



template <class ParentClass> NonConstOMStringAttrWebAdapterTmpl<ParentClass> ::NonConstOMStringAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod) : CStrAttrWebAdapter(
(void*)theParent,
name),
adapteeGetMethod(getMethod),
adapteeSetMethod(setMethod) {
    //#[ operation NonConstOMStringAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    //#]
}

template <class ParentClass> int NonConstOMStringAttrWebAdapterTmpl<ParentClass> ::GetPermissions() const {
    //#[ operation GetPermissions() const 
    int permissions = 0;
    if (adapteeGetMethod)
        permissions |= READ_PERMISSION;
    if (adapteeSetMethod)
        permissions |= WRITE_PERMISSION;
    return permissions;
    //#]
}

template <class ParentClass> char* NonConstOMStringAttrWebAdapterTmpl<ParentClass> ::GetValue() {
    //#[ operation GetValue() 
    ParentClass * theAdapteeParent = (ParentClass *)(adapteeParent);
    OMString (ParentClass::*getMethod)() = adapteeGetMethod;
    if (getMethod == (getter) NULL) // for safety
        return NULL;
    localString = (theAdapteeParent ->*adapteeGetMethod)();
    return localString.GetBuffer(0);
    
    //#]
}

template <class ParentClass> void NonConstOMStringAttrWebAdapterTmpl<ParentClass> ::SetValue(char* val) {
    //#[ operation SetValue(char*) 
    ParentClass * theAdapteeParent= (ParentClass *)(adapteeParent);
    void (ParentClass::*setMethod)(OMString) = adapteeSetMethod;
    if (setMethod) { // for safety 
        OMString str = val;
        (theAdapteeParent->*setMethod)(str);
        free(val); val = NULL; // WebServices allocated the string using malloc
    }
    //#]
}

template <class ParentClass> OMString NonConstOMStringAttrWebAdapterTmpl<ParentClass> ::getLocalString() const {
    return localString;
}

template <class ParentClass> void NonConstOMStringAttrWebAdapterTmpl<ParentClass> ::setLocalString(OMString p_localString) {
    localString = p_localString;
}

//## package NonConstTemplatedAdapters 


//## class NonConstShortAttrWebAdapterTmpl 
template <class ParentClass> class NonConstShortAttrWebAdapterTmpl : public LongAttrWebAdapter {
protected :
    typedef short (ParentClass::*getter)();
    
    typedef void (ParentClass::*setter)(short);
    
    


////    Constructors and destructors    ////
public :
    
    //## operation NonConstShortAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    NonConstShortAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod);


////    Operations    ////
public :
    
    //## operation GetPermissions() const 
    virtual int GetPermissions() const;
    
    //## operation GetValue() 
    virtual long GetValue();
    
    //## operation SetValue(long) 
    virtual void SetValue(long val);


////    Attributes    ////
protected :
    
    getter adapteeGetMethod;		//## attribute adapteeGetMethod 
    
    setter adapteeSetMethod;		//## attribute adapteeSetMethod 
    

};
//## class NonConstShortAttrWebAdapterTmpl 



template <class ParentClass> NonConstShortAttrWebAdapterTmpl<ParentClass> ::NonConstShortAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod) : LongAttrWebAdapter(
(void*)theParent,
name),
adapteeGetMethod(getMethod),
adapteeSetMethod(setMethod) {
    //#[ operation NonConstShortAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    //#]
}

template <class ParentClass> int NonConstShortAttrWebAdapterTmpl<ParentClass> ::GetPermissions() const {
    //#[ operation GetPermissions() const 
    int permissions = 0;
    if (adapteeGetMethod)
        permissions |= READ_PERMISSION;
    if (adapteeSetMethod)
        permissions |= WRITE_PERMISSION;
    return permissions;
    //#]
}

template <class ParentClass> long NonConstShortAttrWebAdapterTmpl<ParentClass> ::GetValue() {
    //#[ operation GetValue() 
    ParentClass * theAdapteeParent = (ParentClass *)(adapteeParent);
    short (ParentClass::*getMethod)() = adapteeGetMethod;
    if (getMethod == (getter) NULL) // for safety
        return LONG_MAX;
    return (long) (theAdapteeParent->*adapteeGetMethod)();
    
    //#]
}

template <class ParentClass> void NonConstShortAttrWebAdapterTmpl<ParentClass> ::SetValue(long val) {
    //#[ operation SetValue(long) 
    ParentClass * theAdapteeParent = (ParentClass *)(adapteeParent);
    void (ParentClass::*setMethod)(short) = adapteeSetMethod;
    if (setMethod) // for safety
        (theAdapteeParent ->*setMethod)((short) val);
    //#]
}

//## package NonConstTemplatedAdapters 


//## class NonConstUCharAttrWebAdapterTmpl 
template <class ParentClass> class NonConstUCharAttrWebAdapterTmpl : public ULongAttrWebAdapter {
protected :
    typedef unsigned char (ParentClass::*getter)();
    
    typedef void (ParentClass::*setter)(unsigned char);
    
    


////    Constructors and destructors    ////
public :
    
    //## operation NonConstUCharAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    NonConstUCharAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod);


////    Operations    ////
public :
    
    //## operation GetPermissions() const 
    virtual int GetPermissions() const;
    
    //## operation GetValue() 
    virtual unsigned long GetValue();
    
    //## operation SetValue(unsigned long) 
    virtual void SetValue(unsigned long val);


////    Attributes    ////
protected :
    
    getter adapteeGetMethod;		//## attribute adapteeGetMethod 
    
    setter adapteeSetMethod;		//## attribute adapteeSetMethod 
    

};
//## class NonConstUCharAttrWebAdapterTmpl 



template <class ParentClass> NonConstUCharAttrWebAdapterTmpl<ParentClass> ::NonConstUCharAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod) : ULongAttrWebAdapter(
(void*)theParent,
name),
adapteeGetMethod(getMethod),
adapteeSetMethod(setMethod) {
    //#[ operation NonConstUCharAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    //#]
}

template <class ParentClass> int NonConstUCharAttrWebAdapterTmpl<ParentClass> ::GetPermissions() const {
    //#[ operation GetPermissions() const 
    int permissions = 0;
    if (adapteeGetMethod)
        permissions |= READ_PERMISSION;
    if (adapteeSetMethod)
        permissions |= WRITE_PERMISSION;
    return permissions;
    
    //#]
}

template <class ParentClass> unsigned long NonConstUCharAttrWebAdapterTmpl<ParentClass> ::GetValue() {
    //#[ operation GetValue() 
    ParentClass * theAdapteeParent = (ParentClass *)(adapteeParent);
    unsigned char (ParentClass::*getMethod)() = adapteeGetMethod;
    if (getMethod == (getter) NULL) // for safety
        return (unsigned long) UCHAR_MAX;
    return (unsigned long) (theAdapteeParent->*adapteeGetMethod)();
    
    //#]
}

template <class ParentClass> void NonConstUCharAttrWebAdapterTmpl<ParentClass> ::SetValue(unsigned long val) {
    //#[ operation SetValue(unsigned long) 
    ParentClass * theAdapteeParent = (ParentClass *)(adapteeParent);
    void (ParentClass::*setMethod)(unsigned char) = adapteeSetMethod;
    if (setMethod) // for safety
        (theAdapteeParent ->*setMethod)((unsigned char) val);
    //#]
}

//## package NonConstTemplatedAdapters 


//## class NonConstUIntAttrWebAdapterTmpl 
template <class ParentClass> class NonConstUIntAttrWebAdapterTmpl : public ULongAttrWebAdapter {
protected :
    typedef unsigned int (ParentClass::*getter)();
    
    typedef void (ParentClass::*setter)(unsigned int);
    
    


////    Constructors and destructors    ////
public :
    
    //## operation NonConstUIntAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    NonConstUIntAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod);


////    Operations    ////
public :
    
    //## operation GetPermissions() const 
    virtual int GetPermissions() const;
    
    //## operation GetValue() 
    virtual unsigned long GetValue();
    
    //## operation SetValue(unsigned long) 
    virtual void SetValue(unsigned long val);


////    Attributes    ////
protected :
    
    getter adapteeGetMethod;		//## attribute adapteeGetMethod 
    
    setter adapteeSetMethod;		//## attribute adapteeSetMethod 
    

};
//## class NonConstUIntAttrWebAdapterTmpl 



template <class ParentClass> NonConstUIntAttrWebAdapterTmpl<ParentClass> ::NonConstUIntAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod) : ULongAttrWebAdapter(
(void*)theParent,
name),
adapteeGetMethod(getMethod),
adapteeSetMethod(setMethod) {
    //#[ operation NonConstUIntAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    //#]
}

template <class ParentClass> int NonConstUIntAttrWebAdapterTmpl<ParentClass> ::GetPermissions() const {
    //#[ operation GetPermissions() const 
    int permissions = 0;
    if (adapteeGetMethod)
        permissions |= READ_PERMISSION;
    if (adapteeSetMethod)
        permissions |= WRITE_PERMISSION;
    return permissions;
    //#]
}

template <class ParentClass> unsigned long NonConstUIntAttrWebAdapterTmpl<ParentClass> ::GetValue() {
    //#[ operation GetValue() 
    ParentClass * theAdapteeParent = (ParentClass *)(adapteeParent);
    unsigned int (ParentClass::*getMethod)() = adapteeGetMethod;
    if (getMethod == (getter) NULL) // for safety
        return ULONG_MAX;
    return (unsigned long) (theAdapteeParent->*adapteeGetMethod)();
    
    //#]
}

template <class ParentClass> void NonConstUIntAttrWebAdapterTmpl<ParentClass> ::SetValue(unsigned long val) {
    //#[ operation SetValue(unsigned long) 
    ParentClass * theAdapteeParent = (ParentClass *)(adapteeParent);
    void (ParentClass::*setMethod)(unsigned int) = adapteeSetMethod;
    if (setMethod) // for safety
        (theAdapteeParent ->*setMethod)((unsigned int) val);
    //#]
}

//## package NonConstTemplatedAdapters 


//## class NonConstULongAttrWebAdapterTmpl 
template <class ParentClass> class NonConstULongAttrWebAdapterTmpl : public ULongAttrWebAdapter {
protected :
    typedef unsigned long (ParentClass::*getter)();
    
    typedef void (ParentClass::*setter)(unsigned long);
    
    


////    Constructors and destructors    ////
public :
    
    //## operation NonConstULongAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    NonConstULongAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod);


////    Operations    ////
public :
    
    //## operation GetPermissions() const 
    virtual int GetPermissions() const;
    
    //## operation GetValue() 
    virtual unsigned long GetValue();
    
    //## operation SetValue(unsigned long) 
    virtual void SetValue(unsigned long val);


////    Attributes    ////
protected :
    
    getter adapteeGetMethod;		//## attribute adapteeGetMethod 
    
    setter adapteeSetMethod;		//## attribute adapteeSetMethod 
    

};
//## class NonConstULongAttrWebAdapterTmpl 



template <class ParentClass> NonConstULongAttrWebAdapterTmpl<ParentClass> ::NonConstULongAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod) : ULongAttrWebAdapter(
(void*)theParent,
name),
adapteeGetMethod(getMethod),
adapteeSetMethod(setMethod) {
    //#[ operation NonConstULongAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    //#]
}

template <class ParentClass> int NonConstULongAttrWebAdapterTmpl<ParentClass> ::GetPermissions() const {
    //#[ operation GetPermissions() const 
    int permissions = 0;
    if (adapteeGetMethod)
        permissions |= READ_PERMISSION;
    if (adapteeSetMethod)
        permissions |= WRITE_PERMISSION;
    return permissions;
    //#]
}

template <class ParentClass> unsigned long NonConstULongAttrWebAdapterTmpl<ParentClass> ::GetValue() {
    //#[ operation GetValue() 
    ParentClass * theAdapteeParent = (ParentClass *)(adapteeParent);
    unsigned long (ParentClass::*getMethod)() = adapteeGetMethod;
    if (getMethod == (getter) NULL) // for safety
        return ULONG_MAX;
    return (theAdapteeParent->*adapteeGetMethod)();
    
    //#]
}

template <class ParentClass> void NonConstULongAttrWebAdapterTmpl<ParentClass> ::SetValue(unsigned long val) {
    //#[ operation SetValue(unsigned long) 
    ParentClass * theAdapteeParent = (ParentClass *)(adapteeParent);
    void (ParentClass::*setMethod)(unsigned long) = adapteeSetMethod;
    if (setMethod) // for safety
        (theAdapteeParent ->*setMethod)(val);
    //#]
}

//## package NonConstTemplatedAdapters 


//## class NonConstUShortAttrWebAdapterTmpl 
template <class ParentClass> class NonConstUShortAttrWebAdapterTmpl : public ULongAttrWebAdapter {
protected :
    typedef unsigned short (ParentClass::*getter)();
    
    typedef void (ParentClass::*setter)(unsigned short);
    
    


////    Constructors and destructors    ////
public :
    
    //## operation NonConstUShortAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    NonConstUShortAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod);


////    Operations    ////
public :
    
    //## operation GetPermissions() const 
    virtual int GetPermissions() const;
    
    //## operation GetValue() 
    virtual unsigned long GetValue();
    
    //## operation SetValue(unsigned long) 
    virtual void SetValue(unsigned long val);


////    Attributes    ////
protected :
    
    getter adapteeGetMethod;		//## attribute adapteeGetMethod 
    
    setter adapteeSetMethod;		//## attribute adapteeSetMethod 
    

};
//## class NonConstUShortAttrWebAdapterTmpl 



template <class ParentClass> NonConstUShortAttrWebAdapterTmpl<ParentClass> ::NonConstUShortAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod) : ULongAttrWebAdapter(
(void*)theParent,
name),
adapteeGetMethod(getMethod),
adapteeSetMethod(setMethod) {
    //#[ operation NonConstUShortAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    //#]
}

template <class ParentClass> int NonConstUShortAttrWebAdapterTmpl<ParentClass> ::GetPermissions() const {
    //#[ operation GetPermissions() const 
    int permissions = 0;
    if (adapteeGetMethod)
        permissions |= READ_PERMISSION;
    if (adapteeSetMethod)
        permissions |= WRITE_PERMISSION;
    return permissions;
    //#]
}

template <class ParentClass> unsigned long NonConstUShortAttrWebAdapterTmpl<ParentClass> ::GetValue() {
    //#[ operation GetValue() 
    ParentClass * theAdapteeParent = (ParentClass *)(adapteeParent);
    unsigned short (ParentClass::*getMethod)() = adapteeGetMethod;
    if (getMethod == (getter) NULL) // for safety
        return ULONG_MAX;
    return (unsigned long) (theAdapteeParent->*adapteeGetMethod)();
    
    //#]
}

template <class ParentClass> void NonConstUShortAttrWebAdapterTmpl<ParentClass> ::SetValue(unsigned long val) {
    //#[ operation SetValue(unsigned long) 
    ParentClass * theAdapteeParent = (ParentClass *)(adapteeParent);
    void (ParentClass::*setMethod)(unsigned short) = adapteeSetMethod;
    if (setMethod) // for safety
        (theAdapteeParent ->*setMethod)((unsigned short) val);
    //#]
}

//## package TemplatedAdapters 


// Contains templates to refine the basic adapters found in CppWebAdaptersPkg so that they connect to user-defined classes.

// included for error values (INT_MAX)
#include <limits.h>                   
// included for error values (DBL_MAX)
#include <float.h>


//## package TemplatedAdapters 


//## class BoolAttrWebAdapterTmpl 
template <class ParentClass> class BoolAttrWebAdapterTmpl : public IntAttrWebAdapter {
protected :
    typedef bool (ParentClass::*getter)() const;
    
    typedef void (ParentClass::*setter)(bool);
    
    


////    Constructors and destructors    ////
public :
    
    //## operation BoolAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    BoolAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod);


////    Operations    ////
public :
    
    //## operation GetPermissions() const 
    virtual int GetPermissions() const;
    
    //## operation GetValue() 
    virtual int GetValue();
    
    //## operation Register() 
    virtual void Register();
    
    //## operation SetValue(int) 
    virtual void SetValue(int val);


////    Attributes    ////
protected :
    
    getter adapteeGetMethod;		//## attribute adapteeGetMethod 
    
    setter adapteeSetMethod;		//## attribute adapteeSetMethod 
    

};
//## class BoolAttrWebAdapterTmpl 



template <class ParentClass> BoolAttrWebAdapterTmpl<ParentClass> ::BoolAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod) : IntAttrWebAdapter(
(void*)theParent,
name),
adapteeGetMethod(getMethod),
adapteeSetMethod(setMethod) {
    //#[ operation BoolAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    //#]
}

template <class ParentClass> int BoolAttrWebAdapterTmpl<ParentClass> ::GetPermissions() const {
    //#[ operation GetPermissions() const 
    int permissions = 0;
    if (adapteeGetMethod)
        permissions |= READ_PERMISSION;
    if (adapteeSetMethod)
        permissions |= WRITE_PERMISSION;
    return permissions;
     
    //#]
}

template <class ParentClass> int BoolAttrWebAdapterTmpl<ParentClass> ::GetValue() {
    //#[ operation GetValue() 
    const ParentClass * theAdapteeParent = (const ParentClass *)(adapteeParent);
    bool (ParentClass::*getMethod)() const = adapteeGetMethod;
    if (getMethod == (getter) NULL) // for safety
        return INT_MAX;
    bool value = (theAdapteeParent->*adapteeGetMethod)();
    return (value == true) ? 1 : 0;
    
    //#]
}

template <class ParentClass> void BoolAttrWebAdapterTmpl<ParentClass> ::Register() {
    //#[ operation Register() 
    if (!isRegistered) {
        id = C_RegisterWebBool(name, this);
        isRegistered = true;
    }
    
    //#]
}

template <class ParentClass> void BoolAttrWebAdapterTmpl<ParentClass> ::SetValue(int val) {
    //#[ operation SetValue(int) 
    ParentClass * theAdapteeParent = (ParentClass *)(adapteeParent);
    void (ParentClass::*setMethod)(bool) = adapteeSetMethod;
    if (setMethod) { // for safety
        bool boolVal = (val != 0) ? true : false;
        (theAdapteeParent ->*setMethod)(boolVal);
    }
    //#]
}

//## package TemplatedAdapters 


//## class CharAttrWebAdapterTmpl 
template <class ParentClass> class CharAttrWebAdapterTmpl : public CharAttrWebAdapter {
protected :
    typedef char (ParentClass::*getter)() const;
    
    typedef void (ParentClass::*setter)(char);
    
    


////    Constructors and destructors    ////
public :
    
    //## operation CharAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    CharAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod);


////    Operations    ////
public :
    
    //## operation GetPermissions() const 
    virtual int GetPermissions() const;
    
    //## operation GetValue() 
    virtual char GetValue();
    
    //## operation SetValue(char) 
    virtual void SetValue(char val);


////    Attributes    ////
protected :
    
    getter adapteeGetMethod;		//## attribute adapteeGetMethod 
    
    setter adapteeSetMethod;		//## attribute adapteeSetMethod 
    

};
//## class CharAttrWebAdapterTmpl 



template <class ParentClass> CharAttrWebAdapterTmpl<ParentClass> ::CharAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod) : CharAttrWebAdapter(
(void*)theParent,
name),
adapteeGetMethod(getMethod),
adapteeSetMethod(setMethod) {
    //#[ operation CharAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    //#]
}

template <class ParentClass> int CharAttrWebAdapterTmpl<ParentClass> ::GetPermissions() const {
    //#[ operation GetPermissions() const 
    int permissions = 0;
    if (adapteeGetMethod)
        permissions |= READ_PERMISSION;
    if (adapteeSetMethod)
        permissions |= WRITE_PERMISSION;
    return permissions;
    
    //#]
}

template <class ParentClass> char CharAttrWebAdapterTmpl<ParentClass> ::GetValue() {
    //#[ operation GetValue() 
    const ParentClass * theAdapteeParent = (const ParentClass *)(adapteeParent);
    char (ParentClass::*getMethod)() const = adapteeGetMethod;
    if (getMethod == (getter) NULL) // for safety
        return CHAR_MAX;
    return (theAdapteeParent->*adapteeGetMethod)();
    
    //#]
}

template <class ParentClass> void CharAttrWebAdapterTmpl<ParentClass> ::SetValue(char val) {
    //#[ operation SetValue(char) 
    ParentClass * theAdapteeParent = (ParentClass *)(adapteeParent);
    void (ParentClass::*setMethod)(char) = adapteeSetMethod;
    if (setMethod) // for safety
        (theAdapteeParent ->*setMethod)(val);
    //#]
}

//## package TemplatedAdapters 


// This class describes an adapter for classes.
// This is an aggregating adapter.
//## class ClassWebAdapterTmpl 
template <class AdapteeClass> class ClassWebAdapterTmpl : public ClassWebAdapter {


////    Constructors and destructors    ////
public :
    
    //## operation ClassWebAdapterTmpl(AdapteeClass *,const char *) 
    ClassWebAdapterTmpl(AdapteeClass * theAdaptee, const char * name);


////    Operations    ////
public :
    
    //## operation ResetWebRelations() 
    virtual void ResetWebRelations();


};
//## class ClassWebAdapterTmpl 


template <class AdapteeClass> ClassWebAdapterTmpl<AdapteeClass> ::ClassWebAdapterTmpl(AdapteeClass * theAdaptee, const char * name) : ClassWebAdapter(
(void*)theAdaptee,
name)
 {
    //#[ operation ClassWebAdapterTmpl(AdapteeClass *,const char *) 
       
    
    //#]
}

template <class AdapteeClass> void ClassWebAdapterTmpl<AdapteeClass> ::ResetWebRelations() {
    //#[ operation ResetWebRelations() 
    ClassWebAdapter::ResetWebRelations();
    const AdapteeClass * adaptedObject = (AdapteeClass *)itsAdaptee;
    adaptedObject->visitWebAdaptedRelations();
    //#]
}

//## package TemplatedAdapters 


//## class ConstClassOperationWebAdapterTmpl 
template <class ParentClass> class ConstClassOperationWebAdapterTmpl : public ClassOperationWebAdapter {
protected :
    typedef void (ParentClass::*no_arg_operation)() const;
    
    


////    Constructors and destructors    ////
public :
    
    //## operation ConstClassOperationWebAdapterTmpl(ParentClass *,const char *,omtypename no_arg_operation) 
    ConstClassOperationWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename no_arg_operation anOperation);


////    Operations    ////
public :
    
    //## operation GetPermissions() const 
    virtual int GetPermissions() const;
    
    //## operation Send() 
    virtual void Send();


////    Attributes    ////
protected :
    
    // A pointer to the user-defined no-arg operation.
    no_arg_operation theOperation;		//## attribute theOperation 
    

};
//## class ConstClassOperationWebAdapterTmpl 



template <class ParentClass> ConstClassOperationWebAdapterTmpl<ParentClass> ::ConstClassOperationWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename no_arg_operation anOperation) : ClassOperationWebAdapter(
theParent,
name),
theOperation(anOperation) {
    //#[ operation ConstClassOperationWebAdapterTmpl(ParentClass *,const char *,omtypename no_arg_operation) 
    //#]
}

template <class ParentClass> int ConstClassOperationWebAdapterTmpl<ParentClass> ::GetPermissions() const {
    //#[ operation GetPermissions() const 
    int permissions = 0;
    if (theOperation)
        permissions |= WRITE_PERMISSION;
    return permissions;
    //#]
}

template <class ParentClass> void ConstClassOperationWebAdapterTmpl<ParentClass> ::Send() {
    //#[ operation Send() 
    const ParentClass * pAdapteeParent = (const ParentClass *)(adapteeParent);
    void (ParentClass::*pUserDefineOperation)() const = theOperation;
    if (theOperation) // for safety
        (pAdapteeParent->*pUserDefineOperation)();
    //#]
}

//## package TemplatedAdapters 


//## class CStrAttrWebAdapterTmpl 
template <class ParentClass> class CStrAttrWebAdapterTmpl : public CStrAttrWebAdapter {
protected :
    typedef char * (ParentClass::*getter)();
    
    
public :
    typedef void (ParentClass::*setter)(char *);
    
    


////    Constructors and destructors    ////
public :
    
    //## operation CStrAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    CStrAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod);


////    Operations    ////
public :
    
    //## operation GetPermissions() const 
    virtual int GetPermissions() const;
    
    //## operation GetValue() 
    virtual char* GetValue();
    
    //## operation SetValue(char*) 
    virtual void SetValue(char* val);


////    Attributes    ////
protected :
    
    getter adapteeGetMethod;		//## attribute adapteeGetMethod 
    
    setter adapteeSetMethod;		//## attribute adapteeSetMethod 
    

};
//## class CStrAttrWebAdapterTmpl 



template <class ParentClass> CStrAttrWebAdapterTmpl<ParentClass> ::CStrAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod) : CStrAttrWebAdapter(
(void*)theParent,
name),
adapteeGetMethod(getMethod),
adapteeSetMethod(setMethod)
 {
    //#[ operation CStrAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    //#]
}

template <class ParentClass> int CStrAttrWebAdapterTmpl<ParentClass> ::GetPermissions() const {
    //#[ operation GetPermissions() const 
    int permissions = 0;
    if (adapteeGetMethod)
        permissions |= READ_PERMISSION;
    if (adapteeSetMethod)
        permissions |= WRITE_PERMISSION;
    return permissions;
    //#]
}

template <class ParentClass> char* CStrAttrWebAdapterTmpl<ParentClass> ::GetValue() {
    //#[ operation GetValue() 
    ParentClass * theAdapteeParent = (ParentClass *)(adapteeParent);
    char * (ParentClass::*getMethod)() = adapteeGetMethod;
    if (getMethod == (getter) NULL) // for safety
        return NULL;
    return (char *) (theAdapteeParent ->*adapteeGetMethod)();
    
    //#]
}

template <class ParentClass> void CStrAttrWebAdapterTmpl<ParentClass> ::SetValue(char* val) {
    //#[ operation SetValue(char*) 
    ParentClass * theAdapteeParent= (ParentClass *)(adapteeParent);
    void (ParentClass::*setMethod)(char *) = adapteeSetMethod;
    if (setMethod) // for safety
        (theAdapteeParent->*setMethod)(val);
    //#]
}

//## package TemplatedAdapters 


//## class DoubleAttrWebAdapterTmpl 
template <class ParentClass> class DoubleAttrWebAdapterTmpl : public DoubleAttrWebAdapter {
protected :
    typedef double (ParentClass::*getter)() const;
    
    typedef void (ParentClass::*setter)(double);
    
    


////    Constructors and destructors    ////
public :
    
    //## operation DoubleAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    DoubleAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod);


////    Operations    ////
public :
    
    //## operation GetPermissions() const 
    virtual int GetPermissions() const;
    
    //## operation GetValue() 
    virtual double GetValue();
    
    //## operation SetValue(double) 
    virtual void SetValue(double val);


////    Attributes    ////
protected :
    
    getter adapteeGetMethod;		//## attribute adapteeGetMethod 
    
    setter adapteeSetMethod;		//## attribute adapteeSetMethod 
    

};
//## class DoubleAttrWebAdapterTmpl 



template <class ParentClass> DoubleAttrWebAdapterTmpl<ParentClass> ::DoubleAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod) : DoubleAttrWebAdapter(
(void*)theParent,
name),
adapteeGetMethod(getMethod),
adapteeSetMethod(setMethod)
 {
    //#[ operation DoubleAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    //#]
}

template <class ParentClass> int DoubleAttrWebAdapterTmpl<ParentClass> ::GetPermissions() const {
    //#[ operation GetPermissions() const 
    int permissions = 0;
    if (adapteeGetMethod)
        permissions |= READ_PERMISSION;
    if (adapteeSetMethod)
        permissions |= WRITE_PERMISSION;
    return permissions;
    //#]
}

template <class ParentClass> double DoubleAttrWebAdapterTmpl<ParentClass> ::GetValue() {
    //#[ operation GetValue() 
    const ParentClass * theAdapteeParent = (const ParentClass *)(adapteeParent);
    double (ParentClass::*getMethod)() const = adapteeGetMethod;
    if (getMethod == (getter) NULL) // for safety
        return DBL_MAX;
    return (theAdapteeParent->*adapteeGetMethod)();
    
    //#]
}

template <class ParentClass> void DoubleAttrWebAdapterTmpl<ParentClass> ::SetValue(double val) {
    //#[ operation SetValue(double) 
    ParentClass * theAdapteeParent = (ParentClass *)(adapteeParent);
    void (ParentClass::*setMethod)(double) = adapteeSetMethod;
    if (setMethod) // for safety
        (theAdapteeParent->*setMethod)(val);
    //#]
}

//## package TemplatedAdapters 


//## class EventReceptionWebAdapterTmpl 
template <class ParentClass, class EventClass> class EventReceptionWebAdapterTmpl : public EventReceptionWebAdapter {


////    Constructors and destructors    ////
public :
    
    //## operation EventReceptionWebAdapterTmpl(ParentClass *,const char *) 
    EventReceptionWebAdapterTmpl(ParentClass * theParent, const char * name);


////    Operations    ////
public :
    
    //## operation GetPermissions() const 
    virtual int GetPermissions() const;
    
    //## operation Send() 
    virtual void Send();


};
//## class EventReceptionWebAdapterTmpl 


template <class ParentClass, class EventClass> EventReceptionWebAdapterTmpl<ParentClass, EventClass> ::EventReceptionWebAdapterTmpl(ParentClass * theParent, const char * name) : EventReceptionWebAdapter(
(void*)theParent,
name) {
    //#[ operation EventReceptionWebAdapterTmpl(ParentClass *,const char *) 
    //#]
}

template <class ParentClass, class EventClass> int EventReceptionWebAdapterTmpl<ParentClass, EventClass> ::GetPermissions() const {
    //#[ operation GetPermissions() const 
    return WRITE_PERMISSION;
    
    //#]
}

template <class ParentClass, class EventClass> void EventReceptionWebAdapterTmpl<ParentClass, EventClass> ::Send() {
    //#[ operation Send() 
    ParentClass * pParent = (ParentClass *)adapteeParent;
    EventClass * pNewEvent = new EventClass;
    if (pNewEvent) // for safety
        pParent->gen(pNewEvent);
    //#]
}

//## package TemplatedAdapters 


//## class IntAttrWebAdapterTmpl 
template <class ParentClass> class IntAttrWebAdapterTmpl : public IntAttrWebAdapter {
protected :
    typedef int (ParentClass::*getter)() const;
    
    typedef void (ParentClass::*setter)(int);
    
    


////    Constructors and destructors    ////
public :
    
    //## operation IntAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    IntAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod);


////    Operations    ////
public :
    
    //## operation GetPermissions() const 
    virtual int GetPermissions() const;
    
    //## operation GetValue() 
    virtual int GetValue();
    
    //## operation SetValue(int) 
    virtual void SetValue(int val);


////    Attributes    ////
protected :
    
    getter adapteeGetMethod;		//## attribute adapteeGetMethod 
    
    setter adapteeSetMethod;		//## attribute adapteeSetMethod 
    

};
//## class IntAttrWebAdapterTmpl 



template <class ParentClass> IntAttrWebAdapterTmpl<ParentClass> ::IntAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod) : IntAttrWebAdapter(
(void*)theParent,
name),
adapteeGetMethod(getMethod),
adapteeSetMethod(setMethod) {
    //#[ operation IntAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    //#]
}

template <class ParentClass> int IntAttrWebAdapterTmpl<ParentClass> ::GetPermissions() const {
    //#[ operation GetPermissions() const 
    int permissions = 0;
    if (adapteeGetMethod)
        permissions |= READ_PERMISSION;
    if (adapteeSetMethod)
        permissions |= WRITE_PERMISSION;
    return permissions;
    //#]
}

template <class ParentClass> int IntAttrWebAdapterTmpl<ParentClass> ::GetValue() {
    //#[ operation GetValue() 
    const ParentClass * theAdapteeParent = (const ParentClass *)(adapteeParent);
    int (ParentClass::*getMethod)() const = adapteeGetMethod;
    if (getMethod == (getter) NULL) // for safety
        return INT_MAX;
    return (theAdapteeParent->*adapteeGetMethod)();
    
    //#]
}

template <class ParentClass> void IntAttrWebAdapterTmpl<ParentClass> ::SetValue(int val) {
    //#[ operation SetValue(int) 
    ParentClass * theAdapteeParent = (ParentClass *)(adapteeParent);
    void (ParentClass::*setMethod)(int) = adapteeSetMethod;
    if (setMethod) // for safety
        (theAdapteeParent ->*setMethod)(val);
    //#]
}

//## package TemplatedAdapters 


//## class LongAttrWebAdapterTmpl 
template <class ParentClass> class LongAttrWebAdapterTmpl : public LongAttrWebAdapter {
protected :
    typedef long (ParentClass::*getter)() const;
    
    typedef void (ParentClass::*setter)(long);
    
    


////    Constructors and destructors    ////
public :
    
    //## operation LongAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    LongAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod);


////    Operations    ////
public :
    
    //## operation GetPermissions() const 
    virtual int GetPermissions() const;
    
    //## operation GetValue() 
    virtual long GetValue();
    
    //## operation SetValue(long) 
    virtual void SetValue(long val);


////    Attributes    ////
protected :
    
    getter adapteeGetMethod;		//## attribute adapteeGetMethod 
    
    setter adapteeSetMethod;		//## attribute adapteeSetMethod 
    

};
//## class LongAttrWebAdapterTmpl 



template <class ParentClass> LongAttrWebAdapterTmpl<ParentClass> ::LongAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod) : LongAttrWebAdapter(
(void*)theParent,
name),
adapteeGetMethod(getMethod),
adapteeSetMethod(setMethod) {
    //#[ operation LongAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    //#]
}

template <class ParentClass> int LongAttrWebAdapterTmpl<ParentClass> ::GetPermissions() const {
    //#[ operation GetPermissions() const 
    int permissions = 0;
    if (adapteeGetMethod)
        permissions |= READ_PERMISSION;
    if (adapteeSetMethod)
        permissions |= WRITE_PERMISSION;
    return permissions;
    //#]
}

template <class ParentClass> long LongAttrWebAdapterTmpl<ParentClass> ::GetValue() {
    //#[ operation GetValue() 
    const ParentClass * theAdapteeParent = (const ParentClass *)(adapteeParent);
    long (ParentClass::*getMethod)() const = adapteeGetMethod;
    if (getMethod == (getter) NULL) // for safety
        return LONG_MAX;
    return (theAdapteeParent->*adapteeGetMethod)();
    
    //#]
}

template <class ParentClass> void LongAttrWebAdapterTmpl<ParentClass> ::SetValue(long val) {
    //#[ operation SetValue(long) 
    ParentClass * theAdapteeParent = (ParentClass *)(adapteeParent);
    void (ParentClass::*setMethod)(long) = adapteeSetMethod;
    if (setMethod) // for safety
        (theAdapteeParent ->*setMethod)(val);
    //#]
}

//## package TemplatedAdapters 


// Used to prevent Rhapsody from generating
// a default destructor, to reduce code size.
//## class OMBooleanAttrWebAdapterTmpl 
template <class ParentClass> class OMBooleanAttrWebAdapterTmpl : public IntAttrWebAdapter {
protected :
    typedef OMBoolean (ParentClass::*getter)() const;
    
    typedef void (ParentClass::*setter)(OMBoolean);
    
    


////    Constructors and destructors    ////
public :
    
    //## operation OMBooleanAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    OMBooleanAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod);


////    Operations    ////
public :
    
    //## operation GetPermissions() const 
    virtual int GetPermissions() const;
    
    //## operation GetValue() 
    virtual int GetValue();
    
    //## operation Register() 
    virtual void Register();
    
    //## operation SetValue(int) 
    virtual void SetValue(int val);


////    Attributes    ////
protected :
    
    getter adapteeGetMethod;		//## attribute adapteeGetMethod 
    
    setter adapteeSetMethod;		//## attribute adapteeSetMethod 
    

};
//## class OMBooleanAttrWebAdapterTmpl 



template <class ParentClass> OMBooleanAttrWebAdapterTmpl<ParentClass> ::OMBooleanAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod) : IntAttrWebAdapter(
(void*)theParent,
name),
adapteeGetMethod(getMethod),
adapteeSetMethod(setMethod) {
    //#[ operation OMBooleanAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    //#]
}

template <class ParentClass> int OMBooleanAttrWebAdapterTmpl<ParentClass> ::GetPermissions() const {
    //#[ operation GetPermissions() const 
    int permissions = 0;
    if (adapteeGetMethod)
        permissions |= READ_PERMISSION;
    if (adapteeSetMethod)
        permissions |= WRITE_PERMISSION;
    return permissions;
    //#]
}

template <class ParentClass> int OMBooleanAttrWebAdapterTmpl<ParentClass> ::GetValue() {
    //#[ operation GetValue() 
    const ParentClass * theAdapteeParent = (const ParentClass *)(adapteeParent);
    OMBoolean (ParentClass::*getMethod)() const = adapteeGetMethod;
    if (getMethod == (getter) NULL) // for safety
        return INT_MAX;
    OMBoolean value = (theAdapteeParent->*adapteeGetMethod)();
    return (value == TRUE) ? 1 : 0;
    
    //#]
}

template <class ParentClass> void OMBooleanAttrWebAdapterTmpl<ParentClass> ::Register() {
    //#[ operation Register() 
    if (!isRegistered) {
        id = C_RegisterWebBool(name, this);
        isRegistered = true;
    }
    //#]
}

template <class ParentClass> void OMBooleanAttrWebAdapterTmpl<ParentClass> ::SetValue(int val) {
    //#[ operation SetValue(int) 
    ParentClass * theAdapteeParent = (ParentClass *)(adapteeParent);
    void (ParentClass::*setMethod)(OMBoolean) = adapteeSetMethod;
    if (setMethod) { // for safety 
        OMBoolean boolVal = (val != 0) ? TRUE : FALSE;
        (theAdapteeParent ->*setMethod)(boolVal);
    }
    //#]
}

//## package TemplatedAdapters 


//## class OMStringAttrWebAdapterTmpl 
template <class ParentClass> class OMStringAttrWebAdapterTmpl : public CStrAttrWebAdapter {
protected :
    typedef OMString (ParentClass::*getter)() const;
    
    typedef void (ParentClass::*setter)(OMString);
    
    


////    Constructors and destructors    ////
public :
    
    //## operation OMStringAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    OMStringAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod);


////    Operations    ////
public :
    
    //## operation GetPermissions() const 
    virtual int GetPermissions() const;
    
    //## operation GetValue() 
    virtual char* GetValue();
    
    //## operation SetValue(char*) 
    virtual void SetValue(char* val);


////    Additional operations    ////
protected :
    
    OMString getLocalString() const;
    
    void setLocalString(OMString p_localString);


////    Attributes    ////
protected :
    
    getter adapteeGetMethod;		//## attribute adapteeGetMethod 
    
    setter adapteeSetMethod;		//## attribute adapteeSetMethod 
    
    OMString localString;		//## attribute localString 
    

};
//## class OMStringAttrWebAdapterTmpl 



template <class ParentClass> OMStringAttrWebAdapterTmpl<ParentClass> ::OMStringAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod) : CStrAttrWebAdapter(
(void*)theParent,
name),
adapteeGetMethod(getMethod),
adapteeSetMethod(setMethod) {
    //#[ operation OMStringAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    //#]
}

template <class ParentClass> int OMStringAttrWebAdapterTmpl<ParentClass> ::GetPermissions() const {
    //#[ operation GetPermissions() const 
    int permissions = 0;
    if (adapteeGetMethod)
        permissions |= READ_PERMISSION;
    if (adapteeSetMethod)
        permissions |= WRITE_PERMISSION;
    return permissions;
    //#]
}

template <class ParentClass> char* OMStringAttrWebAdapterTmpl<ParentClass> ::GetValue() {
    //#[ operation GetValue() 
    const ParentClass * theAdapteeParent = (const ParentClass *)(adapteeParent);
    OMString (ParentClass::*getMethod)() const = adapteeGetMethod;
    if (getMethod == (getter) NULL) // for safety
        return NULL;
    localString = (theAdapteeParent->*adapteeGetMethod)();
    return localString.GetBuffer(0);
    
    //#]
}

template <class ParentClass> void OMStringAttrWebAdapterTmpl<ParentClass> ::SetValue(char* val) {
    //#[ operation SetValue(char*) 
    ParentClass * theAdapteeParent= (ParentClass *)(adapteeParent);
    void (ParentClass::*setMethod)(OMString) = adapteeSetMethod;
    if (setMethod) { // for safety 
        OMString str = val;
        (theAdapteeParent->*setMethod)(str);
        free(val); val = NULL; // WebServices allocated the string using malloc
    }
    //#]
}

template <class ParentClass> OMString OMStringAttrWebAdapterTmpl<ParentClass> ::getLocalString() const {
    return localString;
}

template <class ParentClass> void OMStringAttrWebAdapterTmpl<ParentClass> ::setLocalString(OMString p_localString) {
    localString = p_localString;
}

//## package TemplatedAdapters 


//## class ShortAttrWebAdapterTmpl 
template <class ParentClass> class ShortAttrWebAdapterTmpl : public LongAttrWebAdapter {
protected :
    typedef short (ParentClass::*getter)() const;
    
    typedef void (ParentClass::*setter)(short);
    
    


////    Constructors and destructors    ////
public :
    
    //## operation ShortAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    ShortAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod);


////    Operations    ////
public :
    
    //## operation GetPermissions() const 
    virtual int GetPermissions() const;
    
    //## operation GetValue() 
    virtual long GetValue();
    
    //## operation SetValue(long) 
    virtual void SetValue(long val);


////    Attributes    ////
protected :
    
    getter adapteeGetMethod;		//## attribute adapteeGetMethod 
    
    setter adapteeSetMethod;		//## attribute adapteeSetMethod 
    

};
//## class ShortAttrWebAdapterTmpl 



template <class ParentClass> ShortAttrWebAdapterTmpl<ParentClass> ::ShortAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod) : LongAttrWebAdapter(
(void*)theParent,
name),
adapteeGetMethod(getMethod),
adapteeSetMethod(setMethod) {
    //#[ operation ShortAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    //#]
}

template <class ParentClass> int ShortAttrWebAdapterTmpl<ParentClass> ::GetPermissions() const {
    //#[ operation GetPermissions() const 
    int permissions = 0;
    if (adapteeGetMethod)
        permissions |= READ_PERMISSION;
    if (adapteeSetMethod)
        permissions |= WRITE_PERMISSION;
    return permissions;
    //#]
}

template <class ParentClass> long ShortAttrWebAdapterTmpl<ParentClass> ::GetValue() {
    //#[ operation GetValue() 
    const ParentClass * theAdapteeParent = (const ParentClass *)(adapteeParent);
    short (ParentClass::*getMethod)() const = adapteeGetMethod;
    if (getMethod == (getter) NULL) // for safety
        return (long) SHRT_MAX;
    return (long) (theAdapteeParent->*adapteeGetMethod)();
    
    //#]
}

template <class ParentClass> void ShortAttrWebAdapterTmpl<ParentClass> ::SetValue(long val) {
    //#[ operation SetValue(long) 
    ParentClass * theAdapteeParent = (ParentClass *)(adapteeParent);
    void (ParentClass::*setMethod)(short) = adapteeSetMethod;
    if (setMethod) // for safety
        (theAdapteeParent ->*setMethod)((short) val);
    //#]
}

//## package TemplatedAdapters 


//## class UCharAttrWebAdapterTmpl 
template <class ParentClass> class UCharAttrWebAdapterTmpl : public ULongAttrWebAdapter {
protected :
    typedef unsigned char (ParentClass::*getter)() const;
    
    typedef void (ParentClass::*setter)(unsigned char);
    
    


////    Constructors and destructors    ////
public :
    
    //## operation UCharAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    UCharAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod);


////    Operations    ////
public :
    
    //## operation GetPermissions() const 
    virtual int GetPermissions() const;
    
    //## operation GetValue() 
    virtual unsigned long GetValue();
    
    //## operation SetValue(unsigned long) 
    virtual void SetValue(unsigned long val);


////    Attributes    ////
protected :
    
    getter adapteeGetMethod;		//## attribute adapteeGetMethod 
    
    setter adapteeSetMethod;		//## attribute adapteeSetMethod 
    

};
//## class UCharAttrWebAdapterTmpl 



template <class ParentClass> UCharAttrWebAdapterTmpl<ParentClass> ::UCharAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod) : ULongAttrWebAdapter(
(void*)theParent,
name),
adapteeGetMethod(getMethod),
adapteeSetMethod(setMethod) {
    //#[ operation UCharAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    //#]
}

template <class ParentClass> int UCharAttrWebAdapterTmpl<ParentClass> ::GetPermissions() const {
    //#[ operation GetPermissions() const 
    int permissions = 0;
    if (adapteeGetMethod)
        permissions |= READ_PERMISSION;
    if (adapteeSetMethod)
        permissions |= WRITE_PERMISSION;
    return permissions;
    
    //#]
}

template <class ParentClass> unsigned long UCharAttrWebAdapterTmpl<ParentClass> ::GetValue() {
    //#[ operation GetValue() 
    const ParentClass * theAdapteeParent = (const ParentClass *)(adapteeParent);
    unsigned char (ParentClass::*getMethod)() const = adapteeGetMethod;
    if (getMethod == (getter) NULL) // for safety
        return (unsigned char) UCHAR_MAX;
    return (unsigned long) (theAdapteeParent->*adapteeGetMethod)();
    //#]
}

template <class ParentClass> void UCharAttrWebAdapterTmpl<ParentClass> ::SetValue(unsigned long val) {
    //#[ operation SetValue(unsigned long) 
    ParentClass * theAdapteeParent = (ParentClass *)(adapteeParent);
    void (ParentClass::*setMethod)(unsigned char) = adapteeSetMethod;
    if (setMethod) // for safety
        (theAdapteeParent ->*setMethod)((unsigned char) val);
    //#]
}

//## package TemplatedAdapters 


//## class UIntAttrWebAdapterTmpl 
template <class ParentClass> class UIntAttrWebAdapterTmpl : public ULongAttrWebAdapter {
protected :
    typedef unsigned int (ParentClass::*getter)() const;
    
    typedef void (ParentClass::*setter)(unsigned int);
    
    


////    Constructors and destructors    ////
public :
    
    //## operation UIntAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    UIntAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod);


////    Operations    ////
public :
    
    //## operation GetPermissions() const 
    virtual int GetPermissions() const;
    
    //## operation GetValue() 
    virtual unsigned long GetValue();
    
    //## operation SetValue(unsigned long) 
    virtual void SetValue(unsigned long val);


////    Attributes    ////
protected :
    
    getter adapteeGetMethod;		//## attribute adapteeGetMethod 
    
    setter adapteeSetMethod;		//## attribute adapteeSetMethod 
    

};
//## class UIntAttrWebAdapterTmpl 



template <class ParentClass> UIntAttrWebAdapterTmpl<ParentClass> ::UIntAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod) : ULongAttrWebAdapter(
(void*)theParent,
name),
adapteeGetMethod(getMethod),
adapteeSetMethod(setMethod) {
    //#[ operation UIntAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    //#]
}

template <class ParentClass> int UIntAttrWebAdapterTmpl<ParentClass> ::GetPermissions() const {
    //#[ operation GetPermissions() const 
    int permissions = 0;
    if (adapteeGetMethod)
        permissions |= READ_PERMISSION;
    if (adapteeSetMethod)
        permissions |= WRITE_PERMISSION;
    return permissions;
    //#]
}

template <class ParentClass> unsigned long UIntAttrWebAdapterTmpl<ParentClass> ::GetValue() {
    //#[ operation GetValue() 
    const ParentClass * theAdapteeParent = (const ParentClass *)(adapteeParent);
    unsigned int (ParentClass::*getMethod)() const = adapteeGetMethod;
    if (getMethod == (getter) NULL) // for safety
        return (unsigned long) UINT_MAX;
    return (unsigned long) (theAdapteeParent->*adapteeGetMethod)();
    
    //#]
}

template <class ParentClass> void UIntAttrWebAdapterTmpl<ParentClass> ::SetValue(unsigned long val) {
    //#[ operation SetValue(unsigned long) 
    ParentClass * theAdapteeParent = (ParentClass *)(adapteeParent);
    void (ParentClass::*setMethod)(unsigned int) = adapteeSetMethod;
    if (setMethod) // for safety
        (theAdapteeParent ->*setMethod)((unsigned int) val);
    //#]
}

//## package TemplatedAdapters 


//## class ULongAttrWebAdapterTmpl 
template <class ParentClass> class ULongAttrWebAdapterTmpl : public ULongAttrWebAdapter {
protected :
    typedef unsigned long (ParentClass::*getter)() const;
    
    typedef void (ParentClass::*setter)(unsigned long);
    
    


////    Constructors and destructors    ////
public :
    
    //## operation ULongAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    ULongAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod);


////    Operations    ////
public :
    
    //## operation GetPermissions() const 
    virtual int GetPermissions() const;
    
    //## operation GetValue() 
    virtual unsigned long GetValue();
    
    //## operation SetValue(unsigned long) 
    virtual void SetValue(unsigned long val);


////    Attributes    ////
protected :
    
    getter adapteeGetMethod;		//## attribute adapteeGetMethod 
    
    setter adapteeSetMethod;		//## attribute adapteeSetMethod 
    

};
//## class ULongAttrWebAdapterTmpl 



template <class ParentClass> ULongAttrWebAdapterTmpl<ParentClass> ::ULongAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod) : ULongAttrWebAdapter(
(void*)theParent,
name),
adapteeGetMethod(getMethod),
adapteeSetMethod(setMethod) {
    //#[ operation ULongAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    //#]
}

template <class ParentClass> int ULongAttrWebAdapterTmpl<ParentClass> ::GetPermissions() const {
    //#[ operation GetPermissions() const 
    int permissions = 0;
    if (adapteeGetMethod)
        permissions |= READ_PERMISSION;
    if (adapteeSetMethod)
        permissions |= WRITE_PERMISSION;
    return permissions;
    //#]
}

template <class ParentClass> unsigned long ULongAttrWebAdapterTmpl<ParentClass> ::GetValue() {
    //#[ operation GetValue() 
    const ParentClass * theAdapteeParent = (const ParentClass *)(adapteeParent);
    unsigned long (ParentClass::*getMethod)() const = adapteeGetMethod;
    if (getMethod == (getter) NULL) // for safety
        return (unsigned long) ULONG_MAX;
    return (theAdapteeParent->*adapteeGetMethod)();
    
    //#]
}

template <class ParentClass> void ULongAttrWebAdapterTmpl<ParentClass> ::SetValue(unsigned long val) {
    //#[ operation SetValue(unsigned long) 
    ParentClass * theAdapteeParent = (ParentClass *)(adapteeParent);
    void (ParentClass::*setMethod)(unsigned long) = adapteeSetMethod;
    if (setMethod) // for safety
        (theAdapteeParent ->*setMethod)(val);
    //#]
}

//## package TemplatedAdapters 


//## class UShortAttrWebAdapterTmpl 
template <class ParentClass> class UShortAttrWebAdapterTmpl : public ULongAttrWebAdapter {
protected :
    typedef unsigned short (ParentClass::*getter)() const;
    
    typedef void (ParentClass::*setter)(unsigned short);
    
    


////    Constructors and destructors    ////
public :
    
    //## operation UShortAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    UShortAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod);


////    Operations    ////
public :
    
    //## operation GetPermissions() const 
    virtual int GetPermissions() const;
    
    //## operation GetValue() 
    virtual unsigned long GetValue();
    
    //## operation SetValue(unsigned long) 
    virtual void SetValue(unsigned long val);


////    Attributes    ////
protected :
    
    getter adapteeGetMethod;		//## attribute adapteeGetMethod 
    
    setter adapteeSetMethod;		//## attribute adapteeSetMethod 
    

};
//## class UShortAttrWebAdapterTmpl 



template <class ParentClass> UShortAttrWebAdapterTmpl<ParentClass> ::UShortAttrWebAdapterTmpl(ParentClass * theParent, const char * name, omtypename getter getMethod, omtypename setter setMethod) : ULongAttrWebAdapter(
(void*)theParent,
name),
adapteeGetMethod(getMethod),
adapteeSetMethod(setMethod) {
    //#[ operation UShortAttrWebAdapterTmpl(ParentClass *,const char *,omtypename getter,omtypename setter) 
    //#]
}

template <class ParentClass> int UShortAttrWebAdapterTmpl<ParentClass> ::GetPermissions() const {
    //#[ operation GetPermissions() const 
    int permissions = 0;
    if (adapteeGetMethod)
        permissions |= READ_PERMISSION;
    if (adapteeSetMethod)
        permissions |= WRITE_PERMISSION;
    return permissions;
    //#]
}

template <class ParentClass> unsigned long UShortAttrWebAdapterTmpl<ParentClass> ::GetValue() {
    //#[ operation GetValue() 
    const ParentClass * theAdapteeParent = (const ParentClass *)(adapteeParent);
    unsigned short (ParentClass::*getMethod)() const = adapteeGetMethod;
    if (getMethod == (getter) NULL) // for safety
        return (unsigned long) USHRT_MAX;
    return (unsigned long) (theAdapteeParent->*adapteeGetMethod)();
    
    //#]
}

template <class ParentClass> void UShortAttrWebAdapterTmpl<ParentClass> ::SetValue(unsigned long val) {
    //#[ operation SetValue(unsigned long) 
    ParentClass * theAdapteeParent = (ParentClass *)(adapteeParent);
    void (ParentClass::*setMethod)(unsigned short) = adapteeSetMethod;
    if (setMethod) // for safety
        (theAdapteeParent ->*setMethod)((unsigned short) val);
    //#]
}



#endif  
/*********************************************************************
File Path : ../TemplatedAdapters.h
*********************************************************************/
//!$Log: TemplatedAdapters.h $
//!Revision 1.28  2007/04/04 10:08:17  ilgiga
//!bug fix 101241
 

