#!/bin/sh
#
#	Open Watcom Installer. Linux Host. QNX4 Target.
#	CBD BC (C) 2008. All rights reserved.
#	Author: Michael Kolesov
#

echo
echo "########################################################"
echo "#                                                      #"
echo "# Open Watcom Installer for QNX4 Target. Linux Host    #"
echo "# V1.00, 29 Dec 2008                                   #"
echo "#                                                      #"
echo "# CBD BC (C) 2008. All rights reserved.                #"
echo "# For bugs and issues please mail to support@kpda.ru   #"
echo "#                                                      #"
echo "########################################################"
echo "Press ENTER to continue.."
read

# ######################################################
# #							 #
# #		Configuration Area			 #
# #							 #
# ######################################################

# Path to watcom qnx4 target headers place
W_Q4_H=/opt/open_watcom_1.7.1/rel2/h/qnx4

# Path to watcom qnx4 target libraries place
W_Q4_L=/opt/open_watcom_1.7.1/rel2/lib386/qnx4

# Path to original qnx4 headers
Q4_ORIG_H=/root/qnx4/include

# Path to original qnx4 libraries
Q4_ORIG_L=/root/qnx4/lib

# Path to watcom osi (os independent) headers (c++, math, emu)
W_H=/opt/open_watcom_1.7.1/rel2/h

# Path to watcom osi (os independent) libraries (c++, math, emu)
W_L=/opt/open_watcom_1.7.1/rel2/lib386

# Path to rebuilded qnx4 binaries (debug server, trap file)
W_Q4_B=/opt/open_watcom_1.7.1/rel2/binq

# Path to watcom binary 
W_B=/opt/open_watcom_1.7.1/rel2/binl

# ######################################################

echo
echo "At first, clear all instalation paths (if exist):"
echo "Press ENTER to continue.."
read

if [ -d $W_Q4_H ]
then
    echo "$W_Q4_H"
    rm -R -I $W_Q4_H
fi

if [ -d $W_Q4_L ]
then
    echo "$W_Q4_L"
    rm -R -I $W_Q4_L
fi

if [ -d $W_Q4_B ]
then
    echo "$W_Q4_B"
    rm -R -I $W_Q4_B
fi

echo "Done."

echo
echo "Create qnx4 target directories in WATCOM tree"
echo "Press ENTER to continue.."
read

mkdir -p -v $W_Q4_H
mkdir -p -v $W_Q4_L
mkdir -p -v $W_Q4_B

echo "Done."

echo
echo "Copy QNX4 original headers"
echo "Press ENTER to continue.."
read

cp -R -v $Q4_ORIG_H/*.*  $W_Q4_H/

echo "Done."


echo
echo "Copy QNX4 original libraries"
echo "Press ENTER to continue.."
read

cp -R -v $Q4_ORIG_L/*.* $W_Q4_L/

echo "Done."

echo
echo "Copy Watcom C++ headers"
echo "Press ENTER to continue.."
read

cp -v $W_H/complex.h $W_Q4_H
cp -v $W_H/complex $W_Q4_H
cp -v $W_H/except.h $W_Q4_H
cp -v $W_H/fstream.h $W_Q4_H
cp -v $W_H/fstream $W_Q4_H
cp -v $W_H/generic.h $W_Q4_H
cp -v $W_H/iomanip.h $W_Q4_H
cp -v $W_H/iomanip $W_Q4_H
cp -v $W_H/iostream.h $W_Q4_H
cp -v $W_H/iostream $W_Q4_H
cp -v $W_H/new.h $W_Q4_H
cp -v $W_H/new $W_Q4_H
cp -v $W_H/stdiobuf.h $W_Q4_H
cp -v $W_H/streambu.h $W_Q4_H/streambuf.h
cp -v $W_H/streambu $W_Q4_H
cp -v $W_H/string.hpp $W_Q4_H
cp -v $W_H/strstrea.h $W_Q4_H/strstream.h
cp -v $W_H/wcdefs.h $W_Q4_H
cp -v $W_H/strstrea.h $W_Q4_H/strstream.h
cp -v $W_H/strstrea $W_Q4_H
cp -v $W_H/wcexcept.h $W_Q4_H
cp -v $W_H/wchash.h $W_Q4_H
cp -v $W_H/wchbase.h $W_Q4_H
cp -v $W_H/wchiter.h $W_Q4_H
cp -v $W_H/wclbase.h $W_Q4_H
cp -v $W_H/wclcom.h $W_Q4_H
cp -v $W_H/wclibase.h $W_Q4_H
cp -v $W_H/wclist.h $W_Q4_H
cp -v $W_H/wclistit.h $W_Q4_H
cp -v $W_H/wcqueue.h $W_Q4_H
cp -v $W_H/wcsbase.h $W_Q4_H
cp -v $W_H/wcsibase.h $W_Q4_H
cp -v $W_H/wcskip.h $W_Q4_H
cp -v $W_H/wcskipit.h $W_Q4_H
cp -v $W_H/wcstack.h $W_Q4_H
cp -v $W_H/wcvbase.h $W_Q4_H
cp -v $W_H/wcvector.h $W_Q4_H
cp -v $W_H/ios.h $W_Q4_H
cp -v $W_H/ios $W_Q4_H
cp -v $W_H/istream.h $W_Q4_H
cp -v $W_H/istream  $W_Q4_H
cp -v $W_H/ostream.h $W_Q4_H
cp -v $W_H/ostream $W_Q4_H
cp -v $W_H/cstring $W_Q4_H

# ..and some not c++..
cp -v $W_H/_comdef.h $W_Q4_H
cp -v $W_H/cstddef $W_Q4_H
cp -v $W_H/stddef.h $W_Q4_H
cp -v $W_H/ctype.h $W_Q4_H
cp -v $W_H/cctype $W_Q4_H

echo "Done."

echo
echo "Copy Watcom C++ libraries"
echo "Press ENTER to continue.."
read

cp -v $W_L/cplx3r.lib $W_Q4_L
cp -v $W_L/cplx3s.lib $W_Q4_L
cp -v $W_L/plbx3r.lib $W_Q4_L
cp -v $W_L/plbx3s.lib $W_Q4_L
cp -v $W_L/plib3r.lib $W_Q4_L
cp -v $W_L/plib3s.lib $W_Q4_L

echo "Done."

echo 
echo "Copy Additional QNX and CBD_BC Utilities"
echo "Press ENTER to continue.."
read

cp -v "$PWD/binl/cc" $W_B
cp -v "$PWD/binq/std.trp" $W_Q4_B
cp -v "$PWD/binq/tcpserv" $W_Q4_B

echo "Done."

echo
echo "Installation complete!"
echo
