#!/bin/sh

# Build script for XZ Utils 5.0.1
# (c) CBD BC, Oleg Bolshakov, 2011
# http://www.kpda.ru

VERS=5.0.1	# SAMBA version
JOBS=12		# Number of make jobs

TRG=i386-unknown-qnx		# Target platform
PREFIX=usr			# Install prefix
DOCDIR=/etc/readme/technotes/xz	# Doc prefix

CC="${PWD}/xz-${VERS}/wacc.sh"
#CFLAGS=-Wc,-za99
CFLAGS=-DQNX4
CPP="${PWD}/xz-${VERS}/wacc.sh -E"
LD="${PWD}/xz-${VERS}/wacc.sh"
LDFLAGS=
RANLIB=touch
AR="${PWD}/xz-${VERS}/wacc.sh"
ARFLAGS="-A"
LIBS=-lowc
CONFOPT=


# Unpack source
rm -rf xz-${VERS}-${TRG} xz-${VERS}
tar xf xz-${VERS}.tar.xz

# Build xz
UPDIR=${PWD}
cd xz-${VERS}
zcat ../xz-${VERS}-qnx4.patch.gz | patch -p1
chmod +x wacc.sh setup.qnx4
CC=${CC} CPP=${CPP} CFLAGS=${CFLAGS} LD=${LD} RANLIB=${RANLIB} \
    AR=${AR} ARFLAGS=${ARFLAGS} LIBS=${LIBS} ac_cv_prog_cc_c99= \
    ./configure --host=${TRG} --prefix=/${PREFIX} --docdir=${DOCDIR} \
    --enable-shared=no --enable-static=yes --disable-threads \
    ${CONFOPT}
make ARFLAGS=${ARFLAGS} -j ${JOBS}
make prefix=${UPDIR}/xz-${VERS}-${TRG}/${PREFIX} \
    docdir=${UPDIR}/xz-${VERS}-${TRG}/${DOCDIR} install
cp setup.qnx4 ${UPDIR}/xz-${VERS}-${TRG}/setup
cd ${UPDIR}

# Create bundle
UPDIR=${PWD}
cd xz-${VERS}-${TRG}
rm -rf ${PREFIX}/lib/pkgconfig ${PREFIX}/lib/*.la
mv ${PREFIX}/lib/liblzma.a ${PREFIX}/lib/lzma.lib
echo XZ Utils ${VERS} runtime build created by CBD BC > _xz_vers.txt
tar --owner=root --group=root -zcf ../xz-${VERS}-qnx4-bin-`date +%Y%m%d`.tar.gz *
cd ${UPDIR}

# Clean
#rm -rf xz-${VERS}-${TRG} xz-${VERS}

