#!/bin/sh

# Build script for SAMBA 3.5.6
# (c) CBD BC, Oleg Bolshakov, 2011
# http://www.kpda.ru

VERS=3.6.25	# SAMBA version
JOBS=12		# Number of make jobs

TRG=i486-pc-nto-qnx6.5.0	# Target platform
TRG_PREFIX=x86				# Target platform prefix
PREFIX=usr/samba3			# Install prefix

CFLAGS=
LDFLAGS=


# Build additional Samba library
build_lib () {

    UPDIR=`pwd`
    cd samba-${VERS}/${1}
    ./configure --host=${TRG} --prefix=/${PREFIX} ${2}
    make -j ${JOBS}
    make prefix=${UPDIR}/samba-${VERS}-${TRG}/${TRG_PREFIX}/${PREFIX} install
    cd ${UPDIR}
}


# Unpack source
rm -rf samba-${VERS}-${TRG} samba-${VERS}
tar xf samba-${VERS}.tar.gz
patch -p1 <./samba-3.6.25-CVE-2017-7494.patch


# Build required libs
build_lib lib/talloc
build_lib lib/replace
build_lib lib/tdb --disable-python


# Build samba3
UPDIR=`pwd`
cd samba-${VERS}/source3
samba_cv_CC_NEGATIVE_ENUM_VALUES=yes libreplace_cv_HAVE_GETADDRINFO=no \
 ac_cv_file__proc_sys_kernel_core_pattern=yes samba_cv_USE_SETEUID=yes \
 CFLAGS="${CFLAGS} -I${UPDIR}/samba-${VERS}-${TRG}/${TRG_PREFIX}/${PREFIX}/include" \
 LDFLAGS="${LDFLAGS} -L${UPDIR}/samba-${VERS}-${TRG}/${TRG_PREFIX}/${PREFIX}/lib" \
 ./configure --host=${TRG} --prefix=/${PREFIX} --with-configdir=\$\{prefix\}/etc
make -j ${JOBS} PTHREAD_LDFLAGS=
make prefix=${UPDIR}/samba-${VERS}-${TRG}/${TRG_PREFIX}/${PREFIX} install
cd ${UPDIR}


# Create bundle
UPDIR=`pwd`
cd samba-${VERS}-${TRG}
rm -rf ${TRG_PREFIX}/${PREFIX}/share/man
mkdir ${TRG_PREFIX}/${PREFIX}/etc
sed "s/usr\/local\/samba/usr\/samba3/g" ../samba-${VERS}/examples/smb.conf.default > ${TRG_PREFIX}/${PREFIX}/etc/smb.conf.default
tar --owner=root --group=root -jcf ../samba-${VERS}-${TRG}-`date +%Y%m%d`.tar.bz2 *
cd ${UPDIR}


# Clean
rm -rf samba-${VERS}-${TRG} samba-${VERS}

