/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.rhapsody.oxf.timeouts;

import com.ibm.rational.rhapsody.oxf.RiJEvent;
import com.ibm.rational.rhapsody.oxf.RiJEventConsumer;
import com.ibm.rational.rhapsody.oxf.timeouts.RiJTimeoutManager;

public class RiJTimeout
extends RiJEvent {
    public Thread creatingThread;
    protected long dueTime;
    protected String stateName;
    protected long timeInterval;
    protected long timeoutID;
    protected RiJTimeoutManager timeoutManager;

    public RiJTimeout(long tmID, RiJEventConsumer destination, long timeInterval, String stateName) {
        super(-2L, destination);
        this.timeInterval = timeInterval;
        this.timeoutID = tmID;
        this.stateName = stateName;
        this.creatingThread = Thread.currentThread();
    }

    public RiJTimeout(long tmID, RiJEventConsumer destination, long timeInterval) {
        this(tmID, destination, timeInterval, "No State");
    }

    public boolean equals(Object tmObj) {
        RiJTimeout tm = (RiJTimeout)tmObj;
        return tm.timeoutID == this.timeoutID && tm.destination == this.destination;
    }

    public long getDueTime() {
        return this.dueTime;
    }

    public long getTimeInterval() {
        return this.timeInterval;
    }

    public long getTimeoutID() {
        return this.timeoutID;
    }

    public long getTimeoutId() {
        return this.timeoutID;
    }

    public RiJTimeoutManager getTimerManager() {
        return this.timeoutManager;
    }

    public boolean gt(RiJTimeout tm) {
        if (this.dueTime == tm.dueTime) {
            return this.timeoutID > tm.timeoutID;
        }
        return this.dueTime > tm.dueTime;
    }

    public void resetDueTime(long now) {
        this.dueTime = now + this.timeInterval;
    }

    public void toDestination() {
        super.toDestination();
        if (this.timeoutManager != null) {
            this.timeoutManager.removeExpiredTimeout(this);
        }
    }

    public Thread getCreatingThread() {
        return this.creatingThread;
    }

    public String getStateName() {
        return this.stateName;
    }

    public RiJTimeoutManager getTimeoutManager() {
        return this.timeoutManager;
    }

    public void setTimeoutManager(RiJTimeoutManager p_RiJTimeoutManager) {
        this.timeoutManager = p_RiJTimeoutManager;
    }
}

