/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.rhapsody.oxf.services;

public class RiJSemaphore {
    public static final short NOT_ALLOWED = -2;
    public static final short REACHED_MAX = -1;
    public static final short SUCCESS = 0;
    private int counter;
    private int maxLockers;
    private Thread[] threads;

    public RiJSemaphore(int initialCount, int maxCount) {
        this.counter = initialCount;
        this.maxLockers = maxCount;
        this.threads = new Thread[maxCount + 1];
    }

    protected synchronized int countLockers() {
        int i;
        for (i = 0; i < this.threads.length && this.threads[i] != null; ++i) {
        }
        return i;
    }

    protected synchronized int findFreeSpot() {
        for (int i = 0; i < this.threads.length; ++i) {
            if (this.threads[i] != null) continue;
            return i;
        }
        return -1;
    }

    protected synchronized int findLocker(Thread thread) {
        for (int i = 0; i < this.threads.length; ++i) {
            if (this.threads[i] != thread) continue;
            return i;
        }
        return -1;
    }

    public synchronized short increaseCounter() {
        if (this.counter + this.countLockers() >= this.maxLockers) {
            return -1;
        }
        if (this.findLocker(Thread.currentThread()) < 0) {
            return -2;
        }
        ++this.counter;
        this.notify();
        return 0;
    }

    public synchronized void lock(long timeout) throws InterruptedException {
        Thread currentThread = Thread.currentThread();
        if (this.findLocker(currentThread) > -1) {
            return;
        }
        if (this.counter == 0) {
            this.wait(timeout);
        }
        --this.counter;
        this.threads[this.findFreeSpot()] = currentThread;
    }

    public synchronized void lock() throws InterruptedException {
        this.lock(0L);
    }

    public synchronized short release() {
        if (this.counter == this.maxLockers) {
            return -1;
        }
        if (!this.removeLocker(Thread.currentThread())) {
            return -2;
        }
        ++this.counter;
        this.notify();
        return 0;
    }

    protected synchronized boolean removeLocker(Thread thread) {
        int pos = this.findLocker(thread);
        if (pos > -1) {
            this.threads[pos] = null;
            return true;
        }
        return false;
    }
}

