/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.rhapsody.oxf;

import com.ibm.rational.rhapsody.oxf.RiJActive;
import com.ibm.rational.rhapsody.oxf.RiJEvent;
import com.ibm.rational.rhapsody.oxf.RiJEventConsumer;
import com.ibm.rational.rhapsody.oxf.RiJEventDispatcher;
import com.ibm.rational.rhapsody.oxf.RiJEventQueue;
import com.ibm.rational.rhapsody.oxf.RiJReactive;
import com.ibm.rational.rhapsody.oxf.timeouts.RiJTimeout;
import com.ibm.rational.rhapsody.oxf.timeouts.RiJTimeoutManager;
import com.ibm.rational.rhapsody.oxfinst.AnimServices;

public class RiJThread
extends RiJEventDispatcher
implements RiJActive {
    protected static final int WAIT_TIME = 1000;
    protected String name;
    protected int priority;
    protected volatile Thread thread;
    protected boolean threadSuspend = false;
    protected boolean wasStarted = false;

    public RiJThread() {
        this(null);
    }

    public RiJThread(String name) {
        this(name, 5);
    }

    public RiJThread(String name, int priority) {
        this(name, priority, null);
    }

    public RiJThread(boolean wrapperThread) {
        this();
    }

    public RiJThread(String name, int priority, Runnable runnable) {
        this.name = name;
        this.priority = priority;
    }

    protected void createNewThread(Runnable runnable) {
        if (this.thread != null) {
            this.thread = null;
        }
        if (runnable == null) {
            runnable = this;
        }
        this.thread = this.name == null ? new Thread(runnable) : new Thread(runnable, this.name);
        this.thread.setPriority(this.priority);
        AnimServices.initAnimThread(this);
    }

    protected void execute() {
        while (!this.eventQueue.isEmpty()) {
            if (this.threadSuspend) {
                return;
            }
            this.dispatchNextEvent();
            AnimServices.notifyEvent(this);
        }
    }

    public Thread getJThread() {
        return this.thread;
    }

    public String getName() {
        return this.name;
    }

    public int getPriority() {
        return this.priority;
    }

    public void init() {
    }

    public boolean isStarted() {
        return this.wasStarted;
    }

    public boolean isSuspended() {
        return this.threadSuspend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueEvent(RiJEvent i_event) {
        RiJEventQueue riJEventQueue = this.eventQueue;
        synchronized (riJEventQueue) {
            super.queueEvent(i_event);
            this.eventQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        this.threadSuspend = false;
        RiJThread riJThread = this;
        synchronized (riJThread) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.wasStarted = true;
        Thread thisThread = Thread.currentThread();
        RiJTimeoutManager.instance().incNonIdleCount();
        while (thisThread == this.thread) {
            Object object = this;
            synchronized (object) {
                while (this.threadSuspend) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {}
                }
            }
            RiJTimeoutManager.instance().decNonIdleCount();
            object = this.eventQueue;
            synchronized (object) {
                while (this.eventQueue.isEmpty()) {
                    AnimServices.notifyIdle(this);
                    try {
                        this.eventQueue.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            RiJTimeoutManager.instance().incNonIdleCount();
            this.execute();
        }
    }

    public void schedTimeout(long delay, long timeoutID, RiJReactive reactive, String stateName) {
        RiJTimeout timeout = new RiJTimeout(timeoutID, reactive, delay, stateName);
        RiJTimeoutManager tManager = RiJTimeoutManager.instance();
        tManager.schedTimeout(timeout, reactive.getItsRiJThread());
    }

    public void schedTimeout(long delay, long timeoutID, RiJReactive reactive) {
        this.schedTimeout(delay, timeoutID, reactive, "No State");
    }

    public void setName(String name) {
        this.name = name;
    }

    protected synchronized boolean setThread(Thread theThread) {
        boolean status;
        boolean bl = status = this.thread == null;
        if (this.thread == null) {
            this.thread = theThread;
        }
        return status;
    }

    public void start() {
        this.start(this);
    }

    public void start(Runnable runnable) {
        if (this.thread == null || runnable != null && runnable != this) {
            this.createNewThread(runnable);
        }
        AnimServices.threadStart(this, runnable);
        this.thread.start();
    }

    public void start(boolean doFork) {
        this.start();
    }

    public boolean started() {
        return this.wasStarted;
    }

    public synchronized void stop() {
        this.thread = null;
    }

    public synchronized void suspend() {
        this.threadSuspend = true;
    }

    public void unschedTimeout(long timeoutID, RiJEventConsumer dest) {
        RiJTimeout dummyTm = new RiJTimeout(timeoutID, dest, 0L);
        RiJTimeoutManager.instance().unschedTimeout(dummyTm);
    }

    public void unsynchQueueEvent(RiJEvent i_event) {
        if (AnimServices.isAnimThreadSuspended(this)) {
            super.queueEvent(i_event);
        } else {
            this.queueEvent(i_event);
        }
    }
}

